/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.SingleMasterConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSignalingChannelRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UpdateSignalingChannelRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelARN").getter(UpdateSignalingChannelRequest.getter(UpdateSignalingChannelRequest::channelARN)).setter(UpdateSignalingChannelRequest.setter(Builder::channelARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateSignalingChannelRequest.getter(UpdateSignalingChannelRequest::currentVersion)).setter(UpdateSignalingChannelRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()}).build();
    private static final SdkField<SingleMasterConfiguration> SINGLE_MASTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleMasterConfiguration").getter(UpdateSignalingChannelRequest.getter(UpdateSignalingChannelRequest::singleMasterConfiguration)).setter(UpdateSignalingChannelRequest.setter(Builder::singleMasterConfiguration)).constructor(SingleMasterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMasterConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CURRENT_VERSION_FIELD, SINGLE_MASTER_CONFIGURATION_FIELD));
    private final String channelARN;
    private final String currentVersion;
    private final SingleMasterConfiguration singleMasterConfiguration;

    private UpdateSignalingChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.currentVersion = builder.currentVersion;
        this.singleMasterConfiguration = builder.singleMasterConfiguration;
    }

    public final String channelARN() {
        return this.channelARN;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final SingleMasterConfiguration singleMasterConfiguration() {
        return this.singleMasterConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleMasterConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSignalingChannelRequest)) {
            return false;
        }
        UpdateSignalingChannelRequest other = (UpdateSignalingChannelRequest)((Object)obj);
        return Objects.equals(this.channelARN(), other.channelARN()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.singleMasterConfiguration(), other.singleMasterConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSignalingChannelRequest").add("ChannelARN", (Object)this.channelARN()).add("CurrentVersion", (Object)this.currentVersion()).add("SingleMasterConfiguration", (Object)this.singleMasterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelARN": {
                return Optional.ofNullable(clazz.cast(this.channelARN()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "SingleMasterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.singleMasterConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSignalingChannelRequest, T> g) {
        return obj -> g.apply((UpdateSignalingChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String channelARN;
        private String currentVersion;
        private SingleMasterConfiguration singleMasterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSignalingChannelRequest model) {
            super(model);
            this.channelARN(model.channelARN);
            this.currentVersion(model.currentVersion);
            this.singleMasterConfiguration(model.singleMasterConfiguration);
        }

        public final String getChannelARN() {
            return this.channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        @Transient
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        @Transient
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final SingleMasterConfiguration.Builder getSingleMasterConfiguration() {
            return this.singleMasterConfiguration != null ? this.singleMasterConfiguration.toBuilder() : null;
        }

        public final void setSingleMasterConfiguration(SingleMasterConfiguration.BuilderImpl singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration != null ? singleMasterConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSignalingChannelRequest build() {
            return new UpdateSignalingChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSignalingChannelRequest> {
        public Builder channelARN(String var1);

        public Builder currentVersion(String var1);

        public Builder singleMasterConfiguration(SingleMasterConfiguration var1);

        default public Builder singleMasterConfiguration(Consumer<SingleMasterConfiguration.Builder> singleMasterConfiguration) {
            return this.singleMasterConfiguration((SingleMasterConfiguration)((SingleMasterConfiguration.Builder)SingleMasterConfiguration.builder().applyMutation(singleMasterConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

