/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelProtocol;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelRole;
import software.amazon.awssdk.services.kinesisvideo.model.ListOfProtocolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SingleMasterChannelEndpointConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SingleMasterChannelEndpointConfiguration> {
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(SingleMasterChannelEndpointConfiguration.getter(SingleMasterChannelEndpointConfiguration::protocolsAsStrings)).setter(SingleMasterChannelEndpointConfiguration.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(SingleMasterChannelEndpointConfiguration.getter(SingleMasterChannelEndpointConfiguration::roleAsString)).setter(SingleMasterChannelEndpointConfiguration.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOLS_FIELD, ROLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> protocols;
    private final String role;

    private SingleMasterChannelEndpointConfiguration(BuilderImpl builder) {
        this.protocols = builder.protocols;
        this.role = builder.role;
    }

    public final List<ChannelProtocol> protocols() {
        return ListOfProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final ChannelRole role() {
        return ChannelRole.fromValue(this.role);
    }

    public final String roleAsString() {
        return this.role;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMasterChannelEndpointConfiguration)) {
            return false;
        }
        SingleMasterChannelEndpointConfiguration other = (SingleMasterChannelEndpointConfiguration)obj;
        return this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.roleAsString(), other.roleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SingleMasterChannelEndpointConfiguration").add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("Role", (Object)this.roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.roleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleMasterChannelEndpointConfiguration, T> g) {
        return obj -> g.apply((SingleMasterChannelEndpointConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleMasterChannelEndpointConfiguration model) {
            this.protocolsWithStrings(model.protocols);
            this.role(model.role);
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ListOfProtocolsCopier.copy(protocols);
        }

        @Override
        @Transient
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ListOfProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        @Transient
        public final Builder protocols(Collection<ChannelProtocol> protocols) {
            this.protocols = ListOfProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder protocols(ChannelProtocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        @Transient
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        @Transient
        public final Builder role(ChannelRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public SingleMasterChannelEndpointConfiguration build() {
            return new SingleMasterChannelEndpointConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SingleMasterChannelEndpointConfiguration> {
        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<ChannelProtocol> var1);

        public Builder protocols(ChannelProtocol ... var1);

        public Builder role(String var1);

        public Builder role(ChannelRole var1);
    }
}

