/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleMasterChannelEndpointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SingleMasterChannelEndpointConfiguration.Builder, SingleMasterChannelEndpointConfiguration> {
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Protocols")
            .getter(getter(SingleMasterChannelEndpointConfiguration::protocolsAsStrings))
            .setter(setter(Builder::protocolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(SingleMasterChannelEndpointConfiguration::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOLS_FIELD, ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> protocols;

    private final String role;

    private SingleMasterChannelEndpointConfiguration(BuilderImpl builder) {
        this.protocols = builder.protocols;
        this.role = builder.role;
    }

    /**
     * <p>
     * This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling
     * channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is
     * specified, this API returns an <code>HTTPS</code> endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code>
     *         signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If
     *         <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.
     */
    public final List<ChannelProtocol> protocols() {
        return ListOfProtocolsCopier.copyStringToEnum(protocols);
    }

    /**
     * Returns true if the Protocols property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProtocols() {
        return protocols != null && !(protocols instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling
     * channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is
     * specified, this API returns an <code>HTTPS</code> endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProtocols()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code>
     *         signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If
     *         <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.
     */
    public final List<String> protocolsAsStrings() {
        return protocols;
    }

    /**
     * <p>
     * This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling channel. If
     * <code>MASTER</code> is specified, this API returns an endpoint that a client can use to receive offers from and
     * send answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is specified, this API
     * returns an endpoint that a client can use only to send offers to another <code>MASTER</code> client on this
     * signaling channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link ChannelRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling
     *         channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to
     *         receive offers from and send answers to any of the viewers on this signaling channel. If
     *         <code>VIEWER</code> is specified, this API returns an endpoint that a client can use only to send offers
     *         to another <code>MASTER</code> client on this signaling channel.
     * @see ChannelRole
     */
    public final ChannelRole role() {
        return ChannelRole.fromValue(role);
    }

    /**
     * <p>
     * This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling channel. If
     * <code>MASTER</code> is specified, this API returns an endpoint that a client can use to receive offers from and
     * send answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is specified, this API
     * returns an endpoint that a client can use only to send offers to another <code>MASTER</code> client on this
     * signaling channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link ChannelRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling
     *         channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to
     *         receive offers from and send answers to any of the viewers on this signaling channel. If
     *         <code>VIEWER</code> is specified, this API returns an endpoint that a client can use only to send offers
     *         to another <code>MASTER</code> client on this signaling channel.
     * @see ChannelRole
     */
    public final String roleAsString() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProtocols() ? protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMasterChannelEndpointConfiguration)) {
            return false;
        }
        SingleMasterChannelEndpointConfiguration other = (SingleMasterChannelEndpointConfiguration) obj;
        return hasProtocols() == other.hasProtocols() && Objects.equals(protocolsAsStrings(), other.protocolsAsStrings())
                && Objects.equals(roleAsString(), other.roleAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleMasterChannelEndpointConfiguration")
                .add("Protocols", hasProtocols() ? protocolsAsStrings() : null).add("Role", roleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocols":
            return Optional.ofNullable(clazz.cast(protocolsAsStrings()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleMasterChannelEndpointConfiguration, T> g) {
        return obj -> g.apply((SingleMasterChannelEndpointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleMasterChannelEndpointConfiguration> {
        /**
         * <p>
         * This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling
         * channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is
         * specified, this API returns an <code>HTTPS</code> endpoint.
         * </p>
         * 
         * @param protocols
         *        This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code>
         *        signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If
         *        <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(Collection<String> protocols);

        /**
         * <p>
         * This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling
         * channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is
         * specified, this API returns an <code>HTTPS</code> endpoint.
         * </p>
         * 
         * @param protocols
         *        This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code>
         *        signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If
         *        <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocolsWithStrings(String... protocols);

        /**
         * <p>
         * This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling
         * channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is
         * specified, this API returns an <code>HTTPS</code> endpoint.
         * </p>
         * 
         * @param protocols
         *        This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code>
         *        signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If
         *        <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(Collection<ChannelProtocol> protocols);

        /**
         * <p>
         * This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling
         * channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is
         * specified, this API returns an <code>HTTPS</code> endpoint.
         * </p>
         * 
         * @param protocols
         *        This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code>
         *        signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If
         *        <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocols(ChannelProtocol... protocols);

        /**
         * <p>
         * This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling
         * channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to receive
         * offers from and send answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is
         * specified, this API returns an endpoint that a client can use only to send offers to another
         * <code>MASTER</code> client on this signaling channel.
         * </p>
         * 
         * @param role
         *        This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling
         *        channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to
         *        receive offers from and send answers to any of the viewers on this signaling channel. If
         *        <code>VIEWER</code> is specified, this API returns an endpoint that a client can use only to send
         *        offers to another <code>MASTER</code> client on this signaling channel.
         * @see ChannelRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelRole
         */
        Builder role(String role);

        /**
         * <p>
         * This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling
         * channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to receive
         * offers from and send answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is
         * specified, this API returns an endpoint that a client can use only to send offers to another
         * <code>MASTER</code> client on this signaling channel.
         * </p>
         * 
         * @param role
         *        This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling
         *        channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to
         *        receive offers from and send answers to any of the viewers on this signaling channel. If
         *        <code>VIEWER</code> is specified, this API returns an endpoint that a client can use only to send
         *        offers to another <code>MASTER</code> client on this signaling channel.
         * @see ChannelRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelRole
         */
        Builder role(ChannelRole role);
    }

    static final class BuilderImpl implements Builder {
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleMasterChannelEndpointConfiguration model) {
            protocolsWithStrings(model.protocols);
            role(model.role);
        }

        public final Collection<String> getProtocols() {
            if (protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return protocols;
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ListOfProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String... protocols) {
            protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<ChannelProtocol> protocols) {
            this.protocols = ListOfProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(ChannelProtocol... protocols) {
            protocols(Arrays.asList(protocols));
            return this;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ListOfProtocolsCopier.copy(protocols);
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(ChannelRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public SingleMasterChannelEndpointConfiguration build() {
            return new SingleMasterChannelEndpointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
