/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.model.AccessDeniedException;
import software.amazon.awssdk.services.kinesisvideo.model.AccountChannelLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.AccountStreamLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.CreateSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.CreateSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeviceStreamLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.GetDataEndpointRequest;
import software.amazon.awssdk.services.kinesisvideo.model.GetDataEndpointResponse;
import software.amazon.awssdk.services.kinesisvideo.model.GetSignalingChannelEndpointRequest;
import software.amazon.awssdk.services.kinesisvideo.model.GetSignalingChannelEndpointResponse;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidDeviceException;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidResourceFormatException;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoException;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideo.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisvideo.model.TagStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.TagsPerResourceExceededLimitException;
import software.amazon.awssdk.services.kinesisvideo.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.VersionMismatchException;
import software.amazon.awssdk.services.kinesisvideo.paginators.ListSignalingChannelsPublisher;
import software.amazon.awssdk.services.kinesisvideo.paginators.ListStreamsPublisher;
import software.amazon.awssdk.services.kinesisvideo.transform.CreateSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DeleteSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.GetDataEndpointRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.GetSignalingChannelEndpointRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListSignalingChannelsRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListTagsForStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.TagStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UntagStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateDataRetentionRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateStreamRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultKinesisVideoAsyncClient
implements KinesisVideoAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKinesisVideoAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    @Override
    public CompletableFuture<CreateSignalingChannelResponse> createSignalingChannel(CreateSignalingChannelRequest createSignalingChannelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSignalingChannelResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSignalingChannel").withMarshaller((Marshaller)new CreateSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSignalingChannelRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest createStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStream").withMarshaller((Marshaller)new CreateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSignalingChannelResponse> deleteSignalingChannel(DeleteSignalingChannelRequest deleteSignalingChannelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSignalingChannelResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSignalingChannel").withMarshaller((Marshaller)new DeleteSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSignalingChannelRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest deleteStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStream").withMarshaller((Marshaller)new DeleteStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSignalingChannelResponse> describeSignalingChannel(DescribeSignalingChannelRequest describeSignalingChannelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSignalingChannelResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSignalingChannel").withMarshaller((Marshaller)new DescribeSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSignalingChannelRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStream").withMarshaller((Marshaller)new DescribeStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataEndpointResponse> getDataEndpoint(GetDataEndpointRequest getDataEndpointRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataEndpointResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataEndpoint").withMarshaller((Marshaller)new GetDataEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDataEndpointRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSignalingChannelEndpointResponse> getSignalingChannelEndpoint(GetSignalingChannelEndpointRequest getSignalingChannelEndpointRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSignalingChannelEndpointResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSignalingChannelEndpoint").withMarshaller((Marshaller)new GetSignalingChannelEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSignalingChannelEndpointRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSignalingChannelsResponse> listSignalingChannels(ListSignalingChannelsRequest listSignalingChannelsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSignalingChannelsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSignalingChannels").withMarshaller((Marshaller)new ListSignalingChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSignalingChannelsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListSignalingChannelsPublisher listSignalingChannelsPaginator(ListSignalingChannelsRequest listSignalingChannelsRequest) {
        return new ListSignalingChannelsPublisher(this, this.applyPaginatorUserAgent(listSignalingChannelsRequest));
    }

    @Override
    public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreams").withMarshaller((Marshaller)new ListStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listStreamsRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListStreamsPublisher listStreamsPaginator(ListStreamsRequest listStreamsRequest) {
        return new ListStreamsPublisher(this, this.applyPaginatorUserAgent(listStreamsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForStreamResponse> listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForStream").withMarshaller((Marshaller)new ListTagsForStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagStreamResponse> tagStream(TagStreamRequest tagStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagStream").withMarshaller((Marshaller)new TagStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagStreamResponse> untagStream(UntagStreamRequest untagStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagStream").withMarshaller((Marshaller)new UntagStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataRetentionResponse> updateDataRetention(UpdateDataRetentionRequest updateDataRetentionRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRetentionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRetention").withMarshaller((Marshaller)new UpdateDataRetentionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDataRetentionRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSignalingChannelResponse> updateSignalingChannel(UpdateSignalingChannelRequest updateSignalingChannelRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSignalingChannelResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSignalingChannel").withMarshaller((Marshaller)new UpdateSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSignalingChannelRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStreamResponse> updateStream(UpdateStreamRequest updateStreamRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStreamResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStream").withMarshaller((Marshaller)new UpdateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStreamRequest));
            return executeFuture;
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VersionMismatchException").exceptionBuilderSupplier(VersionMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDeviceException").exceptionBuilderSupplier(InvalidDeviceException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").exceptionBuilderSupplier(ClientLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").exceptionBuilderSupplier(InvalidResourceFormatException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private <T extends KinesisVideoRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.10.41").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KinesisVideoRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}

