/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationInputResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, AddApplicationInputResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddApplicationInputResponse.getter(AddApplicationInputResponse::applicationARN)).setter(AddApplicationInputResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AddApplicationInputResponse.getter(AddApplicationInputResponse::applicationVersionId)).setter(AddApplicationInputResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<List<InputDescription>> INPUT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddApplicationInputResponse.getter(AddApplicationInputResponse::inputDescriptions)).setter(AddApplicationInputResponse.setter(Builder::inputDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD, INPUT_DESCRIPTIONS_FIELD));
    private final String applicationARN;
    private final Long applicationVersionId;
    private final List<InputDescription> inputDescriptions;

    private AddApplicationInputResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.inputDescriptions = builder.inputDescriptions;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public List<InputDescription> inputDescriptions() {
        return this.inputDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDescriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputResponse)) {
            return false;
        }
        AddApplicationInputResponse other = (AddApplicationInputResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.inputDescriptions(), other.inputDescriptions());
    }

    public String toString() {
        return ToString.builder((String)"AddApplicationInputResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("InputDescriptions", this.inputDescriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "InputDescriptions": {
                return Optional.ofNullable(clazz.cast(this.inputDescriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationInputResponse, T> g) {
        return obj -> g.apply((AddApplicationInputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;
        private List<InputDescription> inputDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
            this.inputDescriptions(model.inputDescriptions);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final Collection<InputDescription.Builder> getInputDescriptions() {
            return this.inputDescriptions != null ? (Collection)this.inputDescriptions.stream().map(InputDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription ... inputDescriptions) {
            this.inputDescriptions(Arrays.asList(inputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(Consumer<InputDescription.Builder> ... inputDescriptions) {
            this.inputDescriptions(Stream.of(inputDescriptions).map(c -> (InputDescription)((InputDescription.Builder)InputDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDescriptions(Collection<InputDescription.BuilderImpl> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copyFromBuilder(inputDescriptions);
        }

        @Override
        public AddApplicationInputResponse build() {
            return new AddApplicationInputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationInputResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);

        public Builder inputDescriptions(Collection<InputDescription> var1);

        public Builder inputDescriptions(InputDescription ... var1);

        public Builder inputDescriptions(Consumer<InputDescription.Builder> ... var1);
    }
}

