/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.Input;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.Output;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSource;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlApplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlApplicationConfiguration> {
    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SqlApplicationConfiguration.getter(SqlApplicationConfiguration::inputs)).setter(SqlApplicationConfiguration.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SqlApplicationConfiguration.getter(SqlApplicationConfiguration::outputs)).setter(SqlApplicationConfiguration.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReferenceDataSource>> REFERENCE_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SqlApplicationConfiguration.getter(SqlApplicationConfiguration::referenceDataSources)).setter(SqlApplicationConfiguration.setter(Builder::referenceDataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUTS_FIELD, OUTPUTS_FIELD, REFERENCE_DATA_SOURCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Input> inputs;
    private final List<Output> outputs;
    private final List<ReferenceDataSource> referenceDataSources;

    private SqlApplicationConfiguration(BuilderImpl builder) {
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.referenceDataSources = builder.referenceDataSources;
    }

    public List<Input> inputs() {
        return this.inputs;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public List<ReferenceDataSource> referenceDataSources() {
        return this.referenceDataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceDataSources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlApplicationConfiguration)) {
            return false;
        }
        SqlApplicationConfiguration other = (SqlApplicationConfiguration)obj;
        return Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.referenceDataSources(), other.referenceDataSources());
    }

    public String toString() {
        return ToString.builder((String)"SqlApplicationConfiguration").add("Inputs", this.inputs()).add("Outputs", this.outputs()).add("ReferenceDataSources", this.referenceDataSources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "ReferenceDataSources": {
                return Optional.ofNullable(clazz.cast(this.referenceDataSources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlApplicationConfiguration, T> g) {
        return obj -> g.apply((SqlApplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();
        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();
        private List<ReferenceDataSource> referenceDataSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlApplicationConfiguration model) {
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.referenceDataSources(model.referenceDataSources);
        }

        public final Collection<Input.Builder> getInputs() {
            return this.inputs != null ? (Collection)this.inputs.stream().map(Input::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (Input)((Input.Builder)Input.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        public final Collection<Output.Builder> getOutputs() {
            return this.outputs != null ? (Collection)this.outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (Output)((Output.Builder)Output.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        public final Collection<ReferenceDataSource.Builder> getReferenceDataSources() {
            return this.referenceDataSources != null ? (Collection)this.referenceDataSources.stream().map(ReferenceDataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder referenceDataSources(Collection<ReferenceDataSource> referenceDataSources) {
            this.referenceDataSources = ReferenceDataSourcesCopier.copy(referenceDataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSources(ReferenceDataSource ... referenceDataSources) {
            this.referenceDataSources(Arrays.asList(referenceDataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSources(Consumer<ReferenceDataSource.Builder> ... referenceDataSources) {
            this.referenceDataSources(Stream.of(referenceDataSources).map(c -> (ReferenceDataSource)((ReferenceDataSource.Builder)ReferenceDataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReferenceDataSources(Collection<ReferenceDataSource.BuilderImpl> referenceDataSources) {
            this.referenceDataSources = ReferenceDataSourcesCopier.copyFromBuilder(referenceDataSources);
        }

        public SqlApplicationConfiguration build() {
            return new SqlApplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlApplicationConfiguration> {
        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder inputs(Consumer<Input.Builder> ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder outputs(Consumer<Output.Builder> ... var1);

        public Builder referenceDataSources(Collection<ReferenceDataSource> var1);

        public Builder referenceDataSources(ReferenceDataSource ... var1);

        public Builder referenceDataSources(Consumer<ReferenceDataSource.Builder> ... var1);
    }
}

