/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeContentUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeContentUpdate> {
    private static final SdkField<String> TEXT_CONTENT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CodeContentUpdate.getter(CodeContentUpdate::textContentUpdate)).setter(CodeContentUpdate.setter(Builder::textContentUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextContentUpdate").build()}).build();
    private static final SdkField<SdkBytes> ZIP_FILE_CONTENT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(CodeContentUpdate.getter(CodeContentUpdate::zipFileContentUpdate)).setter(CodeContentUpdate.setter(Builder::zipFileContentUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFileContentUpdate").build()}).build();
    private static final SdkField<S3ContentLocationUpdate> S3_CONTENT_LOCATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CodeContentUpdate.getter(CodeContentUpdate::s3ContentLocationUpdate)).setter(CodeContentUpdate.setter(Builder::s3ContentLocationUpdate)).constructor(S3ContentLocationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ContentLocationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_CONTENT_UPDATE_FIELD, ZIP_FILE_CONTENT_UPDATE_FIELD, S3_CONTENT_LOCATION_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String textContentUpdate;
    private final SdkBytes zipFileContentUpdate;
    private final S3ContentLocationUpdate s3ContentLocationUpdate;

    private CodeContentUpdate(BuilderImpl builder) {
        this.textContentUpdate = builder.textContentUpdate;
        this.zipFileContentUpdate = builder.zipFileContentUpdate;
        this.s3ContentLocationUpdate = builder.s3ContentLocationUpdate;
    }

    public String textContentUpdate() {
        return this.textContentUpdate;
    }

    public SdkBytes zipFileContentUpdate() {
        return this.zipFileContentUpdate;
    }

    public S3ContentLocationUpdate s3ContentLocationUpdate() {
        return this.s3ContentLocationUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textContentUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipFileContentUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ContentLocationUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeContentUpdate)) {
            return false;
        }
        CodeContentUpdate other = (CodeContentUpdate)obj;
        return Objects.equals(this.textContentUpdate(), other.textContentUpdate()) && Objects.equals(this.zipFileContentUpdate(), other.zipFileContentUpdate()) && Objects.equals(this.s3ContentLocationUpdate(), other.s3ContentLocationUpdate());
    }

    public String toString() {
        return ToString.builder((String)"CodeContentUpdate").add("TextContentUpdate", (Object)this.textContentUpdate()).add("ZipFileContentUpdate", (Object)this.zipFileContentUpdate()).add("S3ContentLocationUpdate", (Object)this.s3ContentLocationUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextContentUpdate": {
                return Optional.ofNullable(clazz.cast(this.textContentUpdate()));
            }
            case "ZipFileContentUpdate": {
                return Optional.ofNullable(clazz.cast(this.zipFileContentUpdate()));
            }
            case "S3ContentLocationUpdate": {
                return Optional.ofNullable(clazz.cast(this.s3ContentLocationUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeContentUpdate, T> g) {
        return obj -> g.apply((CodeContentUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String textContentUpdate;
        private SdkBytes zipFileContentUpdate;
        private S3ContentLocationUpdate s3ContentLocationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeContentUpdate model) {
            this.textContentUpdate(model.textContentUpdate);
            this.zipFileContentUpdate(model.zipFileContentUpdate);
            this.s3ContentLocationUpdate(model.s3ContentLocationUpdate);
        }

        public final String getTextContentUpdate() {
            return this.textContentUpdate;
        }

        @Override
        public final Builder textContentUpdate(String textContentUpdate) {
            this.textContentUpdate = textContentUpdate;
            return this;
        }

        public final void setTextContentUpdate(String textContentUpdate) {
            this.textContentUpdate = textContentUpdate;
        }

        public final ByteBuffer getZipFileContentUpdate() {
            return this.zipFileContentUpdate == null ? null : this.zipFileContentUpdate.asByteBuffer();
        }

        @Override
        public final Builder zipFileContentUpdate(SdkBytes zipFileContentUpdate) {
            this.zipFileContentUpdate = StandardMemberCopier.copy((SdkBytes)zipFileContentUpdate);
            return this;
        }

        public final void setZipFileContentUpdate(ByteBuffer zipFileContentUpdate) {
            this.zipFileContentUpdate(zipFileContentUpdate == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)zipFileContentUpdate));
        }

        public final S3ContentLocationUpdate.Builder getS3ContentLocationUpdate() {
            return this.s3ContentLocationUpdate != null ? this.s3ContentLocationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3ContentLocationUpdate(S3ContentLocationUpdate s3ContentLocationUpdate) {
            this.s3ContentLocationUpdate = s3ContentLocationUpdate;
            return this;
        }

        public final void setS3ContentLocationUpdate(S3ContentLocationUpdate.BuilderImpl s3ContentLocationUpdate) {
            this.s3ContentLocationUpdate = s3ContentLocationUpdate != null ? s3ContentLocationUpdate.build() : null;
        }

        public CodeContentUpdate build() {
            return new CodeContentUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeContentUpdate> {
        public Builder textContentUpdate(String var1);

        public Builder zipFileContentUpdate(SdkBytes var1);

        public Builder s3ContentLocationUpdate(S3ContentLocationUpdate var1);

        default public Builder s3ContentLocationUpdate(Consumer<S3ContentLocationUpdate.Builder> s3ContentLocationUpdate) {
            return this.s3ContentLocationUpdate((S3ContentLocationUpdate)((S3ContentLocationUpdate.Builder)S3ContentLocationUpdate.builder().applyMutation(s3ContentLocationUpdate)).build());
        }
    }
}

