/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationInputProcessingConfigurationResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, AddApplicationInputProcessingConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddApplicationInputProcessingConfigurationResponse.getter(AddApplicationInputProcessingConfigurationResponse::applicationARN)).setter(AddApplicationInputProcessingConfigurationResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(AddApplicationInputProcessingConfigurationResponse.getter(AddApplicationInputProcessingConfigurationResponse::applicationVersionId)).setter(AddApplicationInputProcessingConfigurationResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddApplicationInputProcessingConfigurationResponse.getter(AddApplicationInputProcessingConfigurationResponse::inputId)).setter(AddApplicationInputProcessingConfigurationResponse.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()}).build();
    private static final SdkField<InputProcessingConfigurationDescription> INPUT_PROCESSING_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AddApplicationInputProcessingConfigurationResponse.getter(AddApplicationInputProcessingConfigurationResponse::inputProcessingConfigurationDescription)).setter(AddApplicationInputProcessingConfigurationResponse.setter(Builder::inputProcessingConfigurationDescription)).constructor(InputProcessingConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfigurationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD, INPUT_ID_FIELD, INPUT_PROCESSING_CONFIGURATION_DESCRIPTION_FIELD));
    private final String applicationARN;
    private final Long applicationVersionId;
    private final String inputId;
    private final InputProcessingConfigurationDescription inputProcessingConfigurationDescription;

    private AddApplicationInputProcessingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.inputId = builder.inputId;
        this.inputProcessingConfigurationDescription = builder.inputProcessingConfigurationDescription;
    }

    public String applicationARN() {
        return this.applicationARN;
    }

    public Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public String inputId() {
        return this.inputId;
    }

    public InputProcessingConfigurationDescription inputProcessingConfigurationDescription() {
        return this.inputProcessingConfigurationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfigurationDescription());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputProcessingConfigurationResponse)) {
            return false;
        }
        AddApplicationInputProcessingConfigurationResponse other = (AddApplicationInputProcessingConfigurationResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.inputProcessingConfigurationDescription(), other.inputProcessingConfigurationDescription());
    }

    public String toString() {
        return ToString.builder((String)"AddApplicationInputProcessingConfigurationResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("InputId", (Object)this.inputId()).add("InputProcessingConfigurationDescription", (Object)this.inputProcessingConfigurationDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "InputProcessingConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.inputProcessingConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationInputProcessingConfigurationResponse, T> g) {
        return obj -> g.apply((AddApplicationInputProcessingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;
        private String inputId;
        private InputProcessingConfigurationDescription inputProcessingConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputProcessingConfigurationResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
            this.inputId(model.inputId);
            this.inputProcessingConfigurationDescription(model.inputProcessingConfigurationDescription);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final InputProcessingConfigurationDescription.Builder getInputProcessingConfigurationDescription() {
            return this.inputProcessingConfigurationDescription != null ? this.inputProcessingConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationDescription(InputProcessingConfigurationDescription inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription;
            return this;
        }

        public final void setInputProcessingConfigurationDescription(InputProcessingConfigurationDescription.BuilderImpl inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription.build() : null;
        }

        @Override
        public AddApplicationInputProcessingConfigurationResponse build() {
            return new AddApplicationInputProcessingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationInputProcessingConfigurationResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);

        public Builder inputId(String var1);

        public Builder inputProcessingConfigurationDescription(InputProcessingConfigurationDescription var1);

        default public Builder inputProcessingConfigurationDescription(Consumer<InputProcessingConfigurationDescription.Builder> inputProcessingConfigurationDescription) {
            return this.inputProcessingConfigurationDescription((InputProcessingConfigurationDescription)((InputProcessingConfigurationDescription.Builder)InputProcessingConfigurationDescription.builder().applyMutation(inputProcessingConfigurationDescription)).build());
        }
    }
}

