/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, DescribeApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeApplicationRequest.getter(DescribeApplicationRequest::applicationName)).setter(DescribeApplicationRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Boolean> INCLUDE_ADDITIONAL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeApplicationRequest.getter(DescribeApplicationRequest::includeAdditionalDetails)).setter(DescribeApplicationRequest.setter(Builder::includeAdditionalDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAdditionalDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, INCLUDE_ADDITIONAL_DETAILS_FIELD));
    private final String applicationName;
    private final Boolean includeAdditionalDetails;

    private DescribeApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.includeAdditionalDetails = builder.includeAdditionalDetails;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public Boolean includeAdditionalDetails() {
        return this.includeAdditionalDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeAdditionalDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationRequest)) {
            return false;
        }
        DescribeApplicationRequest other = (DescribeApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.includeAdditionalDetails(), other.includeAdditionalDetails());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("IncludeAdditionalDetails", (Object)this.includeAdditionalDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "IncludeAdditionalDetails": {
                return Optional.ofNullable(clazz.cast(this.includeAdditionalDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationRequest, T> g) {
        return obj -> g.apply((DescribeApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String applicationName;
        private Boolean includeAdditionalDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.includeAdditionalDetails(model.includeAdditionalDetails);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Boolean getIncludeAdditionalDetails() {
            return this.includeAdditionalDetails;
        }

        @Override
        public final Builder includeAdditionalDetails(Boolean includeAdditionalDetails) {
            this.includeAdditionalDetails = includeAdditionalDetails;
            return this;
        }

        public final void setIncludeAdditionalDetails(Boolean includeAdditionalDetails) {
            this.includeAdditionalDetails = includeAdditionalDetails;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationRequest build() {
            return new DescribeApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder includeAdditionalDetails(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

