/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates to the monitoring configuration for Apache Zeppelin within a Managed Service for Apache Flink Studio
 * notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZeppelinMonitoringConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ZeppelinMonitoringConfigurationUpdate.Builder, ZeppelinMonitoringConfigurationUpdate> {
    private static final SdkField<String> LOG_LEVEL_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogLevelUpdate").getter(getter(ZeppelinMonitoringConfigurationUpdate::logLevelUpdateAsString))
            .setter(setter(Builder::logLevelUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevelUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logLevelUpdate;

    private ZeppelinMonitoringConfigurationUpdate(BuilderImpl builder) {
        this.logLevelUpdate = builder.logLevelUpdate;
    }

    /**
     * <p>
     * Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio notebook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevelUpdate}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelUpdateAsString}.
     * </p>
     * 
     * @return Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio
     *         notebook.
     * @see LogLevel
     */
    public final LogLevel logLevelUpdate() {
        return LogLevel.fromValue(logLevelUpdate);
    }

    /**
     * <p>
     * Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio notebook.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevelUpdate}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelUpdateAsString}.
     * </p>
     * 
     * @return Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio
     *         notebook.
     * @see LogLevel
     */
    public final String logLevelUpdateAsString() {
        return logLevelUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logLevelUpdateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeppelinMonitoringConfigurationUpdate)) {
            return false;
        }
        ZeppelinMonitoringConfigurationUpdate other = (ZeppelinMonitoringConfigurationUpdate) obj;
        return Objects.equals(logLevelUpdateAsString(), other.logLevelUpdateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZeppelinMonitoringConfigurationUpdate").add("LogLevelUpdate", logLevelUpdateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogLevelUpdate":
            return Optional.ofNullable(clazz.cast(logLevelUpdateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogLevelUpdate", LOG_LEVEL_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZeppelinMonitoringConfigurationUpdate, T> g) {
        return obj -> g.apply((ZeppelinMonitoringConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZeppelinMonitoringConfigurationUpdate> {
        /**
         * <p>
         * Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio notebook.
         * </p>
         * 
         * @param logLevelUpdate
         *        Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio
         *        notebook.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevelUpdate(String logLevelUpdate);

        /**
         * <p>
         * Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio notebook.
         * </p>
         * 
         * @param logLevelUpdate
         *        Updates to the logging level for Apache Zeppelin within a Managed Service for Apache Flink Studio
         *        notebook.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevelUpdate(LogLevel logLevelUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String logLevelUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ZeppelinMonitoringConfigurationUpdate model) {
            logLevelUpdate(model.logLevelUpdate);
        }

        public final String getLogLevelUpdate() {
            return logLevelUpdate;
        }

        public final void setLogLevelUpdate(String logLevelUpdate) {
            this.logLevelUpdate = logLevelUpdate;
        }

        @Override
        public final Builder logLevelUpdate(String logLevelUpdate) {
            this.logLevelUpdate = logLevelUpdate;
            return this;
        }

        @Override
        public final Builder logLevelUpdate(LogLevel logLevelUpdate) {
            this.logLevelUpdate(logLevelUpdate == null ? null : logLevelUpdate.toString());
            return this;
        }

        @Override
        public ZeppelinMonitoringConfigurationUpdate build() {
            return new ZeppelinMonitoringConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
