/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of a Managed Service for Apache Flink Studio notebook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZeppelinApplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ZeppelinApplicationConfiguration.Builder, ZeppelinApplicationConfiguration> {
    private static final SdkField<ZeppelinMonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField
            .<ZeppelinMonitoringConfiguration> builder(MarshallingType.SDK_POJO).memberName("MonitoringConfiguration")
            .getter(getter(ZeppelinApplicationConfiguration::monitoringConfiguration))
            .setter(setter(Builder::monitoringConfiguration)).constructor(ZeppelinMonitoringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfiguration").build())
            .build();

    private static final SdkField<CatalogConfiguration> CATALOG_CONFIGURATION_FIELD = SdkField
            .<CatalogConfiguration> builder(MarshallingType.SDK_POJO).memberName("CatalogConfiguration")
            .getter(getter(ZeppelinApplicationConfiguration::catalogConfiguration)).setter(setter(Builder::catalogConfiguration))
            .constructor(CatalogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfiguration").build())
            .build();

    private static final SdkField<DeployAsApplicationConfiguration> DEPLOY_AS_APPLICATION_CONFIGURATION_FIELD = SdkField
            .<DeployAsApplicationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DeployAsApplicationConfiguration")
            .getter(getter(ZeppelinApplicationConfiguration::deployAsApplicationConfiguration))
            .setter(setter(Builder::deployAsApplicationConfiguration))
            .constructor(DeployAsApplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployAsApplicationConfiguration")
                    .build()).build();

    private static final SdkField<List<CustomArtifactConfiguration>> CUSTOM_ARTIFACTS_CONFIGURATION_FIELD = SdkField
            .<List<CustomArtifactConfiguration>> builder(MarshallingType.LIST)
            .memberName("CustomArtifactsConfiguration")
            .getter(getter(ZeppelinApplicationConfiguration::customArtifactsConfiguration))
            .setter(setter(Builder::customArtifactsConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomArtifactsConfiguration")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomArtifactConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomArtifactConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_CONFIGURATION_FIELD, CATALOG_CONFIGURATION_FIELD, DEPLOY_AS_APPLICATION_CONFIGURATION_FIELD,
            CUSTOM_ARTIFACTS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ZeppelinMonitoringConfiguration monitoringConfiguration;

    private final CatalogConfiguration catalogConfiguration;

    private final DeployAsApplicationConfiguration deployAsApplicationConfiguration;

    private final List<CustomArtifactConfiguration> customArtifactsConfiguration;

    private ZeppelinApplicationConfiguration(BuilderImpl builder) {
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.catalogConfiguration = builder.catalogConfiguration;
        this.deployAsApplicationConfiguration = builder.deployAsApplicationConfiguration;
        this.customArtifactsConfiguration = builder.customArtifactsConfiguration;
    }

    /**
     * <p>
     * The monitoring configuration of a Managed Service for Apache Flink Studio notebook.
     * </p>
     * 
     * @return The monitoring configuration of a Managed Service for Apache Flink Studio notebook.
     */
    public final ZeppelinMonitoringConfiguration monitoringConfiguration() {
        return monitoringConfiguration;
    }

    /**
     * <p>
     * The Amazon Glue Data Catalog that you use in queries in a Managed Service for Apache Flink Studio notebook.
     * </p>
     * 
     * @return The Amazon Glue Data Catalog that you use in queries in a Managed Service for Apache Flink Studio
     *         notebook.
     */
    public final CatalogConfiguration catalogConfiguration() {
        return catalogConfiguration;
    }

    /**
     * <p>
     * The information required to deploy a Managed Service for Apache Flink Studio notebook as an application with
     * durable state.
     * </p>
     * 
     * @return The information required to deploy a Managed Service for Apache Flink Studio notebook as an application
     *         with durable state.
     */
    public final DeployAsApplicationConfiguration deployAsApplicationConfiguration() {
        return deployAsApplicationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomArtifactsConfiguration property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomArtifactsConfiguration() {
        return customArtifactsConfiguration != null && !(customArtifactsConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom artifacts are dependency JARs and user-defined functions (UDF).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomArtifactsConfiguration} method.
     * </p>
     * 
     * @return Custom artifacts are dependency JARs and user-defined functions (UDF).
     */
    public final List<CustomArtifactConfiguration> customArtifactsConfiguration() {
        return customArtifactsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(catalogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deployAsApplicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomArtifactsConfiguration() ? customArtifactsConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeppelinApplicationConfiguration)) {
            return false;
        }
        ZeppelinApplicationConfiguration other = (ZeppelinApplicationConfiguration) obj;
        return Objects.equals(monitoringConfiguration(), other.monitoringConfiguration())
                && Objects.equals(catalogConfiguration(), other.catalogConfiguration())
                && Objects.equals(deployAsApplicationConfiguration(), other.deployAsApplicationConfiguration())
                && hasCustomArtifactsConfiguration() == other.hasCustomArtifactsConfiguration()
                && Objects.equals(customArtifactsConfiguration(), other.customArtifactsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZeppelinApplicationConfiguration").add("MonitoringConfiguration", monitoringConfiguration())
                .add("CatalogConfiguration", catalogConfiguration())
                .add("DeployAsApplicationConfiguration", deployAsApplicationConfiguration())
                .add("CustomArtifactsConfiguration", hasCustomArtifactsConfiguration() ? customArtifactsConfiguration() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringConfiguration":
            return Optional.ofNullable(clazz.cast(monitoringConfiguration()));
        case "CatalogConfiguration":
            return Optional.ofNullable(clazz.cast(catalogConfiguration()));
        case "DeployAsApplicationConfiguration":
            return Optional.ofNullable(clazz.cast(deployAsApplicationConfiguration()));
        case "CustomArtifactsConfiguration":
            return Optional.ofNullable(clazz.cast(customArtifactsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
        map.put("CatalogConfiguration", CATALOG_CONFIGURATION_FIELD);
        map.put("DeployAsApplicationConfiguration", DEPLOY_AS_APPLICATION_CONFIGURATION_FIELD);
        map.put("CustomArtifactsConfiguration", CUSTOM_ARTIFACTS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZeppelinApplicationConfiguration, T> g) {
        return obj -> g.apply((ZeppelinApplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZeppelinApplicationConfiguration> {
        /**
         * <p>
         * The monitoring configuration of a Managed Service for Apache Flink Studio notebook.
         * </p>
         * 
         * @param monitoringConfiguration
         *        The monitoring configuration of a Managed Service for Apache Flink Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringConfiguration(ZeppelinMonitoringConfiguration monitoringConfiguration);

        /**
         * <p>
         * The monitoring configuration of a Managed Service for Apache Flink Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZeppelinMonitoringConfiguration.Builder}
         * avoiding the need to create one manually via {@link ZeppelinMonitoringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZeppelinMonitoringConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoringConfiguration(ZeppelinMonitoringConfiguration)}.
         * 
         * @param monitoringConfiguration
         *        a consumer that will call methods on {@link ZeppelinMonitoringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringConfiguration(ZeppelinMonitoringConfiguration)
         */
        default Builder monitoringConfiguration(Consumer<ZeppelinMonitoringConfiguration.Builder> monitoringConfiguration) {
            return monitoringConfiguration(ZeppelinMonitoringConfiguration.builder().applyMutation(monitoringConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Amazon Glue Data Catalog that you use in queries in a Managed Service for Apache Flink Studio notebook.
         * </p>
         * 
         * @param catalogConfiguration
         *        The Amazon Glue Data Catalog that you use in queries in a Managed Service for Apache Flink Studio
         *        notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogConfiguration(CatalogConfiguration catalogConfiguration);

        /**
         * <p>
         * The Amazon Glue Data Catalog that you use in queries in a Managed Service for Apache Flink Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the {@link CatalogConfiguration.Builder} avoiding
         * the need to create one manually via {@link CatalogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CatalogConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #catalogConfiguration(CatalogConfiguration)}.
         * 
         * @param catalogConfiguration
         *        a consumer that will call methods on {@link CatalogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogConfiguration(CatalogConfiguration)
         */
        default Builder catalogConfiguration(Consumer<CatalogConfiguration.Builder> catalogConfiguration) {
            return catalogConfiguration(CatalogConfiguration.builder().applyMutation(catalogConfiguration).build());
        }

        /**
         * <p>
         * The information required to deploy a Managed Service for Apache Flink Studio notebook as an application with
         * durable state.
         * </p>
         * 
         * @param deployAsApplicationConfiguration
         *        The information required to deploy a Managed Service for Apache Flink Studio notebook as an
         *        application with durable state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployAsApplicationConfiguration(DeployAsApplicationConfiguration deployAsApplicationConfiguration);

        /**
         * <p>
         * The information required to deploy a Managed Service for Apache Flink Studio notebook as an application with
         * durable state.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeployAsApplicationConfiguration.Builder}
         * avoiding the need to create one manually via {@link DeployAsApplicationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeployAsApplicationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #deployAsApplicationConfiguration(DeployAsApplicationConfiguration)}.
         * 
         * @param deployAsApplicationConfiguration
         *        a consumer that will call methods on {@link DeployAsApplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployAsApplicationConfiguration(DeployAsApplicationConfiguration)
         */
        default Builder deployAsApplicationConfiguration(
                Consumer<DeployAsApplicationConfiguration.Builder> deployAsApplicationConfiguration) {
            return deployAsApplicationConfiguration(DeployAsApplicationConfiguration.builder()
                    .applyMutation(deployAsApplicationConfiguration).build());
        }

        /**
         * <p>
         * Custom artifacts are dependency JARs and user-defined functions (UDF).
         * </p>
         * 
         * @param customArtifactsConfiguration
         *        Custom artifacts are dependency JARs and user-defined functions (UDF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customArtifactsConfiguration(Collection<CustomArtifactConfiguration> customArtifactsConfiguration);

        /**
         * <p>
         * Custom artifacts are dependency JARs and user-defined functions (UDF).
         * </p>
         * 
         * @param customArtifactsConfiguration
         *        Custom artifacts are dependency JARs and user-defined functions (UDF).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customArtifactsConfiguration(CustomArtifactConfiguration... customArtifactsConfiguration);

        /**
         * <p>
         * Custom artifacts are dependency JARs and user-defined functions (UDF).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #customArtifactsConfiguration(List<CustomArtifactConfiguration>)}.
         * 
         * @param customArtifactsConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customArtifactsConfiguration(java.util.Collection<CustomArtifactConfiguration>)
         */
        Builder customArtifactsConfiguration(Consumer<CustomArtifactConfiguration.Builder>... customArtifactsConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private ZeppelinMonitoringConfiguration monitoringConfiguration;

        private CatalogConfiguration catalogConfiguration;

        private DeployAsApplicationConfiguration deployAsApplicationConfiguration;

        private List<CustomArtifactConfiguration> customArtifactsConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ZeppelinApplicationConfiguration model) {
            monitoringConfiguration(model.monitoringConfiguration);
            catalogConfiguration(model.catalogConfiguration);
            deployAsApplicationConfiguration(model.deployAsApplicationConfiguration);
            customArtifactsConfiguration(model.customArtifactsConfiguration);
        }

        public final ZeppelinMonitoringConfiguration.Builder getMonitoringConfiguration() {
            return monitoringConfiguration != null ? monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(ZeppelinMonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(ZeppelinMonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final CatalogConfiguration.Builder getCatalogConfiguration() {
            return catalogConfiguration != null ? catalogConfiguration.toBuilder() : null;
        }

        public final void setCatalogConfiguration(CatalogConfiguration.BuilderImpl catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration != null ? catalogConfiguration.build() : null;
        }

        @Override
        public final Builder catalogConfiguration(CatalogConfiguration catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration;
            return this;
        }

        public final DeployAsApplicationConfiguration.Builder getDeployAsApplicationConfiguration() {
            return deployAsApplicationConfiguration != null ? deployAsApplicationConfiguration.toBuilder() : null;
        }

        public final void setDeployAsApplicationConfiguration(
                DeployAsApplicationConfiguration.BuilderImpl deployAsApplicationConfiguration) {
            this.deployAsApplicationConfiguration = deployAsApplicationConfiguration != null ? deployAsApplicationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder deployAsApplicationConfiguration(DeployAsApplicationConfiguration deployAsApplicationConfiguration) {
            this.deployAsApplicationConfiguration = deployAsApplicationConfiguration;
            return this;
        }

        public final List<CustomArtifactConfiguration.Builder> getCustomArtifactsConfiguration() {
            List<CustomArtifactConfiguration.Builder> result = CustomArtifactsConfigurationListCopier
                    .copyToBuilder(this.customArtifactsConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomArtifactsConfiguration(
                Collection<CustomArtifactConfiguration.BuilderImpl> customArtifactsConfiguration) {
            this.customArtifactsConfiguration = CustomArtifactsConfigurationListCopier
                    .copyFromBuilder(customArtifactsConfiguration);
        }

        @Override
        public final Builder customArtifactsConfiguration(Collection<CustomArtifactConfiguration> customArtifactsConfiguration) {
            this.customArtifactsConfiguration = CustomArtifactsConfigurationListCopier.copy(customArtifactsConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfiguration(CustomArtifactConfiguration... customArtifactsConfiguration) {
            customArtifactsConfiguration(Arrays.asList(customArtifactsConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfiguration(
                Consumer<CustomArtifactConfiguration.Builder>... customArtifactsConfiguration) {
            customArtifactsConfiguration(Stream.of(customArtifactsConfiguration)
                    .map(c -> CustomArtifactConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ZeppelinApplicationConfiguration build() {
            return new ZeppelinApplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
