/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationMaintenanceConfigurationResponse extends KinesisAnalyticsV2Response
        implements
        ToCopyableBuilder<UpdateApplicationMaintenanceConfigurationResponse.Builder, UpdateApplicationMaintenanceConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(UpdateApplicationMaintenanceConfigurationResponse::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<ApplicationMaintenanceConfigurationDescription> APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationMaintenanceConfigurationDescription> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationMaintenanceConfigurationDescription")
            .getter(getter(UpdateApplicationMaintenanceConfigurationResponse::applicationMaintenanceConfigurationDescription))
            .setter(setter(Builder::applicationMaintenanceConfigurationDescription))
            .constructor(ApplicationMaintenanceConfigurationDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationMaintenanceConfigurationDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationARN;

    private final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;

    private UpdateApplicationMaintenanceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationMaintenanceConfigurationDescription = builder.applicationMaintenanceConfigurationDescription;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * The application maintenance configuration description after the update.
     * </p>
     * 
     * @return The application maintenance configuration description after the update.
     */
    public final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription() {
        return applicationMaintenanceConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationMaintenanceConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationMaintenanceConfigurationResponse)) {
            return false;
        }
        UpdateApplicationMaintenanceConfigurationResponse other = (UpdateApplicationMaintenanceConfigurationResponse) obj;
        return Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationMaintenanceConfigurationDescription(),
                        other.applicationMaintenanceConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationMaintenanceConfigurationResponse").add("ApplicationARN", applicationARN())
                .add("ApplicationMaintenanceConfigurationDescription", applicationMaintenanceConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationMaintenanceConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationMaintenanceConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationMaintenanceConfigurationDescription", APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationMaintenanceConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateApplicationMaintenanceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationMaintenanceConfigurationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationARN
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * The application maintenance configuration description after the update.
         * </p>
         * 
         * @param applicationMaintenanceConfigurationDescription
         *        The application maintenance configuration description after the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationMaintenanceConfigurationDescription(
                ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription);

        /**
         * <p>
         * The application maintenance configuration description after the update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationMaintenanceConfigurationDescription.Builder} avoiding the need to create one manually via
         * {@link ApplicationMaintenanceConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationMaintenanceConfigurationDescription.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription)}.
         * 
         * @param applicationMaintenanceConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationMaintenanceConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription)
         */
        default Builder applicationMaintenanceConfigurationDescription(
                Consumer<ApplicationMaintenanceConfigurationDescription.Builder> applicationMaintenanceConfigurationDescription) {
            return applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription.builder()
                    .applyMutation(applicationMaintenanceConfigurationDescription).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Response.BuilderImpl implements Builder {
        private String applicationARN;

        private ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationMaintenanceConfigurationResponse model) {
            super(model);
            applicationARN(model.applicationARN);
            applicationMaintenanceConfigurationDescription(model.applicationMaintenanceConfigurationDescription);
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final ApplicationMaintenanceConfigurationDescription.Builder getApplicationMaintenanceConfigurationDescription() {
            return applicationMaintenanceConfigurationDescription != null ? applicationMaintenanceConfigurationDescription
                    .toBuilder() : null;
        }

        public final void setApplicationMaintenanceConfigurationDescription(
                ApplicationMaintenanceConfigurationDescription.BuilderImpl applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription != null ? applicationMaintenanceConfigurationDescription
                    .build() : null;
        }

        @Override
        public final Builder applicationMaintenanceConfigurationDescription(
                ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription;
            return this;
        }

        @Override
        public UpdateApplicationMaintenanceConfigurationResponse build() {
            return new UpdateApplicationMaintenanceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
