/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the point at which the application reads from the streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputStartingPositionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InputStartingPositionConfiguration.Builder, InputStartingPositionConfiguration> {
    private static final SdkField<String> INPUT_STARTING_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputStartingPosition")
            .getter(getter(InputStartingPositionConfiguration::inputStartingPositionAsString))
            .setter(setter(Builder::inputStartingPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStartingPosition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(INPUT_STARTING_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputStartingPosition;

    private InputStartingPositionConfiguration(BuilderImpl builder) {
        this.inputStartingPosition = builder.inputStartingPosition;
    }

    /**
     * <p>
     * The starting position on the stream.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the request
     * timestamp that the customer issued.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest record
     * available in the stream. This option is not available for an Amazon Kinesis Data Firehose delivery stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputStartingPosition} will return {@link InputStartingPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputStartingPositionAsString}.
     * </p>
     * 
     * @return The starting position on the stream.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the
     *         request timestamp that the customer issued.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
     *         record available in the stream. This option is not available for an Amazon Kinesis Data Firehose delivery
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     *         </p>
     *         </li>
     * @see InputStartingPosition
     */
    public final InputStartingPosition inputStartingPosition() {
        return InputStartingPosition.fromValue(inputStartingPosition);
    }

    /**
     * <p>
     * The starting position on the stream.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the request
     * timestamp that the customer issued.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest record
     * available in the stream. This option is not available for an Amazon Kinesis Data Firehose delivery stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inputStartingPosition} will return {@link InputStartingPosition#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inputStartingPositionAsString}.
     * </p>
     * 
     * @return The starting position on the stream.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the
     *         request timestamp that the customer issued.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
     *         record available in the stream. This option is not available for an Amazon Kinesis Data Firehose delivery
     *         stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
     *         </p>
     *         </li>
     * @see InputStartingPosition
     */
    public final String inputStartingPositionAsString() {
        return inputStartingPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputStartingPositionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputStartingPositionConfiguration)) {
            return false;
        }
        InputStartingPositionConfiguration other = (InputStartingPositionConfiguration) obj;
        return Objects.equals(inputStartingPositionAsString(), other.inputStartingPositionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputStartingPositionConfiguration")
                .add("InputStartingPosition", inputStartingPositionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputStartingPosition":
            return Optional.ofNullable(clazz.cast(inputStartingPositionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InputStartingPosition", INPUT_STARTING_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputStartingPositionConfiguration, T> g) {
        return obj -> g.apply((InputStartingPositionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputStartingPositionConfiguration> {
        /**
         * <p>
         * The starting position on the stream.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the request
         * timestamp that the customer issued.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
         * record available in the stream. This option is not available for an Amazon Kinesis Data Firehose delivery
         * stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputStartingPosition
         *        The starting position on the stream.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the
         *        request timestamp that the customer issued.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the
         *        oldest record available in the stream. This option is not available for an Amazon Kinesis Data
         *        Firehose delivery stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         *        </p>
         *        </li>
         * @see InputStartingPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputStartingPosition
         */
        Builder inputStartingPosition(String inputStartingPosition);

        /**
         * <p>
         * The starting position on the stream.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the request
         * timestamp that the customer issued.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the oldest
         * record available in the stream. This option is not available for an Amazon Kinesis Data Firehose delivery
         * stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inputStartingPosition
         *        The starting position on the stream.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Start reading just after the most recent record in the stream, and start at the
         *        request timestamp that the customer issued.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TRIM_HORIZON</code> - Start reading at the last untrimmed record in the stream, which is the
         *        oldest record available in the stream. This option is not available for an Amazon Kinesis Data
         *        Firehose delivery stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LAST_STOPPED_POINT</code> - Resume reading from where the application last stopped reading.
         *        </p>
         *        </li>
         * @see InputStartingPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputStartingPosition
         */
        Builder inputStartingPosition(InputStartingPosition inputStartingPosition);
    }

    static final class BuilderImpl implements Builder {
        private String inputStartingPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(InputStartingPositionConfiguration model) {
            inputStartingPosition(model.inputStartingPosition);
        }

        public final String getInputStartingPosition() {
            return inputStartingPosition;
        }

        public final void setInputStartingPosition(String inputStartingPosition) {
            this.inputStartingPosition = inputStartingPosition;
        }

        @Override
        public final Builder inputStartingPosition(String inputStartingPosition) {
            this.inputStartingPosition = inputStartingPosition;
            return this;
        }

        @Override
        public final Builder inputStartingPosition(InputStartingPosition inputStartingPosition) {
            this.inputStartingPosition(inputStartingPosition == null ? null : inputStartingPosition.toString());
            return this;
        }

        @Override
        public InputStartingPositionConfiguration build() {
            return new InputStartingPositionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
