/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationPresignedUrlRequest extends KinesisAnalyticsV2Request implements
        ToCopyableBuilder<CreateApplicationPresignedUrlRequest.Builder, CreateApplicationPresignedUrlRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateApplicationPresignedUrlRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> URL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UrlType").getter(getter(CreateApplicationPresignedUrlRequest::urlTypeAsString))
            .setter(setter(Builder::urlType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlType").build()).build();

    private static final SdkField<Long> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("SessionExpirationDurationInSeconds")
            .getter(getter(CreateApplicationPresignedUrlRequest::sessionExpirationDurationInSeconds))
            .setter(setter(Builder::sessionExpirationDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            URL_TYPE_FIELD, SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final String urlType;

    private final Long sessionExpirationDurationInSeconds;

    private CreateApplicationPresignedUrlRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.urlType = builder.urlType;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The type of the extension for which to create and return a URL. Currently, the only valid extension URL type is
     * <code>FLINK_DASHBOARD_URL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #urlType} will
     * return {@link UrlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #urlTypeAsString}.
     * </p>
     * 
     * @return The type of the extension for which to create and return a URL. Currently, the only valid extension URL
     *         type is <code>FLINK_DASHBOARD_URL</code>.
     * @see UrlType
     */
    public final UrlType urlType() {
        return UrlType.fromValue(urlType);
    }

    /**
     * <p>
     * The type of the extension for which to create and return a URL. Currently, the only valid extension URL type is
     * <code>FLINK_DASHBOARD_URL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #urlType} will
     * return {@link UrlType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #urlTypeAsString}.
     * </p>
     * 
     * @return The type of the extension for which to create and return a URL. Currently, the only valid extension URL
     *         type is <code>FLINK_DASHBOARD_URL</code>.
     * @see UrlType
     */
    public final String urlTypeAsString() {
        return urlType;
    }

    /**
     * <p>
     * The duration in seconds for which the returned URL will be valid.
     * </p>
     * 
     * @return The duration in seconds for which the returned URL will be valid.
     */
    public final Long sessionExpirationDurationInSeconds() {
        return sessionExpirationDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(urlTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpirationDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationPresignedUrlRequest)) {
            return false;
        }
        CreateApplicationPresignedUrlRequest other = (CreateApplicationPresignedUrlRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(urlTypeAsString(), other.urlTypeAsString())
                && Objects.equals(sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationPresignedUrlRequest").add("ApplicationName", applicationName())
                .add("UrlType", urlTypeAsString())
                .add("SessionExpirationDurationInSeconds", sessionExpirationDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "UrlType":
            return Optional.ofNullable(clazz.cast(urlTypeAsString()));
        case "SessionExpirationDurationInSeconds":
            return Optional.ofNullable(clazz.cast(sessionExpirationDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("UrlType", URL_TYPE_FIELD);
        map.put("SessionExpirationDurationInSeconds", SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationPresignedUrlRequest, T> g) {
        return obj -> g.apply((CreateApplicationPresignedUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisAnalyticsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationPresignedUrlRequest> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param applicationName
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The type of the extension for which to create and return a URL. Currently, the only valid extension URL type
         * is <code>FLINK_DASHBOARD_URL</code>.
         * </p>
         * 
         * @param urlType
         *        The type of the extension for which to create and return a URL. Currently, the only valid extension
         *        URL type is <code>FLINK_DASHBOARD_URL</code>.
         * @see UrlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UrlType
         */
        Builder urlType(String urlType);

        /**
         * <p>
         * The type of the extension for which to create and return a URL. Currently, the only valid extension URL type
         * is <code>FLINK_DASHBOARD_URL</code>.
         * </p>
         * 
         * @param urlType
         *        The type of the extension for which to create and return a URL. Currently, the only valid extension
         *        URL type is <code>FLINK_DASHBOARD_URL</code>.
         * @see UrlType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UrlType
         */
        Builder urlType(UrlType urlType);

        /**
         * <p>
         * The duration in seconds for which the returned URL will be valid.
         * </p>
         * 
         * @param sessionExpirationDurationInSeconds
         *        The duration in seconds for which the returned URL will be valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpirationDurationInSeconds(Long sessionExpirationDurationInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Request.BuilderImpl implements Builder {
        private String applicationName;

        private String urlType;

        private Long sessionExpirationDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationPresignedUrlRequest model) {
            super(model);
            applicationName(model.applicationName);
            urlType(model.urlType);
            sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getUrlType() {
            return urlType;
        }

        public final void setUrlType(String urlType) {
            this.urlType = urlType;
        }

        @Override
        public final Builder urlType(String urlType) {
            this.urlType = urlType;
            return this;
        }

        @Override
        public final Builder urlType(UrlType urlType) {
            this.urlType(urlType == null ? null : urlType.toString());
            return this;
        }

        public final Long getSessionExpirationDurationInSeconds() {
            return sessionExpirationDurationInSeconds;
        }

        public final void setSessionExpirationDurationInSeconds(Long sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Long sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationPresignedUrlRequest build() {
            return new CreateApplicationPresignedUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
