/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to an application's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationConfigurationUpdate.Builder, ApplicationConfigurationUpdate> {
    private static final SdkField<SqlApplicationConfigurationUpdate> SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<SqlApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("SqlApplicationConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::sqlApplicationConfigurationUpdate))
            .setter(setter(Builder::sqlApplicationConfigurationUpdate))
            .constructor(SqlApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfigurationUpdate")
                    .build()).build();

    private static final SdkField<ApplicationCodeConfigurationUpdate> APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationCodeConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationCodeConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::applicationCodeConfigurationUpdate))
            .setter(setter(Builder::applicationCodeConfigurationUpdate))
            .constructor(ApplicationCodeConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfigurationUpdate")
                    .build()).build();

    private static final SdkField<FlinkApplicationConfigurationUpdate> FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<FlinkApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("FlinkApplicationConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::flinkApplicationConfigurationUpdate))
            .setter(setter(Builder::flinkApplicationConfigurationUpdate))
            .constructor(FlinkApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("FlinkApplicationConfigurationUpdate").build()).build();

    private static final SdkField<EnvironmentPropertyUpdates> ENVIRONMENT_PROPERTY_UPDATES_FIELD = SdkField
            .<EnvironmentPropertyUpdates> builder(MarshallingType.SDK_POJO)
            .memberName("EnvironmentPropertyUpdates")
            .getter(getter(ApplicationConfigurationUpdate::environmentPropertyUpdates))
            .setter(setter(Builder::environmentPropertyUpdates))
            .constructor(EnvironmentPropertyUpdates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentPropertyUpdates").build())
            .build();

    private static final SdkField<ApplicationSnapshotConfigurationUpdate> APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationSnapshotConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationSnapshotConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::applicationSnapshotConfigurationUpdate))
            .setter(setter(Builder::applicationSnapshotConfigurationUpdate))
            .constructor(ApplicationSnapshotConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationSnapshotConfigurationUpdate").build()).build();

    private static final SdkField<ApplicationSystemRollbackConfigurationUpdate> APPLICATION_SYSTEM_ROLLBACK_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationSystemRollbackConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationSystemRollbackConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::applicationSystemRollbackConfigurationUpdate))
            .setter(setter(Builder::applicationSystemRollbackConfigurationUpdate))
            .constructor(ApplicationSystemRollbackConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationSystemRollbackConfigurationUpdate").build()).build();

    private static final SdkField<List<VpcConfigurationUpdate>> VPC_CONFIGURATION_UPDATES_FIELD = SdkField
            .<List<VpcConfigurationUpdate>> builder(MarshallingType.LIST)
            .memberName("VpcConfigurationUpdates")
            .getter(getter(ApplicationConfigurationUpdate::vpcConfigurationUpdates))
            .setter(setter(Builder::vpcConfigurationUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcConfigurationUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcConfigurationUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ZeppelinApplicationConfigurationUpdate> ZEPPELIN_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ZeppelinApplicationConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ZeppelinApplicationConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::zeppelinApplicationConfigurationUpdate))
            .setter(setter(Builder::zeppelinApplicationConfigurationUpdate))
            .constructor(ZeppelinApplicationConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ZeppelinApplicationConfigurationUpdate").build()).build();

    private static final SdkField<ApplicationEncryptionConfigurationUpdate> APPLICATION_ENCRYPTION_CONFIGURATION_UPDATE_FIELD = SdkField
            .<ApplicationEncryptionConfigurationUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationEncryptionConfigurationUpdate")
            .getter(getter(ApplicationConfigurationUpdate::applicationEncryptionConfigurationUpdate))
            .setter(setter(Builder::applicationEncryptionConfigurationUpdate))
            .constructor(ApplicationEncryptionConfigurationUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationEncryptionConfigurationUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD, APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD,
            FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD, ENVIRONMENT_PROPERTY_UPDATES_FIELD,
            APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD, APPLICATION_SYSTEM_ROLLBACK_CONFIGURATION_UPDATE_FIELD,
            VPC_CONFIGURATION_UPDATES_FIELD, ZEPPELIN_APPLICATION_CONFIGURATION_UPDATE_FIELD,
            APPLICATION_ENCRYPTION_CONFIGURATION_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;

    private final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;

    private final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;

    private final EnvironmentPropertyUpdates environmentPropertyUpdates;

    private final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;

    private final ApplicationSystemRollbackConfigurationUpdate applicationSystemRollbackConfigurationUpdate;

    private final List<VpcConfigurationUpdate> vpcConfigurationUpdates;

    private final ZeppelinApplicationConfigurationUpdate zeppelinApplicationConfigurationUpdate;

    private final ApplicationEncryptionConfigurationUpdate applicationEncryptionConfigurationUpdate;

    private ApplicationConfigurationUpdate(BuilderImpl builder) {
        this.sqlApplicationConfigurationUpdate = builder.sqlApplicationConfigurationUpdate;
        this.applicationCodeConfigurationUpdate = builder.applicationCodeConfigurationUpdate;
        this.flinkApplicationConfigurationUpdate = builder.flinkApplicationConfigurationUpdate;
        this.environmentPropertyUpdates = builder.environmentPropertyUpdates;
        this.applicationSnapshotConfigurationUpdate = builder.applicationSnapshotConfigurationUpdate;
        this.applicationSystemRollbackConfigurationUpdate = builder.applicationSystemRollbackConfigurationUpdate;
        this.vpcConfigurationUpdates = builder.vpcConfigurationUpdates;
        this.zeppelinApplicationConfigurationUpdate = builder.zeppelinApplicationConfigurationUpdate;
        this.applicationEncryptionConfigurationUpdate = builder.applicationEncryptionConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
     * </p>
     * 
     * @return Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
     */
    public final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate() {
        return sqlApplicationConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to an application's code configuration.
     * </p>
     * 
     * @return Describes updates to an application's code configuration.
     */
    public final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate() {
        return applicationCodeConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to a Managed Service for Apache Flink application's configuration.
     * </p>
     * 
     * @return Describes updates to a Managed Service for Apache Flink application's configuration.
     */
    public final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate() {
        return flinkApplicationConfigurationUpdate;
    }

    /**
     * <p>
     * Describes updates to the environment properties for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @return Describes updates to the environment properties for a Managed Service for Apache Flink application.
     */
    public final EnvironmentPropertyUpdates environmentPropertyUpdates() {
        return environmentPropertyUpdates;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @return Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
     */
    public final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate() {
        return applicationSnapshotConfigurationUpdate;
    }

    /**
     * <p>
     * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application.
     * </p>
     * 
     * @return Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application.
     */
    public final ApplicationSystemRollbackConfigurationUpdate applicationSystemRollbackConfigurationUpdate() {
        return applicationSystemRollbackConfigurationUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcConfigurationUpdates property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcConfigurationUpdates() {
        return vpcConfigurationUpdates != null && !(vpcConfigurationUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Updates to the array of descriptions of VPC configurations available to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcConfigurationUpdates} method.
     * </p>
     * 
     * @return Updates to the array of descriptions of VPC configurations available to the application.
     */
    public final List<VpcConfigurationUpdate> vpcConfigurationUpdates() {
        return vpcConfigurationUpdates;
    }

    /**
     * <p>
     * Updates to the configuration of a Managed Service for Apache Flink Studio notebook.
     * </p>
     * 
     * @return Updates to the configuration of a Managed Service for Apache Flink Studio notebook.
     */
    public final ZeppelinApplicationConfigurationUpdate zeppelinApplicationConfigurationUpdate() {
        return zeppelinApplicationConfigurationUpdate;
    }

    /**
     * <p>
     * Represents an update for encryption at rest configuration.
     * </p>
     * 
     * @return Represents an update for encryption at rest configuration.
     */
    public final ApplicationEncryptionConfigurationUpdate applicationEncryptionConfigurationUpdate() {
        return applicationEncryptionConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCodeConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(flinkApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(environmentPropertyUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSnapshotConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSystemRollbackConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConfigurationUpdates() ? vpcConfigurationUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(zeppelinApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationEncryptionConfigurationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfigurationUpdate)) {
            return false;
        }
        ApplicationConfigurationUpdate other = (ApplicationConfigurationUpdate) obj;
        return Objects.equals(sqlApplicationConfigurationUpdate(), other.sqlApplicationConfigurationUpdate())
                && Objects.equals(applicationCodeConfigurationUpdate(), other.applicationCodeConfigurationUpdate())
                && Objects.equals(flinkApplicationConfigurationUpdate(), other.flinkApplicationConfigurationUpdate())
                && Objects.equals(environmentPropertyUpdates(), other.environmentPropertyUpdates())
                && Objects.equals(applicationSnapshotConfigurationUpdate(), other.applicationSnapshotConfigurationUpdate())
                && Objects.equals(applicationSystemRollbackConfigurationUpdate(),
                        other.applicationSystemRollbackConfigurationUpdate())
                && hasVpcConfigurationUpdates() == other.hasVpcConfigurationUpdates()
                && Objects.equals(vpcConfigurationUpdates(), other.vpcConfigurationUpdates())
                && Objects.equals(zeppelinApplicationConfigurationUpdate(), other.zeppelinApplicationConfigurationUpdate())
                && Objects.equals(applicationEncryptionConfigurationUpdate(), other.applicationEncryptionConfigurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationConfigurationUpdate")
                .add("SqlApplicationConfigurationUpdate", sqlApplicationConfigurationUpdate())
                .add("ApplicationCodeConfigurationUpdate", applicationCodeConfigurationUpdate())
                .add("FlinkApplicationConfigurationUpdate", flinkApplicationConfigurationUpdate())
                .add("EnvironmentPropertyUpdates", environmentPropertyUpdates())
                .add("ApplicationSnapshotConfigurationUpdate", applicationSnapshotConfigurationUpdate())
                .add("ApplicationSystemRollbackConfigurationUpdate", applicationSystemRollbackConfigurationUpdate())
                .add("VpcConfigurationUpdates", hasVpcConfigurationUpdates() ? vpcConfigurationUpdates() : null)
                .add("ZeppelinApplicationConfigurationUpdate", zeppelinApplicationConfigurationUpdate())
                .add("ApplicationEncryptionConfigurationUpdate", applicationEncryptionConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(sqlApplicationConfigurationUpdate()));
        case "ApplicationCodeConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationCodeConfigurationUpdate()));
        case "FlinkApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(flinkApplicationConfigurationUpdate()));
        case "EnvironmentPropertyUpdates":
            return Optional.ofNullable(clazz.cast(environmentPropertyUpdates()));
        case "ApplicationSnapshotConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationSnapshotConfigurationUpdate()));
        case "ApplicationSystemRollbackConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationSystemRollbackConfigurationUpdate()));
        case "VpcConfigurationUpdates":
            return Optional.ofNullable(clazz.cast(vpcConfigurationUpdates()));
        case "ZeppelinApplicationConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(zeppelinApplicationConfigurationUpdate()));
        case "ApplicationEncryptionConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(applicationEncryptionConfigurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SqlApplicationConfigurationUpdate", SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD);
        map.put("ApplicationCodeConfigurationUpdate", APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD);
        map.put("FlinkApplicationConfigurationUpdate", FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD);
        map.put("EnvironmentPropertyUpdates", ENVIRONMENT_PROPERTY_UPDATES_FIELD);
        map.put("ApplicationSnapshotConfigurationUpdate", APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD);
        map.put("ApplicationSystemRollbackConfigurationUpdate", APPLICATION_SYSTEM_ROLLBACK_CONFIGURATION_UPDATE_FIELD);
        map.put("VpcConfigurationUpdates", VPC_CONFIGURATION_UPDATES_FIELD);
        map.put("ZeppelinApplicationConfigurationUpdate", ZEPPELIN_APPLICATION_CONFIGURATION_UPDATE_FIELD);
        map.put("ApplicationEncryptionConfigurationUpdate", APPLICATION_ENCRYPTION_CONFIGURATION_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationConfigurationUpdate> {
        /**
         * <p>
         * Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
         * </p>
         * 
         * @param sqlApplicationConfigurationUpdate
         *        Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate);

        /**
         * <p>
         * Describes updates to a SQL-based Kinesis Data Analytics application's configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SqlApplicationConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link SqlApplicationConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SqlApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate)}.
         * 
         * @param sqlApplicationConfigurationUpdate
         *        a consumer that will call methods on {@link SqlApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate)
         */
        default Builder sqlApplicationConfigurationUpdate(
                Consumer<SqlApplicationConfigurationUpdate.Builder> sqlApplicationConfigurationUpdate) {
            return sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate.builder()
                    .applyMutation(sqlApplicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to an application's code configuration.
         * </p>
         * 
         * @param applicationCodeConfigurationUpdate
         *        Describes updates to an application's code configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate);

        /**
         * <p>
         * Describes updates to an application's code configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationCodeConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ApplicationCodeConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationCodeConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate)}.
         * 
         * @param applicationCodeConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationCodeConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate)
         */
        default Builder applicationCodeConfigurationUpdate(
                Consumer<ApplicationCodeConfigurationUpdate.Builder> applicationCodeConfigurationUpdate) {
            return applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate.builder()
                    .applyMutation(applicationCodeConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to a Managed Service for Apache Flink application's configuration.
         * </p>
         * 
         * @param flinkApplicationConfigurationUpdate
         *        Describes updates to a Managed Service for Apache Flink application's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate);

        /**
         * <p>
         * Describes updates to a Managed Service for Apache Flink application's configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FlinkApplicationConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link FlinkApplicationConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlinkApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate)}.
         * 
         * @param flinkApplicationConfigurationUpdate
         *        a consumer that will call methods on {@link FlinkApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate)
         */
        default Builder flinkApplicationConfigurationUpdate(
                Consumer<FlinkApplicationConfigurationUpdate.Builder> flinkApplicationConfigurationUpdate) {
            return flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate.builder()
                    .applyMutation(flinkApplicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes updates to the environment properties for a Managed Service for Apache Flink application.
         * </p>
         * 
         * @param environmentPropertyUpdates
         *        Describes updates to the environment properties for a Managed Service for Apache Flink application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentPropertyUpdates(EnvironmentPropertyUpdates environmentPropertyUpdates);

        /**
         * <p>
         * Describes updates to the environment properties for a Managed Service for Apache Flink application.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentPropertyUpdates.Builder}
         * avoiding the need to create one manually via {@link EnvironmentPropertyUpdates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentPropertyUpdates.Builder#build()} is called immediately
         * and its result is passed to {@link #environmentPropertyUpdates(EnvironmentPropertyUpdates)}.
         * 
         * @param environmentPropertyUpdates
         *        a consumer that will call methods on {@link EnvironmentPropertyUpdates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentPropertyUpdates(EnvironmentPropertyUpdates)
         */
        default Builder environmentPropertyUpdates(Consumer<EnvironmentPropertyUpdates.Builder> environmentPropertyUpdates) {
            return environmentPropertyUpdates(EnvironmentPropertyUpdates.builder().applyMutation(environmentPropertyUpdates)
                    .build());
        }

        /**
         * <p>
         * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
         * </p>
         * 
         * @param applicationSnapshotConfigurationUpdate
         *        Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSnapshotConfigurationUpdate(
                ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate);

        /**
         * <p>
         * Describes whether snapshots are enabled for a Managed Service for Apache Flink application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationSnapshotConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ApplicationSnapshotConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSnapshotConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate)}.
         * 
         * @param applicationSnapshotConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationSnapshotConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate)
         */
        default Builder applicationSnapshotConfigurationUpdate(
                Consumer<ApplicationSnapshotConfigurationUpdate.Builder> applicationSnapshotConfigurationUpdate) {
            return applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate.builder()
                    .applyMutation(applicationSnapshotConfigurationUpdate).build());
        }

        /**
         * <p>
         * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application.
         * </p>
         * 
         * @param applicationSystemRollbackConfigurationUpdate
         *        Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSystemRollbackConfigurationUpdate(
                ApplicationSystemRollbackConfigurationUpdate applicationSystemRollbackConfigurationUpdate);

        /**
         * <p>
         * Describes whether system rollbacks are enabled for a Managed Service for Apache Flink application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationSystemRollbackConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ApplicationSystemRollbackConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationSystemRollbackConfigurationUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #applicationSystemRollbackConfigurationUpdate(ApplicationSystemRollbackConfigurationUpdate)}.
         * 
         * @param applicationSystemRollbackConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationSystemRollbackConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSystemRollbackConfigurationUpdate(ApplicationSystemRollbackConfigurationUpdate)
         */
        default Builder applicationSystemRollbackConfigurationUpdate(
                Consumer<ApplicationSystemRollbackConfigurationUpdate.Builder> applicationSystemRollbackConfigurationUpdate) {
            return applicationSystemRollbackConfigurationUpdate(ApplicationSystemRollbackConfigurationUpdate.builder()
                    .applyMutation(applicationSystemRollbackConfigurationUpdate).build());
        }

        /**
         * <p>
         * Updates to the array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurationUpdates
         *        Updates to the array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationUpdates(Collection<VpcConfigurationUpdate> vpcConfigurationUpdates);

        /**
         * <p>
         * Updates to the array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurationUpdates
         *        Updates to the array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurationUpdates(VpcConfigurationUpdate... vpcConfigurationUpdates);

        /**
         * <p>
         * Updates to the array of descriptions of VPC configurations available to the application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate.Builder#build()} is
         * called immediately and its result is passed to {@link #vpcConfigurationUpdates(List<VpcConfigurationUpdate>)}.
         * 
         * @param vpcConfigurationUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfigurationUpdates(java.util.Collection<VpcConfigurationUpdate>)
         */
        Builder vpcConfigurationUpdates(Consumer<VpcConfigurationUpdate.Builder>... vpcConfigurationUpdates);

        /**
         * <p>
         * Updates to the configuration of a Managed Service for Apache Flink Studio notebook.
         * </p>
         * 
         * @param zeppelinApplicationConfigurationUpdate
         *        Updates to the configuration of a Managed Service for Apache Flink Studio notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeppelinApplicationConfigurationUpdate(
                ZeppelinApplicationConfigurationUpdate zeppelinApplicationConfigurationUpdate);

        /**
         * <p>
         * Updates to the configuration of a Managed Service for Apache Flink Studio notebook.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ZeppelinApplicationConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ZeppelinApplicationConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZeppelinApplicationConfigurationUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #zeppelinApplicationConfigurationUpdate(ZeppelinApplicationConfigurationUpdate)}.
         * 
         * @param zeppelinApplicationConfigurationUpdate
         *        a consumer that will call methods on {@link ZeppelinApplicationConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zeppelinApplicationConfigurationUpdate(ZeppelinApplicationConfigurationUpdate)
         */
        default Builder zeppelinApplicationConfigurationUpdate(
                Consumer<ZeppelinApplicationConfigurationUpdate.Builder> zeppelinApplicationConfigurationUpdate) {
            return zeppelinApplicationConfigurationUpdate(ZeppelinApplicationConfigurationUpdate.builder()
                    .applyMutation(zeppelinApplicationConfigurationUpdate).build());
        }

        /**
         * <p>
         * Represents an update for encryption at rest configuration.
         * </p>
         * 
         * @param applicationEncryptionConfigurationUpdate
         *        Represents an update for encryption at rest configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationEncryptionConfigurationUpdate(
                ApplicationEncryptionConfigurationUpdate applicationEncryptionConfigurationUpdate);

        /**
         * <p>
         * Represents an update for encryption at rest configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ApplicationEncryptionConfigurationUpdate.Builder} avoiding the need to create one manually via
         * {@link ApplicationEncryptionConfigurationUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApplicationEncryptionConfigurationUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #applicationEncryptionConfigurationUpdate(ApplicationEncryptionConfigurationUpdate)}.
         * 
         * @param applicationEncryptionConfigurationUpdate
         *        a consumer that will call methods on {@link ApplicationEncryptionConfigurationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationEncryptionConfigurationUpdate(ApplicationEncryptionConfigurationUpdate)
         */
        default Builder applicationEncryptionConfigurationUpdate(
                Consumer<ApplicationEncryptionConfigurationUpdate.Builder> applicationEncryptionConfigurationUpdate) {
            return applicationEncryptionConfigurationUpdate(ApplicationEncryptionConfigurationUpdate.builder()
                    .applyMutation(applicationEncryptionConfigurationUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;

        private ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;

        private FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;

        private EnvironmentPropertyUpdates environmentPropertyUpdates;

        private ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;

        private ApplicationSystemRollbackConfigurationUpdate applicationSystemRollbackConfigurationUpdate;

        private List<VpcConfigurationUpdate> vpcConfigurationUpdates = DefaultSdkAutoConstructList.getInstance();

        private ZeppelinApplicationConfigurationUpdate zeppelinApplicationConfigurationUpdate;

        private ApplicationEncryptionConfigurationUpdate applicationEncryptionConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfigurationUpdate model) {
            sqlApplicationConfigurationUpdate(model.sqlApplicationConfigurationUpdate);
            applicationCodeConfigurationUpdate(model.applicationCodeConfigurationUpdate);
            flinkApplicationConfigurationUpdate(model.flinkApplicationConfigurationUpdate);
            environmentPropertyUpdates(model.environmentPropertyUpdates);
            applicationSnapshotConfigurationUpdate(model.applicationSnapshotConfigurationUpdate);
            applicationSystemRollbackConfigurationUpdate(model.applicationSystemRollbackConfigurationUpdate);
            vpcConfigurationUpdates(model.vpcConfigurationUpdates);
            zeppelinApplicationConfigurationUpdate(model.zeppelinApplicationConfigurationUpdate);
            applicationEncryptionConfigurationUpdate(model.applicationEncryptionConfigurationUpdate);
        }

        public final SqlApplicationConfigurationUpdate.Builder getSqlApplicationConfigurationUpdate() {
            return sqlApplicationConfigurationUpdate != null ? sqlApplicationConfigurationUpdate.toBuilder() : null;
        }

        public final void setSqlApplicationConfigurationUpdate(
                SqlApplicationConfigurationUpdate.BuilderImpl sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate != null ? sqlApplicationConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate;
            return this;
        }

        public final ApplicationCodeConfigurationUpdate.Builder getApplicationCodeConfigurationUpdate() {
            return applicationCodeConfigurationUpdate != null ? applicationCodeConfigurationUpdate.toBuilder() : null;
        }

        public final void setApplicationCodeConfigurationUpdate(
                ApplicationCodeConfigurationUpdate.BuilderImpl applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate != null ? applicationCodeConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder applicationCodeConfigurationUpdate(
                ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate;
            return this;
        }

        public final FlinkApplicationConfigurationUpdate.Builder getFlinkApplicationConfigurationUpdate() {
            return flinkApplicationConfigurationUpdate != null ? flinkApplicationConfigurationUpdate.toBuilder() : null;
        }

        public final void setFlinkApplicationConfigurationUpdate(
                FlinkApplicationConfigurationUpdate.BuilderImpl flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate != null ? flinkApplicationConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder flinkApplicationConfigurationUpdate(
                FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate;
            return this;
        }

        public final EnvironmentPropertyUpdates.Builder getEnvironmentPropertyUpdates() {
            return environmentPropertyUpdates != null ? environmentPropertyUpdates.toBuilder() : null;
        }

        public final void setEnvironmentPropertyUpdates(EnvironmentPropertyUpdates.BuilderImpl environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates != null ? environmentPropertyUpdates.build() : null;
        }

        @Override
        public final Builder environmentPropertyUpdates(EnvironmentPropertyUpdates environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates;
            return this;
        }

        public final ApplicationSnapshotConfigurationUpdate.Builder getApplicationSnapshotConfigurationUpdate() {
            return applicationSnapshotConfigurationUpdate != null ? applicationSnapshotConfigurationUpdate.toBuilder() : null;
        }

        public final void setApplicationSnapshotConfigurationUpdate(
                ApplicationSnapshotConfigurationUpdate.BuilderImpl applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate != null ? applicationSnapshotConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder applicationSnapshotConfigurationUpdate(
                ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate;
            return this;
        }

        public final ApplicationSystemRollbackConfigurationUpdate.Builder getApplicationSystemRollbackConfigurationUpdate() {
            return applicationSystemRollbackConfigurationUpdate != null ? applicationSystemRollbackConfigurationUpdate
                    .toBuilder() : null;
        }

        public final void setApplicationSystemRollbackConfigurationUpdate(
                ApplicationSystemRollbackConfigurationUpdate.BuilderImpl applicationSystemRollbackConfigurationUpdate) {
            this.applicationSystemRollbackConfigurationUpdate = applicationSystemRollbackConfigurationUpdate != null ? applicationSystemRollbackConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder applicationSystemRollbackConfigurationUpdate(
                ApplicationSystemRollbackConfigurationUpdate applicationSystemRollbackConfigurationUpdate) {
            this.applicationSystemRollbackConfigurationUpdate = applicationSystemRollbackConfigurationUpdate;
            return this;
        }

        public final List<VpcConfigurationUpdate.Builder> getVpcConfigurationUpdates() {
            List<VpcConfigurationUpdate.Builder> result = VpcConfigurationUpdatesCopier
                    .copyToBuilder(this.vpcConfigurationUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConfigurationUpdates(Collection<VpcConfigurationUpdate.BuilderImpl> vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates = VpcConfigurationUpdatesCopier.copyFromBuilder(vpcConfigurationUpdates);
        }

        @Override
        public final Builder vpcConfigurationUpdates(Collection<VpcConfigurationUpdate> vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates = VpcConfigurationUpdatesCopier.copy(vpcConfigurationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationUpdates(VpcConfigurationUpdate... vpcConfigurationUpdates) {
            vpcConfigurationUpdates(Arrays.asList(vpcConfigurationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationUpdates(Consumer<VpcConfigurationUpdate.Builder>... vpcConfigurationUpdates) {
            vpcConfigurationUpdates(Stream.of(vpcConfigurationUpdates)
                    .map(c -> VpcConfigurationUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ZeppelinApplicationConfigurationUpdate.Builder getZeppelinApplicationConfigurationUpdate() {
            return zeppelinApplicationConfigurationUpdate != null ? zeppelinApplicationConfigurationUpdate.toBuilder() : null;
        }

        public final void setZeppelinApplicationConfigurationUpdate(
                ZeppelinApplicationConfigurationUpdate.BuilderImpl zeppelinApplicationConfigurationUpdate) {
            this.zeppelinApplicationConfigurationUpdate = zeppelinApplicationConfigurationUpdate != null ? zeppelinApplicationConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder zeppelinApplicationConfigurationUpdate(
                ZeppelinApplicationConfigurationUpdate zeppelinApplicationConfigurationUpdate) {
            this.zeppelinApplicationConfigurationUpdate = zeppelinApplicationConfigurationUpdate;
            return this;
        }

        public final ApplicationEncryptionConfigurationUpdate.Builder getApplicationEncryptionConfigurationUpdate() {
            return applicationEncryptionConfigurationUpdate != null ? applicationEncryptionConfigurationUpdate.toBuilder() : null;
        }

        public final void setApplicationEncryptionConfigurationUpdate(
                ApplicationEncryptionConfigurationUpdate.BuilderImpl applicationEncryptionConfigurationUpdate) {
            this.applicationEncryptionConfigurationUpdate = applicationEncryptionConfigurationUpdate != null ? applicationEncryptionConfigurationUpdate
                    .build() : null;
        }

        @Override
        public final Builder applicationEncryptionConfigurationUpdate(
                ApplicationEncryptionConfigurationUpdate applicationEncryptionConfigurationUpdate) {
            this.applicationEncryptionConfigurationUpdate = applicationEncryptionConfigurationUpdate;
            return this;
        }

        @Override
        public ApplicationConfigurationUpdate build() {
            return new ApplicationConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
