/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeValidationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConcurrentModificationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationOperationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationOperationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidApplicationConfigurationException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InvalidRequestException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Exception;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.LimitExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ResourceProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.TooManyTagsException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UnableToDetectSchemaException;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable;
import software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable;
import software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable;
import software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable;

/**
 * Service client for accessing Kinesis Analytics V2. This can be created using the static {@link #builder()} method.
 *
 * <note>
 * <p>
 * Amazon Managed Service for Apache Flink was previously known as Amazon Kinesis Data Analytics for Apache Flink.
 * </p>
 * </note>
 * <p>
 * Amazon Managed Service for Apache Flink is a fully managed service that you can use to process and analyze streaming
 * data using Java, Python, SQL, or Scala. The service enables you to quickly author and run Java, SQL, or Scala code
 * against streaming sources to perform time series analytics, feed real-time dashboards, and create real-time metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface KinesisAnalyticsV2Client extends AwsClient {
    String SERVICE_NAME = "kinesisanalytics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kinesisanalytics";

    /**
     * <p>
     * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
     * </p>
     *
     * @param addApplicationCloudWatchLoggingOptionRequest
     * @return Result of the AddApplicationCloudWatchLoggingOption operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationCloudWatchLoggingOptionResponse addApplicationCloudWatchLoggingOption(
            AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an Amazon CloudWatch log stream to monitor application configuration errors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AddApplicationCloudWatchLoggingOptionRequest.Builder} avoiding the need to create one manually via
     * {@link AddApplicationCloudWatchLoggingOptionRequest#builder()}
     * </p>
     *
     * @param addApplicationCloudWatchLoggingOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest.Builder}
     *        to create a request.
     * @return Result of the AddApplicationCloudWatchLoggingOption operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationCloudWatchLoggingOptionResponse addApplicationCloudWatchLoggingOption(
            Consumer<AddApplicationCloudWatchLoggingOptionRequest.Builder> addApplicationCloudWatchLoggingOptionRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest.builder()
                .applyMutation(addApplicationCloudWatchLoggingOptionRequest).build());
    }

    /**
     * <p>
     * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * You can add a streaming source when you create an application, or you can use this operation to add a streaming
     * source after you create an application. For more information, see <a>CreateApplication</a>.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     *
     * @param addApplicationInputRequest
     * @return Result of the AddApplicationInput operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws CodeValidationException
     *         The user-provided application code (query) is not valid. This can be a simple syntax error.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationInputResponse addApplicationInput(AddApplicationInputRequest addApplicationInputRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            CodeValidationException, InvalidRequestException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a streaming source to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * You can add a streaming source when you create an application, or you can use this operation to add a streaming
     * source after you create an application. For more information, see <a>CreateApplication</a>.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationInputRequest.Builder} avoiding the
     * need to create one manually via {@link AddApplicationInputRequest#builder()}
     * </p>
     *
     * @param addApplicationInputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest.Builder} to
     *        create a request.
     * @return Result of the AddApplicationInput operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws CodeValidationException
     *         The user-provided application code (query) is not valid. This can be a simple syntax error.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationInput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInput"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationInputResponse addApplicationInput(
            Consumer<AddApplicationInputRequest.Builder> addApplicationInputRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, CodeValidationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return addApplicationInput(AddApplicationInputRequest.builder().applyMutation(addApplicationInputRequest).build());
    }

    /**
     * <p>
     * Adds an <a>InputProcessingConfiguration</a> to a SQL-based Kinesis Data Analytics application. An input processor
     * pre-processes records on the input stream before the application's SQL code executes. Currently, the only input
     * processor available is <a href="https://docs.aws.amazon.com/lambda/">Amazon Lambda</a>.
     * </p>
     *
     * @param addApplicationInputProcessingConfigurationRequest
     * @return Result of the AddApplicationInputProcessingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationInputProcessingConfigurationResponse addApplicationInputProcessingConfiguration(
            AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an <a>InputProcessingConfiguration</a> to a SQL-based Kinesis Data Analytics application. An input processor
     * pre-processes records on the input stream before the application's SQL code executes. Currently, the only input
     * processor available is <a href="https://docs.aws.amazon.com/lambda/">Amazon Lambda</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AddApplicationInputProcessingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link AddApplicationInputProcessingConfigurationRequest#builder()}
     * </p>
     *
     * @param addApplicationInputProcessingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the AddApplicationInputProcessingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationInputProcessingConfigurationResponse addApplicationInputProcessingConfiguration(
            Consumer<AddApplicationInputProcessingConfigurationRequest.Builder> addApplicationInputProcessingConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest.builder()
                .applyMutation(addApplicationInputProcessingConfigurationRequest).build());
    }

    /**
     * <p>
     * Adds an external destination to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an
     * external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon
     * Lambda function), you add the relevant configuration to your application using this operation. You can configure
     * one or more outputs for your application. Each output configuration maps an in-application stream and an external
     * destination.
     * </p>
     * <p>
     * You can use one of the output configurations to deliver data from your in-application error stream to an external
     * destination so that you can analyze the errors.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     *
     * @param addApplicationOutputRequest
     * @return Result of the AddApplicationOutput operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationOutputResponse addApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an external destination to your SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * If you want Kinesis Data Analytics to deliver data from an in-application stream within your application to an
     * external destination (such as an Kinesis data stream, a Kinesis Data Firehose delivery stream, or an Amazon
     * Lambda function), you add the relevant configuration to your application using this operation. You can configure
     * one or more outputs for your application. Each output configuration maps an in-application stream and an external
     * destination.
     * </p>
     * <p>
     * You can use one of the output configurations to deliver data from your in-application error stream to an external
     * destination so that you can analyze the errors.
     * </p>
     * <p>
     * Any configuration update, including adding a streaming source using this operation, results in a new version of
     * the application. You can use the <a>DescribeApplication</a> operation to find the current application version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationOutputRequest.Builder} avoiding the
     * need to create one manually via {@link AddApplicationOutputRequest#builder()}
     * </p>
     *
     * @param addApplicationOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationOutputRequest.Builder} to
     *        create a request.
     * @return Result of the AddApplicationOutput operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationOutputResponse addApplicationOutput(
            Consumer<AddApplicationOutputRequest.Builder> addApplicationOutputRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return addApplicationOutput(AddApplicationOutputRequest.builder().applyMutation(addApplicationOutputRequest).build());
    }

    /**
     * <p>
     * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table
     * within your application. In the request, you provide the source (S3 bucket name and object key name), name of the
     * in-application table to create, and the necessary mapping information that describes how data in an Amazon S3
     * object maps to columns in the resulting in-application table.
     * </p>
     *
     * @param addApplicationReferenceDataSourceRequest
     * @return Result of the AddApplicationReferenceDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationReferenceDataSourceResponse addApplicationReferenceDataSource(
            AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.
     * </p>
     * <p>
     * Kinesis Data Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table
     * within your application. In the request, you provide the source (S3 bucket name and object key name), name of the
     * in-application table to create, and the necessary mapping information that describes how data in an Amazon S3
     * object maps to columns in the resulting in-application table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationReferenceDataSourceRequest.Builder}
     * avoiding the need to create one manually via {@link AddApplicationReferenceDataSourceRequest#builder()}
     * </p>
     *
     * @param addApplicationReferenceDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceRequest.Builder}
     *        to create a request.
     * @return Result of the AddApplicationReferenceDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationReferenceDataSourceResponse addApplicationReferenceDataSource(
            Consumer<AddApplicationReferenceDataSourceRequest.Builder> addApplicationReferenceDataSourceRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest.builder()
                .applyMutation(addApplicationReferenceDataSourceRequest).build());
    }

    /**
     * <p>
     * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and
     * access resources securely.
     * </p>
     * <p>
     * Note the following about VPC configurations for Managed Service for Apache Flink applications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VPC configurations are not supported for SQL applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * When a VPC is added to a Managed Service for Apache Flink application, the application can no longer be accessed
     * from the Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
     * </p>
     * </li>
     * </ul>
     *
     * @param addApplicationVpcConfigurationRequest
     * @return Result of the AddApplicationVpcConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationVpcConfigurationResponse addApplicationVpcConfiguration(
            AddApplicationVpcConfigurationRequest addApplicationVpcConfigurationRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a Virtual Private Cloud (VPC) configuration to the application. Applications can use VPCs to store and
     * access resources securely.
     * </p>
     * <p>
     * Note the following about VPC configurations for Managed Service for Apache Flink applications:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VPC configurations are not supported for SQL applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * When a VPC is added to a Managed Service for Apache Flink application, the application can no longer be accessed
     * from the Internet directly. To enable Internet access to the application, add an Internet gateway to your VPC.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddApplicationVpcConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link AddApplicationVpcConfigurationRequest#builder()}
     * </p>
     *
     * @param addApplicationVpcConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the AddApplicationVpcConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.AddApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/AddApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default AddApplicationVpcConfigurationResponse addApplicationVpcConfiguration(
            Consumer<AddApplicationVpcConfigurationRequest.Builder> addApplicationVpcConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return addApplicationVpcConfiguration(AddApplicationVpcConfigurationRequest.builder()
                .applyMutation(addApplicationVpcConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a Managed Service for Apache Flink application. For information about creating a Managed Service for
     * Apache Flink application, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html">Creating an Application</a>.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws CodeValidationException
     *         The user-provided application code (query) is not valid. This can be a simple syntax error.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws LimitExceededException
     *         The number of allowed resources has been exceeded.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws TooManyTagsException
     *         Application created with too many tags, or too many tags added to an application. Note that the maximum
     *         number of application tags includes system tags. The maximum number of user-defined application tags is
     *         50.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws CodeValidationException, ResourceInUseException, LimitExceededException, InvalidArgumentException,
            InvalidRequestException, TooManyTagsException, ConcurrentModificationException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Managed Service for Apache Flink application. For information about creating a Managed Service for
     * Apache Flink application, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html">Creating an Application</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws CodeValidationException
     *         The user-provided application code (query) is not valid. This can be a simple syntax error.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws LimitExceededException
     *         The number of allowed resources has been exceeded.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws TooManyTagsException
     *         Application created with too many tags, or too many tags added to an application. Note that the maximum
     *         number of application tags includes system tags. The maximum number of user-defined application tags is
     *         50.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws CodeValidationException, ResourceInUseException, LimitExceededException, InvalidArgumentException,
            InvalidRequestException, TooManyTagsException, ConcurrentModificationException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates and returns a URL that you can use to connect to an application's extension.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned
     * URL is created, no additional permission is required to access this URL. IAM authorization policies for this API
     * are also enforced for every HTTP request that attempts to connect to the extension.
     * </p>
     * <p>
     * You control the amount of time that the URL will be valid using the
     * <code>SessionExpirationDurationInSeconds</code> parameter. If you do not provide this parameter, the returned URL
     * is valid for twelve hours.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If
     * you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
     * </p>
     * </note>
     *
     * @param createApplicationPresignedUrlRequest
     * @return Result of the CreateApplicationPresignedUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.CreateApplicationPresignedUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationPresignedUrlResponse createApplicationPresignedUrl(
            CreateApplicationPresignedUrlRequest createApplicationPresignedUrlRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and returns a URL that you can use to connect to an application's extension.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the extension. After the presigned
     * URL is created, no additional permission is required to access this URL. IAM authorization policies for this API
     * are also enforced for every HTTP request that attempts to connect to the extension.
     * </p>
     * <p>
     * You control the amount of time that the URL will be valid using the
     * <code>SessionExpirationDurationInSeconds</code> parameter. If you do not provide this parameter, the returned URL
     * is valid for twelve hours.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to CreateApplicationPresignedUrl must be used within 3 minutes to be valid. If
     * you first try to use the URL after the 3-minute limit expires, the service returns an HTTP 403 Forbidden error.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationPresignedUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreateApplicationPresignedUrlRequest#builder()}
     * </p>
     *
     * @param createApplicationPresignedUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlRequest.Builder}
     *        to create a request.
     * @return Result of the CreateApplicationPresignedUrl operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.CreateApplicationPresignedUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationPresignedUrlResponse createApplicationPresignedUrl(
            Consumer<CreateApplicationPresignedUrlRequest.Builder> createApplicationPresignedUrlRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return createApplicationPresignedUrl(CreateApplicationPresignedUrlRequest.builder()
                .applyMutation(createApplicationPresignedUrlRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of the application's state data.
     * </p>
     *
     * @param createApplicationSnapshotRequest
     * @return Result of the CreateApplicationSnapshot operation returned by the service.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws LimitExceededException
     *         The number of allowed resources has been exceeded.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.CreateApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationSnapshotResponse createApplicationSnapshot(
            CreateApplicationSnapshotRequest createApplicationSnapshotRequest) throws ResourceInUseException,
            ResourceNotFoundException, LimitExceededException, InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, InvalidRequestException,
            InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the application's state data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationSnapshotRequest#builder()}
     * </p>
     *
     * @param createApplicationSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the CreateApplicationSnapshot operation returned by the service.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws LimitExceededException
     *         The number of allowed resources has been exceeded.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.CreateApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CreateApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationSnapshotResponse createApplicationSnapshot(
            Consumer<CreateApplicationSnapshotRequest.Builder> createApplicationSnapshotRequest) throws ResourceInUseException,
            ResourceNotFoundException, LimitExceededException, InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, InvalidRequestException,
            InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return createApplicationSnapshot(CreateApplicationSnapshotRequest.builder()
                .applyMutation(createApplicationSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes the specified application. Managed Service for Apache Flink halts application execution and deletes the
     * application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ConcurrentModificationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException,
            InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application. Managed Service for Apache Flink halts application execution and deletes the
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws ConcurrentModificationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException,
            InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon CloudWatch log stream from an SQL-based Kinesis Data Analytics application.
     * </p>
     *
     * @param deleteApplicationCloudWatchLoggingOptionRequest
     * @return Result of the DeleteApplicationCloudWatchLoggingOption operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationCloudWatchLoggingOptionResponse deleteApplicationCloudWatchLoggingOption(
            DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon CloudWatch log stream from an SQL-based Kinesis Data Analytics application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationCloudWatchLoggingOptionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationCloudWatchLoggingOptionRequest#builder()}
     * </p>
     *
     * @param deleteApplicationCloudWatchLoggingOptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApplicationCloudWatchLoggingOption operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationCloudWatchLoggingOption
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationCloudWatchLoggingOption"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationCloudWatchLoggingOptionResponse deleteApplicationCloudWatchLoggingOption(
            Consumer<DeleteApplicationCloudWatchLoggingOptionRequest.Builder> deleteApplicationCloudWatchLoggingOptionRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, InvalidApplicationConfigurationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest.builder()
                .applyMutation(deleteApplicationCloudWatchLoggingOptionRequest).build());
    }

    /**
     * <p>
     * Deletes an <a>InputProcessingConfiguration</a> from an input.
     * </p>
     *
     * @param deleteApplicationInputProcessingConfigurationRequest
     * @return Result of the DeleteApplicationInputProcessingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationInputProcessingConfigurationResponse deleteApplicationInputProcessingConfiguration(
            DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <a>InputProcessingConfiguration</a> from an input.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationInputProcessingConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationInputProcessingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationInputProcessingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApplicationInputProcessingConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationInputProcessingConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationInputProcessingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationInputProcessingConfigurationResponse deleteApplicationInputProcessingConfiguration(
            Consumer<DeleteApplicationInputProcessingConfigurationRequest.Builder> deleteApplicationInputProcessingConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest.builder()
                .applyMutation(deleteApplicationInputProcessingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's
     * configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to
     * the external output destination.
     * </p>
     *
     * @param deleteApplicationOutputRequest
     * @return Result of the DeleteApplicationOutput operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationOutputResponse deleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the output destination configuration from your SQL-based Kinesis Data Analytics application's
     * configuration. Kinesis Data Analytics will no longer write data from the corresponding in-application stream to
     * the external output destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationOutputRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApplicationOutputRequest#builder()}
     * </p>
     *
     * @param deleteApplicationOutputRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteApplicationOutput operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationOutput
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationOutput"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationOutputResponse deleteApplicationOutput(
            Consumer<DeleteApplicationOutputRequest.Builder> deleteApplicationOutputRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, ConcurrentModificationException, InvalidRequestException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return deleteApplicationOutput(DeleteApplicationOutputRequest.builder().applyMutation(deleteApplicationOutputRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's
     * configuration.
     * </p>
     * <p>
     * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you
     * created using the <a>AddApplicationReferenceDataSource</a> operation.
     * </p>
     *
     * @param deleteApplicationReferenceDataSourceRequest
     * @return Result of the DeleteApplicationReferenceDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationReferenceDataSourceResponse deleteApplicationReferenceDataSource(
            DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reference data source configuration from the specified SQL-based Kinesis Data Analytics application's
     * configuration.
     * </p>
     * <p>
     * If the application is running, Kinesis Data Analytics immediately removes the in-application table that you
     * created using the <a>AddApplicationReferenceDataSource</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteApplicationReferenceDataSourceRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteApplicationReferenceDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteApplicationReferenceDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApplicationReferenceDataSource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationReferenceDataSource
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationReferenceDataSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationReferenceDataSourceResponse deleteApplicationReferenceDataSource(
            Consumer<DeleteApplicationReferenceDataSourceRequest.Builder> deleteApplicationReferenceDataSourceRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest.builder()
                .applyMutation(deleteApplicationReferenceDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a snapshot of application state.
     * </p>
     *
     * @param deleteApplicationSnapshotRequest
     * @return Result of the DeleteApplicationSnapshot operation returned by the service.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationSnapshotResponse deleteApplicationSnapshot(
            DeleteApplicationSnapshotRequest deleteApplicationSnapshotRequest) throws ResourceInUseException,
            InvalidArgumentException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            InvalidRequestException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a snapshot of application state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApplicationSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteApplicationSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApplicationSnapshot operation returned by the service.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationSnapshotResponse deleteApplicationSnapshot(
            Consumer<DeleteApplicationSnapshotRequest.Builder> deleteApplicationSnapshotRequest) throws ResourceInUseException,
            InvalidArgumentException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            InvalidRequestException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return deleteApplicationSnapshot(DeleteApplicationSnapshotRequest.builder()
                .applyMutation(deleteApplicationSnapshotRequest).build());
    }

    /**
     * <p>
     * Removes a VPC configuration from a Managed Service for Apache Flink application.
     * </p>
     *
     * @param deleteApplicationVpcConfigurationRequest
     * @return Result of the DeleteApplicationVpcConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationVpcConfigurationResponse deleteApplicationVpcConfiguration(
            DeleteApplicationVpcConfigurationRequest deleteApplicationVpcConfigurationRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a VPC configuration from a Managed Service for Apache Flink application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationVpcConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApplicationVpcConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationVpcConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteApplicationVpcConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DeleteApplicationVpcConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DeleteApplicationVpcConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationVpcConfigurationResponse deleteApplicationVpcConfiguration(
            Consumer<DeleteApplicationVpcConfigurationRequest.Builder> deleteApplicationVpcConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            InvalidApplicationConfigurationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return deleteApplicationVpcConfiguration(DeleteApplicationVpcConfigurationRequest.builder()
                .applyMutation(deleteApplicationVpcConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific Managed Service for Apache Flink application.
     * </p>
     * <p>
     * If you want to retrieve a list of all applications in your account, use the <a>ListApplications</a> operation.
     * </p>
     *
     * @param describeApplicationRequest
     * @return Result of the DescribeApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationResponse describeApplication(DescribeApplicationRequest describeApplicationRequest)
            throws ResourceNotFoundException, InvalidArgumentException, InvalidRequestException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific Managed Service for Apache Flink application.
     * </p>
     * <p>
     * If you want to retrieve a list of all applications in your account, use the <a>ListApplications</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationRequest#builder()}
     * </p>
     *
     * @param describeApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationResponse describeApplication(
            Consumer<DescribeApplicationRequest.Builder> describeApplicationRequest) throws ResourceNotFoundException,
            InvalidArgumentException, InvalidRequestException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return describeApplication(DescribeApplicationRequest.builder().applyMutation(describeApplicationRequest).build());
    }

    /**
     * <p>
     * Provides a detailed description of a specified application operation. To see a list of all the operations of an
     * application, invoke the <a>ListApplicationOperations</a> operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note>
     *
     * @param describeApplicationOperationRequest
     *        A request for information about a specific operation that was performed on a Managed Service for Apache
     *        Flink application.
     * @return Result of the DescribeApplicationOperation operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplicationOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationOperationResponse describeApplicationOperation(
            DescribeApplicationOperationRequest describeApplicationOperationRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed description of a specified application operation. To see a list of all the operations of an
     * application, invoke the <a>ListApplicationOperations</a> operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationOperationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationOperationRequest#builder()}
     * </p>
     *
     * @param describeApplicationOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationOperationRequest.Builder}
     *        to create a request. A request for information about a specific operation that was performed on a Managed
     *        Service for Apache Flink application.
     * @return Result of the DescribeApplicationOperation operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplicationOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationOperation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationOperationResponse describeApplicationOperation(
            Consumer<DescribeApplicationOperationRequest.Builder> describeApplicationOperationRequest)
            throws InvalidArgumentException, ResourceNotFoundException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return describeApplicationOperation(DescribeApplicationOperationRequest.builder()
                .applyMutation(describeApplicationOperationRequest).build());
    }

    /**
     * <p>
     * Returns information about a snapshot of application state data.
     * </p>
     *
     * @param describeApplicationSnapshotRequest
     * @return Result of the DescribeApplicationSnapshot operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationSnapshotResponse describeApplicationSnapshot(
            DescribeApplicationSnapshotRequest describeApplicationSnapshotRequest) throws ResourceNotFoundException,
            InvalidArgumentException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a snapshot of application state data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationSnapshotRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeApplicationSnapshotRequest#builder()}
     * </p>
     *
     * @param describeApplicationSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeApplicationSnapshot operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplicationSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationSnapshotResponse describeApplicationSnapshot(
            Consumer<DescribeApplicationSnapshotRequest.Builder> describeApplicationSnapshotRequest)
            throws ResourceNotFoundException, InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return describeApplicationSnapshot(DescribeApplicationSnapshotRequest.builder()
                .applyMutation(describeApplicationSnapshotRequest).build());
    }

    /**
     * <p>
     * Provides a detailed description of a specified version of the application. To see a list of all the versions of
     * an application, invoke the <a>ListApplicationVersions</a> operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note>
     *
     * @param describeApplicationVersionRequest
     * @return Result of the DescribeApplicationVersion operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationVersionResponse describeApplicationVersion(
            DescribeApplicationVersionRequest describeApplicationVersionRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a detailed description of a specified version of the application. To see a list of all the versions of
     * an application, invoke the <a>ListApplicationVersions</a> operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeApplicationVersionRequest#builder()}
     * </p>
     *
     * @param describeApplicationVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeApplicationVersion operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DescribeApplicationVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DescribeApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationVersionResponse describeApplicationVersion(
            Consumer<DescribeApplicationVersionRequest.Builder> describeApplicationVersionRequest)
            throws InvalidArgumentException, ResourceNotFoundException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return describeApplicationVersion(DescribeApplicationVersionRequest.builder()
                .applyMutation(describeApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified
     * streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the
     * response, the operation returns the inferred schema and also the sample records that the operation used to infer
     * the schema.
     * </p>
     * <p>
     * You can use the inferred schema when configuring a streaming source for your application. When you create an
     * application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show
     * it in the console user interface.
     * </p>
     *
     * @param discoverInputSchemaRequest
     * @return Result of the DiscoverInputSchema operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnableToDetectSchemaException
     *         The data format is not valid. Kinesis Data Analytics cannot detect the schema for the given streaming
     *         source.
     * @throws ResourceProvisionedThroughputExceededException
     *         Discovery failed to get a record from the streaming source because of the Kinesis Streams
     *         <code>ProvisionedThroughputExceededException</code>. For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html">GetRecords</a> in the
     *         Amazon Kinesis Streams API Reference.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DiscoverInputSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default DiscoverInputSchemaResponse discoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest)
            throws InvalidArgumentException, UnableToDetectSchemaException, ResourceProvisionedThroughputExceededException,
            ServiceUnavailableException, InvalidRequestException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Infers a schema for a SQL-based Kinesis Data Analytics application by evaluating sample records on the specified
     * streaming source (Kinesis data stream or Kinesis Data Firehose delivery stream) or Amazon S3 object. In the
     * response, the operation returns the inferred schema and also the sample records that the operation used to infer
     * the schema.
     * </p>
     * <p>
     * You can use the inferred schema when configuring a streaming source for your application. When you create an
     * application using the Kinesis Data Analytics console, the console uses this operation to infer a schema and show
     * it in the console user interface.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DiscoverInputSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link DiscoverInputSchemaRequest#builder()}
     * </p>
     *
     * @param discoverInputSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.Builder} to
     *        create a request.
     * @return Result of the DiscoverInputSchema operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnableToDetectSchemaException
     *         The data format is not valid. Kinesis Data Analytics cannot detect the schema for the given streaming
     *         source.
     * @throws ResourceProvisionedThroughputExceededException
     *         Discovery failed to get a record from the streaming source because of the Kinesis Streams
     *         <code>ProvisionedThroughputExceededException</code>. For more information, see <a
     *         href="http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetRecords.html">GetRecords</a> in the
     *         Amazon Kinesis Streams API Reference.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.DiscoverInputSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DiscoverInputSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default DiscoverInputSchemaResponse discoverInputSchema(
            Consumer<DiscoverInputSchemaRequest.Builder> discoverInputSchemaRequest) throws InvalidArgumentException,
            UnableToDetectSchemaException, ResourceProvisionedThroughputExceededException, ServiceUnavailableException,
            InvalidRequestException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return discoverInputSchema(DiscoverInputSchemaRequest.builder().applyMutation(discoverInputSchemaRequest).build());
    }

    /**
     * <p>
     * Lists all the operations performed for the specified application such as UpdateApplication, StartApplication etc.
     * The response also includes a summary of the operation.
     * </p>
     * <p>
     * To get the complete description of a specific operation, invoke the <a>DescribeApplicationOperation</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note>
     *
     * @param listApplicationOperationsRequest
     *        A request for a list of operations performed on an application.
     * @return Result of the ListApplicationOperations operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationOperationsResponse listApplicationOperations(
            ListApplicationOperationsRequest listApplicationOperationsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the operations performed for the specified application such as UpdateApplication, StartApplication etc.
     * The response also includes a summary of the operation.
     * </p>
     * <p>
     * To get the complete description of a specific operation, invoke the <a>DescribeApplicationOperation</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationOperationsRequest#builder()}
     * </p>
     *
     * @param listApplicationOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest.Builder}
     *        to create a request. A request for a list of operations performed on an application.
     * @return Result of the ListApplicationOperations operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationOperationsResponse listApplicationOperations(
            Consumer<ListApplicationOperationsRequest.Builder> listApplicationOperationsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationOperations(ListApplicationOperationsRequest.builder()
                .applyMutation(listApplicationOperationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationOperations(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable responses = client.listApplicationOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable responses = client
     *             .listApplicationOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable responses = client.listApplicationOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationOperations(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationOperationsRequest
     *        A request for a list of operations performed on an application.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationOperationsIterable listApplicationOperationsPaginator(
            ListApplicationOperationsRequest listApplicationOperationsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return new ListApplicationOperationsIterable(this, listApplicationOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationOperations(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable responses = client.listApplicationOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable responses = client
     *             .listApplicationOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationOperationsIterable responses = client.listApplicationOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationOperations(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationOperationsRequest#builder()}
     * </p>
     *
     * @param listApplicationOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest.Builder}
     *        to create a request. A request for a list of operations performed on an application.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationOperationsIterable listApplicationOperationsPaginator(
            Consumer<ListApplicationOperationsRequest.Builder> listApplicationOperationsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationOperationsPaginator(ListApplicationOperationsRequest.builder()
                .applyMutation(listApplicationOperationsRequest).build());
    }

    /**
     * <p>
     * Lists information about the current application snapshots.
     * </p>
     *
     * @param listApplicationSnapshotsRequest
     * @return Result of the ListApplicationSnapshots operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationSnapshotsResponse listApplicationSnapshots(
            ListApplicationSnapshotsRequest listApplicationSnapshotsRequest) throws InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about the current application snapshots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationSnapshotsRequest#builder()}
     * </p>
     *
     * @param listApplicationSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.Builder}
     *        to create a request.
     * @return Result of the ListApplicationSnapshots operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationSnapshotsResponse listApplicationSnapshots(
            Consumer<ListApplicationSnapshotsRequest.Builder> listApplicationSnapshotsRequest) throws InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationSnapshots(ListApplicationSnapshotsRequest.builder().applyMutation(listApplicationSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationSnapshots(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable responses = client.listApplicationSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable responses = client
     *             .listApplicationSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable responses = client.listApplicationSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationSnapshots(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationSnapshotsIterable listApplicationSnapshotsPaginator(
            ListApplicationSnapshotsRequest listApplicationSnapshotsRequest) throws InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return new ListApplicationSnapshotsIterable(this, listApplicationSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationSnapshots(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable responses = client.listApplicationSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable responses = client
     *             .listApplicationSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationSnapshotsIterable responses = client.listApplicationSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationSnapshots(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationSnapshotsRequest#builder()}
     * </p>
     *
     * @param listApplicationSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationSnapshotsIterable listApplicationSnapshotsPaginator(
            Consumer<ListApplicationSnapshotsRequest.Builder> listApplicationSnapshotsRequest) throws InvalidArgumentException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationSnapshotsPaginator(ListApplicationSnapshotsRequest.builder()
                .applyMutation(listApplicationSnapshotsRequest).build());
    }

    /**
     * <p>
     * Lists all the versions for the specified application, including versions that were rolled back. The response also
     * includes a summary of the configuration associated with each version.
     * </p>
     * <p>
     * To get the complete description of a specific application version, invoke the <a>DescribeApplicationVersion</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note>
     *
     * @param listApplicationVersionsRequest
     * @return Result of the ListApplicationVersions operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsResponse listApplicationVersions(ListApplicationVersionsRequest listApplicationVersionsRequest)
            throws InvalidArgumentException, ResourceNotFoundException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the versions for the specified application, including versions that were rolled back. The response also
     * includes a summary of the configuration associated with each version.
     * </p>
     * <p>
     * To get the complete description of a specific application version, invoke the <a>DescribeApplicationVersion</a>
     * operation.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListApplicationVersions operation returned by the service.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsResponse listApplicationVersions(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationVersions(ListApplicationVersionsRequest.builder().applyMutation(listApplicationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable responses = client
     *             .listApplicationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsIterable listApplicationVersionsPaginator(
            ListApplicationVersionsRequest listApplicationVersionsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return new ListApplicationVersionsIterable(this, listApplicationVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplicationVersions(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable responses = client
     *             .listApplicationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationVersionsIterable responses = client.listApplicationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplicationVersions(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     * </p>
     *
     * @param listApplicationVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplicationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationVersionsIterable listApplicationVersionsPaginator(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) throws InvalidArgumentException,
            ResourceNotFoundException, software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationVersionsPaginator(ListApplicationVersionsRequest.builder()
                .applyMutation(listApplicationVersionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Managed Service for Apache Flink applications in your account. For each application, the
     * response includes the application name, Amazon Resource Name (ARN), and status.
     * </p>
     * <p>
     * If you want detailed information about a specific application, use <a>DescribeApplication</a>.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Managed Service for Apache Flink applications in your account. For each application, the
     * response includes the application name, Amazon Resource Name (ARN), and status.
     * </p>
     * <p>
     * If you want detailed information about a specific application, use <a>DescribeApplication</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Managed Service for Apache Flink applications in your account. For each application, the
     * response includes the application name, Amazon Resource Name (ARN), and status.
     * </p>
     * <p>
     * If you want detailed information about a specific application, use <a>DescribeApplication</a>.
     * </p>
     *
     * @return Result of the ListApplications operation returned by the service.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplications
     * @see #listApplications(ListApplicationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications() throws InvalidRequestException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplications
     * @see #listApplicationsPaginator(ListApplicationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator() throws InvalidRequestException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationsPaginator(ListApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesisanalyticsv2.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InvalidRequestException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of key-value tags assigned to the application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InvalidArgumentException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of key-value tags assigned to the application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InvalidArgumentException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Reverts the application to the previous running version. You can roll back an application if you suspect it is
     * stuck in a transient status or in the running status.
     * </p>
     * <p>
     * You can roll back an application only if it is in the <code>UPDATING</code>, <code>AUTOSCALING</code>, or
     * <code>RUNNING</code> statuses.
     * </p>
     * <p>
     * When you rollback an application, it loads state data from the last successful snapshot. If the application has
     * no snapshots, Managed Service for Apache Flink rejects the rollback request.
     * </p>
     *
     * @param rollbackApplicationRequest
     * @return Result of the RollbackApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.RollbackApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RollbackApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default RollbackApplicationResponse rollbackApplication(RollbackApplicationRequest rollbackApplicationRequest)
            throws ResourceNotFoundException, InvalidArgumentException, ResourceInUseException, InvalidRequestException,
            ConcurrentModificationException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reverts the application to the previous running version. You can roll back an application if you suspect it is
     * stuck in a transient status or in the running status.
     * </p>
     * <p>
     * You can roll back an application only if it is in the <code>UPDATING</code>, <code>AUTOSCALING</code>, or
     * <code>RUNNING</code> statuses.
     * </p>
     * <p>
     * When you rollback an application, it loads state data from the last successful snapshot. If the application has
     * no snapshots, Managed Service for Apache Flink rejects the rollback request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RollbackApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RollbackApplicationRequest#builder()}
     * </p>
     *
     * @param rollbackApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the RollbackApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.RollbackApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RollbackApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default RollbackApplicationResponse rollbackApplication(
            Consumer<RollbackApplicationRequest.Builder> rollbackApplicationRequest) throws ResourceNotFoundException,
            InvalidArgumentException, ResourceInUseException, InvalidRequestException, ConcurrentModificationException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return rollbackApplication(RollbackApplicationRequest.builder().applyMutation(rollbackApplicationRequest).build());
    }

    /**
     * <p>
     * Starts the specified Managed Service for Apache Flink application. After creating an application, you must
     * exclusively call this operation to start your application.
     * </p>
     *
     * @param startApplicationRequest
     * @return Result of the StartApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default StartApplicationResponse startApplication(StartApplicationRequest startApplicationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException,
            InvalidApplicationConfigurationException, InvalidRequestException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified Managed Service for Apache Flink application. After creating an application, you must
     * exclusively call this operation to start your application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartApplicationRequest#builder()}
     * </p>
     *
     * @param startApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest.Builder} to create
     *        a request.
     * @return Result of the StartApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.StartApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StartApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default StartApplicationResponse startApplication(Consumer<StartApplicationRequest.Builder> startApplicationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException,
            InvalidApplicationConfigurationException, InvalidRequestException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return startApplication(StartApplicationRequest.builder().applyMutation(startApplicationRequest).build());
    }

    /**
     * <p>
     * Stops the application from processing data. You can stop an application only if it is in the running status,
     * unless you set the <code>Force</code> parameter to <code>true</code>.
     * </p>
     * <p>
     * You can use the <a>DescribeApplication</a> operation to find the application status.
     * </p>
     * <p>
     * Managed Service for Apache Flink takes a snapshot when the application is stopped, unless <code>Force</code> is
     * set to <code>true</code>.
     * </p>
     *
     * @param stopApplicationRequest
     * @return Result of the StopApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default StopApplicationResponse stopApplication(StopApplicationRequest stopApplicationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidRequestException,
            InvalidApplicationConfigurationException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the application from processing data. You can stop an application only if it is in the running status,
     * unless you set the <code>Force</code> parameter to <code>true</code>.
     * </p>
     * <p>
     * You can use the <a>DescribeApplication</a> operation to find the application status.
     * </p>
     * <p>
     * Managed Service for Apache Flink takes a snapshot when the application is stopped, unless <code>Force</code> is
     * set to <code>true</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopApplicationRequest#builder()}
     * </p>
     *
     * @param stopApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.StopApplicationRequest.Builder} to create
     *        a request.
     * @return Result of the StopApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.StopApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default StopApplicationResponse stopApplication(Consumer<StopApplicationRequest.Builder> stopApplicationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, InvalidRequestException,
            InvalidApplicationConfigurationException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            KinesisAnalyticsV2Exception {
        return stopApplication(StopApplicationRequest.builder().applyMutation(stopApplicationRequest).build());
    }

    /**
     * <p>
     * Adds one or more key-value tags to a Managed Service for Apache Flink application. Note that the maximum number
     * of application tags includes system tags. The maximum number of user-defined application tags is 50. For more
     * information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using
     * Tagging</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws TooManyTagsException
     *         Application created with too many tags, or too many tags added to an application. Note that the maximum
     *         number of application tags includes system tags. The maximum number of user-defined application tags is
     *         50.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ResourceInUseException, TooManyTagsException, InvalidArgumentException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more key-value tags to a Managed Service for Apache Flink application. Note that the maximum number
     * of application tags includes system tags. The maximum number of user-defined application tags is 50. For more
     * information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using
     * Tagging</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws TooManyTagsException
     *         Application created with too many tags, or too many tags added to an application. Note that the maximum
     *         number of application tags includes system tags. The maximum number of user-defined application tags is
     *         50.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ResourceInUseException, TooManyTagsException, InvalidArgumentException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a Managed Service for Apache Flink application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws TooManyTagsException
     *         Application created with too many tags, or too many tags added to an application. Note that the maximum
     *         number of application tags includes system tags. The maximum number of user-defined application tags is
     *         50.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ResourceInUseException, TooManyTagsException, InvalidArgumentException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a Managed Service for Apache Flink application. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html">Using Tagging</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws TooManyTagsException
     *         Application created with too many tags, or too many tags added to an application. Note that the maximum
     *         number of application tags includes system tags. The maximum number of user-defined application tags is
     *         50.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ResourceInUseException, TooManyTagsException, InvalidArgumentException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Managed Service for Apache Flink application. Using this operation, you can update
     * application code, input configuration, and output configuration.
     * </p>
     * <p>
     * Managed Service for Apache Flink updates the <code>ApplicationVersionId</code> each time you update your
     * application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws CodeValidationException
     *         The user-provided application code (query) is not valid. This can be a simple syntax error.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws LimitExceededException
     *         The number of allowed resources has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws CodeValidationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException,
            ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException,
            LimitExceededException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Managed Service for Apache Flink application. Using this operation, you can update
     * application code, input configuration, and output configuration.
     * </p>
     * <p>
     * Managed Service for Apache Flink updates the <code>ApplicationVersionId</code> each time you update your
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws CodeValidationException
     *         The user-provided application code (query) is not valid. This can be a simple syntax error.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws InvalidRequestException
     *         The request JSON is not valid for the operation.
     * @throws InvalidApplicationConfigurationException
     *         The user-provided application configuration is not valid.
     * @throws LimitExceededException
     *         The number of allowed resources has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws CodeValidationException, ResourceNotFoundException, ResourceInUseException, InvalidArgumentException,
            ConcurrentModificationException, InvalidRequestException, InvalidApplicationConfigurationException,
            LimitExceededException, AwsServiceException, SdkClientException, KinesisAnalyticsV2Exception {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the maintenance configuration of the Managed Service for Apache Flink application.
     * </p>
     * <p>
     * You can invoke this operation on an application that is in one of the two following states: <code>READY</code> or
     * <code>RUNNING</code>. If you invoke it when the application is in a state other than these two states, it throws
     * a <code>ResourceInUseException</code>. The service makes use of the updated configuration the next time it
     * schedules maintenance for the application. If you invoke this operation after the service schedules maintenance,
     * the service will apply the configuration update the next time it schedules maintenance for the application. This
     * means that you might not see the maintenance configuration update applied to the maintenance process that follows
     * a successful invocation of this operation, but to the following maintenance process instead.
     * </p>
     * <p>
     * To see the current maintenance configuration of your application, invoke the <a>DescribeApplication</a>
     * operation.
     * </p>
     * <p>
     * For information about application maintenance, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html">Managed Service for Apache Flink
     * for Apache Flink Maintenance</a>.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note>
     *
     * @param updateApplicationMaintenanceConfigurationRequest
     * @return Result of the UpdateApplicationMaintenanceConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.UpdateApplicationMaintenanceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplicationMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationMaintenanceConfigurationResponse updateApplicationMaintenanceConfiguration(
            UpdateApplicationMaintenanceConfigurationRequest updateApplicationMaintenanceConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the maintenance configuration of the Managed Service for Apache Flink application.
     * </p>
     * <p>
     * You can invoke this operation on an application that is in one of the two following states: <code>READY</code> or
     * <code>RUNNING</code>. If you invoke it when the application is in a state other than these two states, it throws
     * a <code>ResourceInUseException</code>. The service makes use of the updated configuration the next time it
     * schedules maintenance for the application. If you invoke this operation after the service schedules maintenance,
     * the service will apply the configuration update the next time it schedules maintenance for the application. This
     * means that you might not see the maintenance configuration update applied to the maintenance process that follows
     * a successful invocation of this operation, but to the following maintenance process instead.
     * </p>
     * <p>
     * To see the current maintenance configuration of your application, invoke the <a>DescribeApplication</a>
     * operation.
     * </p>
     * <p>
     * For information about application maintenance, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/java/maintenance.html">Managed Service for Apache Flink
     * for Apache Flink Maintenance</a>.
     * </p>
     * <note>
     * <p>
     * This operation is supported only for Managed Service for Apache Flink.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateApplicationMaintenanceConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateApplicationMaintenanceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateApplicationMaintenanceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateApplicationMaintenanceConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         Specified application can't be found.
     * @throws ResourceInUseException
     *         The application is not available for this operation.
     * @throws InvalidArgumentException
     *         The specified input parameter value is not valid.
     * @throws ConcurrentModificationException
     *         Exception thrown as a result of concurrent modifications to an application. This error can be the result
     *         of attempting to modify an application without using the current application ID.
     * @throws UnsupportedOperationException
     *         The request was rejected because a specified parameter is not supported or a specified resource is not
     *         valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisAnalyticsV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisAnalyticsV2Client.UpdateApplicationMaintenanceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/UpdateApplicationMaintenanceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationMaintenanceConfigurationResponse updateApplicationMaintenanceConfiguration(
            Consumer<UpdateApplicationMaintenanceConfigurationRequest.Builder> updateApplicationMaintenanceConfigurationRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, ConcurrentModificationException,
            software.amazon.awssdk.services.kinesisanalyticsv2.model.UnsupportedOperationException, AwsServiceException,
            SdkClientException, KinesisAnalyticsV2Exception {
        return updateApplicationMaintenanceConfiguration(UpdateApplicationMaintenanceConfigurationRequest.builder()
                .applyMutation(updateApplicationMaintenanceConfigurationRequest).build());
    }

    /**
     * Create a {@link KinesisAnalyticsV2Client} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KinesisAnalyticsV2Client create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KinesisAnalyticsV2Client}.
     */
    static KinesisAnalyticsV2ClientBuilder builder() {
        return new DefaultKinesisAnalyticsV2ClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default KinesisAnalyticsV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
