/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnapshotDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnapshotDetails> {
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotName").getter(SnapshotDetails.getter(SnapshotDetails::snapshotName)).setter(SnapshotDetails.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotName").build()}).build();
    private static final SdkField<String> SNAPSHOT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotStatus").getter(SnapshotDetails.getter(SnapshotDetails::snapshotStatusAsString)).setter(SnapshotDetails.setter(Builder::snapshotStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotStatus").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(SnapshotDetails.getter(SnapshotDetails::applicationVersionId)).setter(SnapshotDetails.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<Instant> SNAPSHOT_CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SnapshotCreationTimestamp").getter(SnapshotDetails.getter(SnapshotDetails::snapshotCreationTimestamp)).setter(SnapshotDetails.setter(Builder::snapshotCreationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreationTimestamp").build()}).build();
    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeEnvironment").getter(SnapshotDetails.getter(SnapshotDetails::runtimeEnvironmentAsString)).setter(SnapshotDetails.setter(Builder::runtimeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_NAME_FIELD, SNAPSHOT_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, SNAPSHOT_CREATION_TIMESTAMP_FIELD, RUNTIME_ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SnapshotDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String snapshotName;
    private final String snapshotStatus;
    private final Long applicationVersionId;
    private final Instant snapshotCreationTimestamp;
    private final String runtimeEnvironment;

    private SnapshotDetails(BuilderImpl builder) {
        this.snapshotName = builder.snapshotName;
        this.snapshotStatus = builder.snapshotStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.snapshotCreationTimestamp = builder.snapshotCreationTimestamp;
        this.runtimeEnvironment = builder.runtimeEnvironment;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final SnapshotStatus snapshotStatus() {
        return SnapshotStatus.fromValue(this.snapshotStatus);
    }

    public final String snapshotStatusAsString() {
        return this.snapshotStatus;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final Instant snapshotCreationTimestamp() {
        return this.snapshotCreationTimestamp;
    }

    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(this.runtimeEnvironment);
    }

    public final String runtimeEnvironmentAsString() {
        return this.runtimeEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironmentAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotDetails)) {
            return false;
        }
        SnapshotDetails other = (SnapshotDetails)obj;
        return Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.snapshotStatusAsString(), other.snapshotStatusAsString()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.snapshotCreationTimestamp(), other.snapshotCreationTimestamp()) && Objects.equals(this.runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SnapshotDetails").add("SnapshotName", (Object)this.snapshotName()).add("SnapshotStatus", (Object)this.snapshotStatusAsString()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("SnapshotCreationTimestamp", (Object)this.snapshotCreationTimestamp()).add("RuntimeEnvironment", (Object)this.runtimeEnvironmentAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "SnapshotStatus": {
                return Optional.ofNullable(clazz.cast(this.snapshotStatusAsString()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "SnapshotCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreationTimestamp()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SnapshotName", SNAPSHOT_NAME_FIELD);
        map.put("SnapshotStatus", SNAPSHOT_STATUS_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        map.put("SnapshotCreationTimestamp", SNAPSHOT_CREATION_TIMESTAMP_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotDetails, T> g) {
        return obj -> g.apply((SnapshotDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotName;
        private String snapshotStatus;
        private Long applicationVersionId;
        private Instant snapshotCreationTimestamp;
        private String runtimeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotDetails model) {
            this.snapshotName(model.snapshotName);
            this.snapshotStatus(model.snapshotStatus);
            this.applicationVersionId(model.applicationVersionId);
            this.snapshotCreationTimestamp(model.snapshotCreationTimestamp);
            this.runtimeEnvironment(model.runtimeEnvironment);
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSnapshotStatus() {
            return this.snapshotStatus;
        }

        public final void setSnapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
        }

        @Override
        public final Builder snapshotStatus(String snapshotStatus) {
            this.snapshotStatus = snapshotStatus;
            return this;
        }

        @Override
        public final Builder snapshotStatus(SnapshotStatus snapshotStatus) {
            this.snapshotStatus(snapshotStatus == null ? null : snapshotStatus.toString());
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final Instant getSnapshotCreationTimestamp() {
            return this.snapshotCreationTimestamp;
        }

        public final void setSnapshotCreationTimestamp(Instant snapshotCreationTimestamp) {
            this.snapshotCreationTimestamp = snapshotCreationTimestamp;
        }

        @Override
        public final Builder snapshotCreationTimestamp(Instant snapshotCreationTimestamp) {
            this.snapshotCreationTimestamp = snapshotCreationTimestamp;
            return this;
        }

        public final String getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public SnapshotDetails build() {
            return new SnapshotDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnapshotDetails> {
        public Builder snapshotName(String var1);

        public Builder snapshotStatus(String var1);

        public Builder snapshotStatus(SnapshotStatus var1);

        public Builder applicationVersionId(Long var1);

        public Builder snapshotCreationTimestamp(Instant var1);

        public Builder runtimeEnvironment(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);
    }
}

