/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ContentBaseLocationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ContentBaseLocationDescription> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARN").getter(S3ContentBaseLocationDescription.getter(S3ContentBaseLocationDescription::bucketARN)).setter(S3ContentBaseLocationDescription.setter(Builder::bucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()}).build();
    private static final SdkField<String> BASE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BasePath").getter(S3ContentBaseLocationDescription.getter(S3ContentBaseLocationDescription::basePath)).setter(S3ContentBaseLocationDescription.setter(Builder::basePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, BASE_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ContentBaseLocationDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketARN;
    private final String basePath;

    private S3ContentBaseLocationDescription(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.basePath = builder.basePath;
    }

    public final String bucketARN() {
        return this.bucketARN;
    }

    public final String basePath() {
        return this.basePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.basePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentBaseLocationDescription)) {
            return false;
        }
        S3ContentBaseLocationDescription other = (S3ContentBaseLocationDescription)obj;
        return Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.basePath(), other.basePath());
    }

    public final String toString() {
        return ToString.builder((String)"S3ContentBaseLocationDescription").add("BucketARN", (Object)this.bucketARN()).add("BasePath", (Object)this.basePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "BasePath": {
                return Optional.ofNullable(clazz.cast(this.basePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BucketARN", BUCKET_ARN_FIELD);
        map.put("BasePath", BASE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ContentBaseLocationDescription, T> g) {
        return obj -> g.apply((S3ContentBaseLocationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARN;
        private String basePath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentBaseLocationDescription model) {
            this.bucketARN(model.bucketARN);
            this.basePath(model.basePath);
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final String getBasePath() {
            return this.basePath;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public S3ContentBaseLocationDescription build() {
            return new S3ContentBaseLocationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ContentBaseLocationDescription> {
        public Builder bucketARN(String var1);

        public Builder basePath(String var1);
    }
}

