/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationDetail;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, UpdateApplicationResponse> {
    private static final SdkField<ApplicationDetail> APPLICATION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationDetail").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::applicationDetail)).setter(UpdateApplicationResponse.setter(Builder::applicationDetail)).constructor(ApplicationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDetail").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(UpdateApplicationResponse.getter(UpdateApplicationResponse::operationId)).setter(UpdateApplicationResponse.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_DETAIL_FIELD, OPERATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationResponse.memberNameToFieldInitializer();
    private final ApplicationDetail applicationDetail;
    private final String operationId;

    private UpdateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationDetail = builder.applicationDetail;
        this.operationId = builder.operationId;
    }

    public final ApplicationDetail applicationDetail() {
        return this.applicationDetail;
    }

    public final String operationId() {
        return this.operationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationResponse)) {
            return false;
        }
        UpdateApplicationResponse other = (UpdateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationDetail(), other.applicationDetail()) && Objects.equals(this.operationId(), other.operationId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationResponse").add("ApplicationDetail", (Object)this.applicationDetail()).add("OperationId", (Object)this.operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationDetail": {
                return Optional.ofNullable(clazz.cast(this.applicationDetail()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationDetail", APPLICATION_DETAIL_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationResponse, T> g) {
        return obj -> g.apply((UpdateApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private ApplicationDetail applicationDetail;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationResponse model) {
            super(model);
            this.applicationDetail(model.applicationDetail);
            this.operationId(model.operationId);
        }

        public final ApplicationDetail.Builder getApplicationDetail() {
            return this.applicationDetail != null ? this.applicationDetail.toBuilder() : null;
        }

        public final void setApplicationDetail(ApplicationDetail.BuilderImpl applicationDetail) {
            this.applicationDetail = applicationDetail != null ? applicationDetail.build() : null;
        }

        @Override
        public final Builder applicationDetail(ApplicationDetail applicationDetail) {
            this.applicationDetail = applicationDetail;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public UpdateApplicationResponse build() {
            return new UpdateApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationResponse> {
        public Builder applicationDetail(ApplicationDetail var1);

        default public Builder applicationDetail(Consumer<ApplicationDetail.Builder> applicationDetail) {
            return this.applicationDetail((ApplicationDetail)((ApplicationDetail.Builder)ApplicationDetail.builder().applyMutation(applicationDetail)).build());
        }

        public Builder operationId(String var1);
    }
}

