/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsResponse;

public class ListApplicationOperationsPublisher
implements SdkPublisher<ListApplicationOperationsResponse> {
    private final KinesisAnalyticsV2AsyncClient client;
    private final ListApplicationOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationOperationsPublisher(KinesisAnalyticsV2AsyncClient client, ListApplicationOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationOperationsPublisher(KinesisAnalyticsV2AsyncClient client, ListApplicationOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationOperationInfo> applicationOperationInfoList() {
        Function<ListApplicationOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationOperationInfoList() != null) {
                return response.applicationOperationInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationOperationsResponseFetcher
    implements AsyncPageFetcher<ListApplicationOperationsResponse> {
        private ListApplicationOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationOperationsResponse> nextPage(ListApplicationOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationOperationsPublisher.this.client.listApplicationOperations(ListApplicationOperationsPublisher.this.firstRequest);
            }
            return ListApplicationOperationsPublisher.this.client.listApplicationOperations((ListApplicationOperationsRequest)((Object)ListApplicationOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

