/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationReferenceDataSourceResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, AddApplicationReferenceDataSourceResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(AddApplicationReferenceDataSourceResponse.getter(AddApplicationReferenceDataSourceResponse::applicationARN)).setter(AddApplicationReferenceDataSourceResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(AddApplicationReferenceDataSourceResponse.getter(AddApplicationReferenceDataSourceResponse::applicationVersionId)).setter(AddApplicationReferenceDataSourceResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<List<ReferenceDataSourceDescription>> REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceDataSourceDescriptions").getter(AddApplicationReferenceDataSourceResponse.getter(AddApplicationReferenceDataSourceResponse::referenceDataSourceDescriptions)).setter(AddApplicationReferenceDataSourceResponse.setter(Builder::referenceDataSourceDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceDataSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD, REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddApplicationReferenceDataSourceResponse.memberNameToFieldInitializer();
    private final String applicationARN;
    private final Long applicationVersionId;
    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;

    private AddApplicationReferenceDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final boolean hasReferenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions != null && !(this.referenceDataSourceDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceDataSourceDescriptions() ? this.referenceDataSourceDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationReferenceDataSourceResponse)) {
            return false;
        }
        AddApplicationReferenceDataSourceResponse other = (AddApplicationReferenceDataSourceResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && this.hasReferenceDataSourceDescriptions() == other.hasReferenceDataSourceDescriptions() && Objects.equals(this.referenceDataSourceDescriptions(), other.referenceDataSourceDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"AddApplicationReferenceDataSourceResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("ReferenceDataSourceDescriptions", this.hasReferenceDataSourceDescriptions() ? this.referenceDataSourceDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "ReferenceDataSourceDescriptions": {
                return Optional.ofNullable(clazz.cast(this.referenceDataSourceDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        map.put("ReferenceDataSourceDescriptions", REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationReferenceDataSourceResponse, T> g) {
        return obj -> g.apply((AddApplicationReferenceDataSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;
        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationReferenceDataSourceResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
            this.referenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final List<ReferenceDataSourceDescription.Builder> getReferenceDataSourceDescriptions() {
            List<ReferenceDataSourceDescription.Builder> result = ReferenceDataSourceDescriptionsCopier.copyToBuilder(this.referenceDataSourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription.BuilderImpl> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copyFromBuilder(referenceDataSourceDescriptions);
        }

        @Override
        public final Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Arrays.asList(referenceDataSourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Stream.of(referenceDataSourceDescriptions).map(c -> (ReferenceDataSourceDescription)((ReferenceDataSourceDescription.Builder)ReferenceDataSourceDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddApplicationReferenceDataSourceResponse build() {
            return new AddApplicationReferenceDataSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationReferenceDataSourceResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);

        public Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> var1);

        public Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... var1);

        public Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... var1);
    }
}

