/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2Client;
import software.amazon.awssdk.services.kinesisanalyticsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationOperationInfo;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationOperationsResponse;

public class ListApplicationOperationsIterable
implements SdkIterable<ListApplicationOperationsResponse> {
    private final KinesisAnalyticsV2Client client;
    private final ListApplicationOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationOperationsIterable(KinesisAnalyticsV2Client client, ListApplicationOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationOperationsResponseFetcher();
    }

    public Iterator<ListApplicationOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationOperationInfo> applicationOperationInfoList() {
        Function<ListApplicationOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationOperationInfoList() != null) {
                return response.applicationOperationInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationOperationsResponseFetcher
    implements SyncPageFetcher<ListApplicationOperationsResponse> {
        private ListApplicationOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationOperationsResponse nextPage(ListApplicationOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationOperationsIterable.this.client.listApplicationOperations(ListApplicationOperationsIterable.this.firstRequest);
            }
            return ListApplicationOperationsIterable.this.client.listApplicationOperations((ListApplicationOperationsRequest)((Object)ListApplicationOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

