/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationStatus;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(ApplicationSummary.getter(ApplicationSummary::applicationName)).setter(ApplicationSummary.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(ApplicationSummary.getter(ApplicationSummary::applicationARN)).setter(ApplicationSummary.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationStatus").getter(ApplicationSummary.getter(ApplicationSummary::applicationStatusAsString)).setter(ApplicationSummary.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(ApplicationSummary.getter(ApplicationSummary::applicationVersionId)).setter(ApplicationSummary.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<String> RUNTIME_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeEnvironment").getter(ApplicationSummary.getter(ApplicationSummary::runtimeEnvironmentAsString)).setter(ApplicationSummary.setter(Builder::runtimeEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironment").build()}).build();
    private static final SdkField<String> APPLICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationMode").getter(ApplicationSummary.getter(ApplicationSummary::applicationModeAsString)).setter(ApplicationSummary.setter(Builder::applicationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, APPLICATION_ARN_FIELD, APPLICATION_STATUS_FIELD, APPLICATION_VERSION_ID_FIELD, RUNTIME_ENVIRONMENT_FIELD, APPLICATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String applicationARN;
    private final String applicationStatus;
    private final Long applicationVersionId;
    private final String runtimeEnvironment;
    private final String applicationMode;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
        this.applicationVersionId = builder.applicationVersionId;
        this.runtimeEnvironment = builder.runtimeEnvironment;
        this.applicationMode = builder.applicationMode;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public final String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final RuntimeEnvironment runtimeEnvironment() {
        return RuntimeEnvironment.fromValue(this.runtimeEnvironment);
    }

    public final String runtimeEnvironmentAsString() {
        return this.runtimeEnvironment;
    }

    public final ApplicationMode applicationMode() {
        return ApplicationMode.fromValue(this.applicationMode);
    }

    public final String applicationModeAsString() {
        return this.applicationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeEnvironmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.runtimeEnvironmentAsString(), other.runtimeEnvironmentAsString()) && Objects.equals(this.applicationModeAsString(), other.applicationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationName", (Object)this.applicationName()).add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("RuntimeEnvironment", (Object)this.runtimeEnvironmentAsString()).add("ApplicationMode", (Object)this.applicationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "RuntimeEnvironment": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentAsString()));
            }
            case "ApplicationMode": {
                return Optional.ofNullable(clazz.cast(this.applicationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationStatus", APPLICATION_STATUS_FIELD);
        map.put("ApplicationVersionId", APPLICATION_VERSION_ID_FIELD);
        map.put("RuntimeEnvironment", RUNTIME_ENVIRONMENT_FIELD);
        map.put("ApplicationMode", APPLICATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationARN;
        private String applicationStatus;
        private Long applicationVersionId;
        private String runtimeEnvironment;
        private String applicationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationName(model.applicationName);
            this.applicationARN(model.applicationARN);
            this.applicationStatus(model.applicationStatus);
            this.applicationVersionId(model.applicationVersionId);
            this.runtimeEnvironment(model.runtimeEnvironment);
            this.applicationMode(model.applicationMode);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final String getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        public final void setRuntimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
        }

        @Override
        public final Builder runtimeEnvironment(String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        @Override
        public final Builder runtimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
            this.runtimeEnvironment(runtimeEnvironment == null ? null : runtimeEnvironment.toString());
            return this;
        }

        public final String getApplicationMode() {
            return this.applicationMode;
        }

        public final void setApplicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
        }

        @Override
        public final Builder applicationMode(String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        @Override
        public final Builder applicationMode(ApplicationMode applicationMode) {
            this.applicationMode(applicationMode == null ? null : applicationMode.toString());
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationName(String var1);

        public Builder applicationARN(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder applicationVersionId(Long var1);

        public Builder runtimeEnvironment(String var1);

        public Builder runtimeEnvironment(RuntimeEnvironment var1);

        public Builder applicationMode(String var1);

        public Builder applicationMode(ApplicationMode var1);
    }
}

