/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentProperties> {
    private static final SdkField<List<PropertyGroup>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertyGroups").getter(EnvironmentProperties.getter(EnvironmentProperties::propertyGroups)).setter(EnvironmentProperties.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PropertyGroups", PROPERTY_GROUPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<PropertyGroup> propertyGroups;

    private EnvironmentProperties(BuilderImpl builder) {
        this.propertyGroups = builder.propertyGroups;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructList);
    }

    public final List<PropertyGroup> propertyGroups() {
        return this.propertyGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentProperties)) {
            return false;
        }
        EnvironmentProperties other = (EnvironmentProperties)obj;
        return this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentProperties").add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentProperties, T> g) {
        return obj -> g.apply((EnvironmentProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PropertyGroup> propertyGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentProperties model) {
            this.propertyGroups(model.propertyGroups);
        }

        public final List<PropertyGroup.Builder> getPropertyGroups() {
            List<PropertyGroup.Builder> result = PropertyGroupsCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Collection<PropertyGroup.BuilderImpl> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Collection<PropertyGroup> propertyGroups) {
            this.propertyGroups = PropertyGroupsCopier.copy(propertyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(PropertyGroup ... propertyGroups) {
            this.propertyGroups(Arrays.asList(propertyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyGroups(Consumer<PropertyGroup.Builder> ... propertyGroups) {
            this.propertyGroups(Stream.of(propertyGroups).map(c -> (PropertyGroup)((PropertyGroup.Builder)PropertyGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EnvironmentProperties build() {
            return new EnvironmentProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentProperties> {
        public Builder propertyGroups(Collection<PropertyGroup> var1);

        public Builder propertyGroups(PropertyGroup ... var1);

        public Builder propertyGroups(Consumer<PropertyGroup.Builder> ... var1);
    }
}

