/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeContentDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeContentDescription> {
    private static final SdkField<String> TEXT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextContent").getter(CodeContentDescription.getter(CodeContentDescription::textContent)).setter(CodeContentDescription.setter(Builder::textContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextContent").build()}).build();
    private static final SdkField<String> CODE_MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeMD5").getter(CodeContentDescription.getter(CodeContentDescription::codeMD5)).setter(CodeContentDescription.setter(Builder::codeMD5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeMD5").build()}).build();
    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeSize").getter(CodeContentDescription.getter(CodeContentDescription::codeSize)).setter(CodeContentDescription.setter(Builder::codeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()}).build();
    private static final SdkField<S3ApplicationCodeLocationDescription> S3_APPLICATION_CODE_LOCATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3ApplicationCodeLocationDescription").getter(CodeContentDescription.getter(CodeContentDescription::s3ApplicationCodeLocationDescription)).setter(CodeContentDescription.setter(Builder::s3ApplicationCodeLocationDescription)).constructor(S3ApplicationCodeLocationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ApplicationCodeLocationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_CONTENT_FIELD, CODE_MD5_FIELD, CODE_SIZE_FIELD, S3_APPLICATION_CODE_LOCATION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TextContent", TEXT_CONTENT_FIELD);
            this.put("CodeMD5", CODE_MD5_FIELD);
            this.put("CodeSize", CODE_SIZE_FIELD);
            this.put("S3ApplicationCodeLocationDescription", S3_APPLICATION_CODE_LOCATION_DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String textContent;
    private final String codeMD5;
    private final Long codeSize;
    private final S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription;

    private CodeContentDescription(BuilderImpl builder) {
        this.textContent = builder.textContent;
        this.codeMD5 = builder.codeMD5;
        this.codeSize = builder.codeSize;
        this.s3ApplicationCodeLocationDescription = builder.s3ApplicationCodeLocationDescription;
    }

    public final String textContent() {
        return this.textContent;
    }

    public final String codeMD5() {
        return this.codeMD5;
    }

    public final Long codeSize() {
        return this.codeSize;
    }

    public final S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription() {
        return this.s3ApplicationCodeLocationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ApplicationCodeLocationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeContentDescription)) {
            return false;
        }
        CodeContentDescription other = (CodeContentDescription)obj;
        return Objects.equals(this.textContent(), other.textContent()) && Objects.equals(this.codeMD5(), other.codeMD5()) && Objects.equals(this.codeSize(), other.codeSize()) && Objects.equals(this.s3ApplicationCodeLocationDescription(), other.s3ApplicationCodeLocationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"CodeContentDescription").add("TextContent", (Object)this.textContent()).add("CodeMD5", (Object)this.codeMD5()).add("CodeSize", (Object)this.codeSize()).add("S3ApplicationCodeLocationDescription", (Object)this.s3ApplicationCodeLocationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TextContent": {
                return Optional.ofNullable(clazz.cast(this.textContent()));
            }
            case "CodeMD5": {
                return Optional.ofNullable(clazz.cast(this.codeMD5()));
            }
            case "CodeSize": {
                return Optional.ofNullable(clazz.cast(this.codeSize()));
            }
            case "S3ApplicationCodeLocationDescription": {
                return Optional.ofNullable(clazz.cast(this.s3ApplicationCodeLocationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CodeContentDescription, T> g) {
        return obj -> g.apply((CodeContentDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String textContent;
        private String codeMD5;
        private Long codeSize;
        private S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeContentDescription model) {
            this.textContent(model.textContent);
            this.codeMD5(model.codeMD5);
            this.codeSize(model.codeSize);
            this.s3ApplicationCodeLocationDescription(model.s3ApplicationCodeLocationDescription);
        }

        public final String getTextContent() {
            return this.textContent;
        }

        public final void setTextContent(String textContent) {
            this.textContent = textContent;
        }

        @Override
        public final Builder textContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public final String getCodeMD5() {
            return this.codeMD5;
        }

        public final void setCodeMD5(String codeMD5) {
            this.codeMD5 = codeMD5;
        }

        @Override
        public final Builder codeMD5(String codeMD5) {
            this.codeMD5 = codeMD5;
            return this;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final S3ApplicationCodeLocationDescription.Builder getS3ApplicationCodeLocationDescription() {
            return this.s3ApplicationCodeLocationDescription != null ? this.s3ApplicationCodeLocationDescription.toBuilder() : null;
        }

        public final void setS3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription.BuilderImpl s3ApplicationCodeLocationDescription) {
            this.s3ApplicationCodeLocationDescription = s3ApplicationCodeLocationDescription != null ? s3ApplicationCodeLocationDescription.build() : null;
        }

        @Override
        public final Builder s3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription s3ApplicationCodeLocationDescription) {
            this.s3ApplicationCodeLocationDescription = s3ApplicationCodeLocationDescription;
            return this;
        }

        public CodeContentDescription build() {
            return new CodeContentDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeContentDescription> {
        public Builder textContent(String var1);

        public Builder codeMD5(String var1);

        public Builder codeSize(Long var1);

        public Builder s3ApplicationCodeLocationDescription(S3ApplicationCodeLocationDescription var1);

        default public Builder s3ApplicationCodeLocationDescription(Consumer<S3ApplicationCodeLocationDescription.Builder> s3ApplicationCodeLocationDescription) {
            return this.s3ApplicationCodeLocationDescription((S3ApplicationCodeLocationDescription)((S3ApplicationCodeLocationDescription.Builder)S3ApplicationCodeLocationDescription.builder().applyMutation(s3ApplicationCodeLocationDescription)).build());
        }
    }
}

