/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlinkApplicationConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlinkApplicationConfigurationUpdate> {
    private static final SdkField<CheckpointConfigurationUpdate> CHECKPOINT_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CheckpointConfigurationUpdate").getter(FlinkApplicationConfigurationUpdate.getter(FlinkApplicationConfigurationUpdate::checkpointConfigurationUpdate)).setter(FlinkApplicationConfigurationUpdate.setter(Builder::checkpointConfigurationUpdate)).constructor(CheckpointConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfigurationUpdate").build()}).build();
    private static final SdkField<MonitoringConfigurationUpdate> MONITORING_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringConfigurationUpdate").getter(FlinkApplicationConfigurationUpdate.getter(FlinkApplicationConfigurationUpdate::monitoringConfigurationUpdate)).setter(FlinkApplicationConfigurationUpdate.setter(Builder::monitoringConfigurationUpdate)).constructor(MonitoringConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfigurationUpdate").build()}).build();
    private static final SdkField<ParallelismConfigurationUpdate> PARALLELISM_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParallelismConfigurationUpdate").getter(FlinkApplicationConfigurationUpdate.getter(FlinkApplicationConfigurationUpdate::parallelismConfigurationUpdate)).setter(FlinkApplicationConfigurationUpdate.setter(Builder::parallelismConfigurationUpdate)).constructor(ParallelismConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismConfigurationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKPOINT_CONFIGURATION_UPDATE_FIELD, MONITORING_CONFIGURATION_UPDATE_FIELD, PARALLELISM_CONFIGURATION_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CheckpointConfigurationUpdate", CHECKPOINT_CONFIGURATION_UPDATE_FIELD);
            this.put("MonitoringConfigurationUpdate", MONITORING_CONFIGURATION_UPDATE_FIELD);
            this.put("ParallelismConfigurationUpdate", PARALLELISM_CONFIGURATION_UPDATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final CheckpointConfigurationUpdate checkpointConfigurationUpdate;
    private final MonitoringConfigurationUpdate monitoringConfigurationUpdate;
    private final ParallelismConfigurationUpdate parallelismConfigurationUpdate;

    private FlinkApplicationConfigurationUpdate(BuilderImpl builder) {
        this.checkpointConfigurationUpdate = builder.checkpointConfigurationUpdate;
        this.monitoringConfigurationUpdate = builder.monitoringConfigurationUpdate;
        this.parallelismConfigurationUpdate = builder.parallelismConfigurationUpdate;
    }

    public final CheckpointConfigurationUpdate checkpointConfigurationUpdate() {
        return this.checkpointConfigurationUpdate;
    }

    public final MonitoringConfigurationUpdate monitoringConfigurationUpdate() {
        return this.monitoringConfigurationUpdate;
    }

    public final ParallelismConfigurationUpdate parallelismConfigurationUpdate() {
        return this.parallelismConfigurationUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismConfigurationUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlinkApplicationConfigurationUpdate)) {
            return false;
        }
        FlinkApplicationConfigurationUpdate other = (FlinkApplicationConfigurationUpdate)obj;
        return Objects.equals(this.checkpointConfigurationUpdate(), other.checkpointConfigurationUpdate()) && Objects.equals(this.monitoringConfigurationUpdate(), other.monitoringConfigurationUpdate()) && Objects.equals(this.parallelismConfigurationUpdate(), other.parallelismConfigurationUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"FlinkApplicationConfigurationUpdate").add("CheckpointConfigurationUpdate", (Object)this.checkpointConfigurationUpdate()).add("MonitoringConfigurationUpdate", (Object)this.monitoringConfigurationUpdate()).add("ParallelismConfigurationUpdate", (Object)this.parallelismConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CheckpointConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfigurationUpdate()));
            }
            case "MonitoringConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfigurationUpdate()));
            }
            case "ParallelismConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.parallelismConfigurationUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FlinkApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((FlinkApplicationConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CheckpointConfigurationUpdate checkpointConfigurationUpdate;
        private MonitoringConfigurationUpdate monitoringConfigurationUpdate;
        private ParallelismConfigurationUpdate parallelismConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(FlinkApplicationConfigurationUpdate model) {
            this.checkpointConfigurationUpdate(model.checkpointConfigurationUpdate);
            this.monitoringConfigurationUpdate(model.monitoringConfigurationUpdate);
            this.parallelismConfigurationUpdate(model.parallelismConfigurationUpdate);
        }

        public final CheckpointConfigurationUpdate.Builder getCheckpointConfigurationUpdate() {
            return this.checkpointConfigurationUpdate != null ? this.checkpointConfigurationUpdate.toBuilder() : null;
        }

        public final void setCheckpointConfigurationUpdate(CheckpointConfigurationUpdate.BuilderImpl checkpointConfigurationUpdate) {
            this.checkpointConfigurationUpdate = checkpointConfigurationUpdate != null ? checkpointConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder checkpointConfigurationUpdate(CheckpointConfigurationUpdate checkpointConfigurationUpdate) {
            this.checkpointConfigurationUpdate = checkpointConfigurationUpdate;
            return this;
        }

        public final MonitoringConfigurationUpdate.Builder getMonitoringConfigurationUpdate() {
            return this.monitoringConfigurationUpdate != null ? this.monitoringConfigurationUpdate.toBuilder() : null;
        }

        public final void setMonitoringConfigurationUpdate(MonitoringConfigurationUpdate.BuilderImpl monitoringConfigurationUpdate) {
            this.monitoringConfigurationUpdate = monitoringConfigurationUpdate != null ? monitoringConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder monitoringConfigurationUpdate(MonitoringConfigurationUpdate monitoringConfigurationUpdate) {
            this.monitoringConfigurationUpdate = monitoringConfigurationUpdate;
            return this;
        }

        public final ParallelismConfigurationUpdate.Builder getParallelismConfigurationUpdate() {
            return this.parallelismConfigurationUpdate != null ? this.parallelismConfigurationUpdate.toBuilder() : null;
        }

        public final void setParallelismConfigurationUpdate(ParallelismConfigurationUpdate.BuilderImpl parallelismConfigurationUpdate) {
            this.parallelismConfigurationUpdate = parallelismConfigurationUpdate != null ? parallelismConfigurationUpdate.build() : null;
        }

        @Override
        public final Builder parallelismConfigurationUpdate(ParallelismConfigurationUpdate parallelismConfigurationUpdate) {
            this.parallelismConfigurationUpdate = parallelismConfigurationUpdate;
            return this;
        }

        public FlinkApplicationConfigurationUpdate build() {
            return new FlinkApplicationConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlinkApplicationConfigurationUpdate> {
        public Builder checkpointConfigurationUpdate(CheckpointConfigurationUpdate var1);

        default public Builder checkpointConfigurationUpdate(Consumer<CheckpointConfigurationUpdate.Builder> checkpointConfigurationUpdate) {
            return this.checkpointConfigurationUpdate((CheckpointConfigurationUpdate)((CheckpointConfigurationUpdate.Builder)CheckpointConfigurationUpdate.builder().applyMutation(checkpointConfigurationUpdate)).build());
        }

        public Builder monitoringConfigurationUpdate(MonitoringConfigurationUpdate var1);

        default public Builder monitoringConfigurationUpdate(Consumer<MonitoringConfigurationUpdate.Builder> monitoringConfigurationUpdate) {
            return this.monitoringConfigurationUpdate((MonitoringConfigurationUpdate)((MonitoringConfigurationUpdate.Builder)MonitoringConfigurationUpdate.builder().applyMutation(monitoringConfigurationUpdate)).build());
        }

        public Builder parallelismConfigurationUpdate(ParallelismConfigurationUpdate var1);

        default public Builder parallelismConfigurationUpdate(Consumer<ParallelismConfigurationUpdate.Builder> parallelismConfigurationUpdate) {
            return this.parallelismConfigurationUpdate((ParallelismConfigurationUpdate)((ParallelismConfigurationUpdate.Builder)ParallelismConfigurationUpdate.builder().applyMutation(parallelismConfigurationUpdate)).build());
        }
    }
}

