/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactsConfigurationListCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.DeployAsApplicationConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ZeppelinApplicationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ZeppelinApplicationConfiguration> {
    private static final SdkField<ZeppelinMonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MonitoringConfiguration").getter(ZeppelinApplicationConfiguration.getter(ZeppelinApplicationConfiguration::monitoringConfiguration)).setter(ZeppelinApplicationConfiguration.setter(Builder::monitoringConfiguration)).constructor(ZeppelinMonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringConfiguration").build()}).build();
    private static final SdkField<CatalogConfiguration> CATALOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogConfiguration").getter(ZeppelinApplicationConfiguration.getter(ZeppelinApplicationConfiguration::catalogConfiguration)).setter(ZeppelinApplicationConfiguration.setter(Builder::catalogConfiguration)).constructor(CatalogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfiguration").build()}).build();
    private static final SdkField<DeployAsApplicationConfiguration> DEPLOY_AS_APPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeployAsApplicationConfiguration").getter(ZeppelinApplicationConfiguration.getter(ZeppelinApplicationConfiguration::deployAsApplicationConfiguration)).setter(ZeppelinApplicationConfiguration.setter(Builder::deployAsApplicationConfiguration)).constructor(DeployAsApplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployAsApplicationConfiguration").build()}).build();
    private static final SdkField<List<CustomArtifactConfiguration>> CUSTOM_ARTIFACTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomArtifactsConfiguration").getter(ZeppelinApplicationConfiguration.getter(ZeppelinApplicationConfiguration::customArtifactsConfiguration)).setter(ZeppelinApplicationConfiguration.setter(Builder::customArtifactsConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomArtifactsConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomArtifactConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_CONFIGURATION_FIELD, CATALOG_CONFIGURATION_FIELD, DEPLOY_AS_APPLICATION_CONFIGURATION_FIELD, CUSTOM_ARTIFACTS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MonitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
            this.put("CatalogConfiguration", CATALOG_CONFIGURATION_FIELD);
            this.put("DeployAsApplicationConfiguration", DEPLOY_AS_APPLICATION_CONFIGURATION_FIELD);
            this.put("CustomArtifactsConfiguration", CUSTOM_ARTIFACTS_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ZeppelinMonitoringConfiguration monitoringConfiguration;
    private final CatalogConfiguration catalogConfiguration;
    private final DeployAsApplicationConfiguration deployAsApplicationConfiguration;
    private final List<CustomArtifactConfiguration> customArtifactsConfiguration;

    private ZeppelinApplicationConfiguration(BuilderImpl builder) {
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.catalogConfiguration = builder.catalogConfiguration;
        this.deployAsApplicationConfiguration = builder.deployAsApplicationConfiguration;
        this.customArtifactsConfiguration = builder.customArtifactsConfiguration;
    }

    public final ZeppelinMonitoringConfiguration monitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public final CatalogConfiguration catalogConfiguration() {
        return this.catalogConfiguration;
    }

    public final DeployAsApplicationConfiguration deployAsApplicationConfiguration() {
        return this.deployAsApplicationConfiguration;
    }

    public final boolean hasCustomArtifactsConfiguration() {
        return this.customArtifactsConfiguration != null && !(this.customArtifactsConfiguration instanceof SdkAutoConstructList);
    }

    public final List<CustomArtifactConfiguration> customArtifactsConfiguration() {
        return this.customArtifactsConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployAsApplicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomArtifactsConfiguration() ? this.customArtifactsConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeppelinApplicationConfiguration)) {
            return false;
        }
        ZeppelinApplicationConfiguration other = (ZeppelinApplicationConfiguration)obj;
        return Objects.equals(this.monitoringConfiguration(), other.monitoringConfiguration()) && Objects.equals(this.catalogConfiguration(), other.catalogConfiguration()) && Objects.equals(this.deployAsApplicationConfiguration(), other.deployAsApplicationConfiguration()) && this.hasCustomArtifactsConfiguration() == other.hasCustomArtifactsConfiguration() && Objects.equals(this.customArtifactsConfiguration(), other.customArtifactsConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ZeppelinApplicationConfiguration").add("MonitoringConfiguration", (Object)this.monitoringConfiguration()).add("CatalogConfiguration", (Object)this.catalogConfiguration()).add("DeployAsApplicationConfiguration", (Object)this.deployAsApplicationConfiguration()).add("CustomArtifactsConfiguration", this.hasCustomArtifactsConfiguration() ? this.customArtifactsConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfiguration()));
            }
            case "CatalogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.catalogConfiguration()));
            }
            case "DeployAsApplicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deployAsApplicationConfiguration()));
            }
            case "CustomArtifactsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customArtifactsConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ZeppelinApplicationConfiguration, T> g) {
        return obj -> g.apply((ZeppelinApplicationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ZeppelinMonitoringConfiguration monitoringConfiguration;
        private CatalogConfiguration catalogConfiguration;
        private DeployAsApplicationConfiguration deployAsApplicationConfiguration;
        private List<CustomArtifactConfiguration> customArtifactsConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ZeppelinApplicationConfiguration model) {
            this.monitoringConfiguration(model.monitoringConfiguration);
            this.catalogConfiguration(model.catalogConfiguration);
            this.deployAsApplicationConfiguration(model.deployAsApplicationConfiguration);
            this.customArtifactsConfiguration(model.customArtifactsConfiguration);
        }

        public final ZeppelinMonitoringConfiguration.Builder getMonitoringConfiguration() {
            return this.monitoringConfiguration != null ? this.monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(ZeppelinMonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(ZeppelinMonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final CatalogConfiguration.Builder getCatalogConfiguration() {
            return this.catalogConfiguration != null ? this.catalogConfiguration.toBuilder() : null;
        }

        public final void setCatalogConfiguration(CatalogConfiguration.BuilderImpl catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration != null ? catalogConfiguration.build() : null;
        }

        @Override
        public final Builder catalogConfiguration(CatalogConfiguration catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration;
            return this;
        }

        public final DeployAsApplicationConfiguration.Builder getDeployAsApplicationConfiguration() {
            return this.deployAsApplicationConfiguration != null ? this.deployAsApplicationConfiguration.toBuilder() : null;
        }

        public final void setDeployAsApplicationConfiguration(DeployAsApplicationConfiguration.BuilderImpl deployAsApplicationConfiguration) {
            this.deployAsApplicationConfiguration = deployAsApplicationConfiguration != null ? deployAsApplicationConfiguration.build() : null;
        }

        @Override
        public final Builder deployAsApplicationConfiguration(DeployAsApplicationConfiguration deployAsApplicationConfiguration) {
            this.deployAsApplicationConfiguration = deployAsApplicationConfiguration;
            return this;
        }

        public final List<CustomArtifactConfiguration.Builder> getCustomArtifactsConfiguration() {
            List<CustomArtifactConfiguration.Builder> result = CustomArtifactsConfigurationListCopier.copyToBuilder(this.customArtifactsConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomArtifactsConfiguration(Collection<CustomArtifactConfiguration.BuilderImpl> customArtifactsConfiguration) {
            this.customArtifactsConfiguration = CustomArtifactsConfigurationListCopier.copyFromBuilder(customArtifactsConfiguration);
        }

        @Override
        public final Builder customArtifactsConfiguration(Collection<CustomArtifactConfiguration> customArtifactsConfiguration) {
            this.customArtifactsConfiguration = CustomArtifactsConfigurationListCopier.copy(customArtifactsConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfiguration(CustomArtifactConfiguration ... customArtifactsConfiguration) {
            this.customArtifactsConfiguration(Arrays.asList(customArtifactsConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customArtifactsConfiguration(Consumer<CustomArtifactConfiguration.Builder> ... customArtifactsConfiguration) {
            this.customArtifactsConfiguration(Stream.of(customArtifactsConfiguration).map(c -> (CustomArtifactConfiguration)((CustomArtifactConfiguration.Builder)CustomArtifactConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ZeppelinApplicationConfiguration build() {
            return new ZeppelinApplicationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ZeppelinApplicationConfiguration> {
        public Builder monitoringConfiguration(ZeppelinMonitoringConfiguration var1);

        default public Builder monitoringConfiguration(Consumer<ZeppelinMonitoringConfiguration.Builder> monitoringConfiguration) {
            return this.monitoringConfiguration((ZeppelinMonitoringConfiguration)((ZeppelinMonitoringConfiguration.Builder)ZeppelinMonitoringConfiguration.builder().applyMutation(monitoringConfiguration)).build());
        }

        public Builder catalogConfiguration(CatalogConfiguration var1);

        default public Builder catalogConfiguration(Consumer<CatalogConfiguration.Builder> catalogConfiguration) {
            return this.catalogConfiguration((CatalogConfiguration)((CatalogConfiguration.Builder)CatalogConfiguration.builder().applyMutation(catalogConfiguration)).build());
        }

        public Builder deployAsApplicationConfiguration(DeployAsApplicationConfiguration var1);

        default public Builder deployAsApplicationConfiguration(Consumer<DeployAsApplicationConfiguration.Builder> deployAsApplicationConfiguration) {
            return this.deployAsApplicationConfiguration((DeployAsApplicationConfiguration)((DeployAsApplicationConfiguration.Builder)DeployAsApplicationConfiguration.builder().applyMutation(deployAsApplicationConfiguration)).build());
        }

        public Builder customArtifactsConfiguration(Collection<CustomArtifactConfiguration> var1);

        public Builder customArtifactsConfiguration(CustomArtifactConfiguration ... var1);

        public Builder customArtifactsConfiguration(Consumer<CustomArtifactConfiguration.Builder> ... var1);
    }
}

