/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteApplicationCloudWatchLoggingOptionRequest
extends KinesisAnalyticsV2Request
implements ToCopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::applicationName)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CurrentApplicationVersionId").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::currentApplicationVersionId)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::currentApplicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGGING_OPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLoggingOptionId").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::cloudWatchLoggingOptionId)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::cloudWatchLoggingOptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionId").build()}).build();
    private static final SdkField<String> CONDITIONAL_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionalToken").getter(DeleteApplicationCloudWatchLoggingOptionRequest.getter(DeleteApplicationCloudWatchLoggingOptionRequest::conditionalToken)).setter(DeleteApplicationCloudWatchLoggingOptionRequest.setter(Builder::conditionalToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_APPLICATION_VERSION_ID_FIELD, CLOUD_WATCH_LOGGING_OPTION_ID_FIELD, CONDITIONAL_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationName", APPLICATION_NAME_FIELD);
            this.put("CurrentApplicationVersionId", CURRENT_APPLICATION_VERSION_ID_FIELD);
            this.put("CloudWatchLoggingOptionId", CLOUD_WATCH_LOGGING_OPTION_ID_FIELD);
            this.put("ConditionalToken", CONDITIONAL_TOKEN_FIELD);
        }
    });
    private final String applicationName;
    private final Long currentApplicationVersionId;
    private final String cloudWatchLoggingOptionId;
    private final String conditionalToken;

    private DeleteApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
        this.conditionalToken = builder.conditionalToken;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final Long currentApplicationVersionId() {
        return this.currentApplicationVersionId;
    }

    public final String cloudWatchLoggingOptionId() {
        return this.cloudWatchLoggingOptionId;
    }

    public final String conditionalToken() {
        return this.conditionalToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        DeleteApplicationCloudWatchLoggingOptionRequest other = (DeleteApplicationCloudWatchLoggingOptionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentApplicationVersionId(), other.currentApplicationVersionId()) && Objects.equals(this.cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId()) && Objects.equals(this.conditionalToken(), other.conditionalToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteApplicationCloudWatchLoggingOptionRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentApplicationVersionId", (Object)this.currentApplicationVersionId()).add("CloudWatchLoggingOptionId", (Object)this.cloudWatchLoggingOptionId()).add("ConditionalToken", (Object)this.conditionalToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "CurrentApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentApplicationVersionId()));
            }
            case "CloudWatchLoggingOptionId": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptionId()));
            }
            case "ConditionalToken": {
                return Optional.ofNullable(clazz.cast(this.conditionalToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationCloudWatchLoggingOptionRequest, T> g) {
        return obj -> g.apply((DeleteApplicationCloudWatchLoggingOptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Request.BuilderImpl
    implements Builder {
        private String applicationName;
        private Long currentApplicationVersionId;
        private String cloudWatchLoggingOptionId;
        private String conditionalToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationCloudWatchLoggingOptionRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentApplicationVersionId(model.currentApplicationVersionId);
            this.cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
            this.conditionalToken(model.conditionalToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return this.currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final String getCloudWatchLoggingOptionId() {
            return this.cloudWatchLoggingOptionId;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        public final String getConditionalToken() {
            return this.conditionalToken;
        }

        public final void setConditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
        }

        @Override
        public final Builder conditionalToken(String conditionalToken) {
            this.conditionalToken = conditionalToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationCloudWatchLoggingOptionRequest build() {
            return new DeleteApplicationCloudWatchLoggingOptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
        public Builder applicationName(String var1);

        public Builder currentApplicationVersionId(Long var1);

        public Builder cloudWatchLoggingOptionId(String var1);

        public Builder conditionalToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

