/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails;

public class ListApplicationSnapshotsPublisher
implements SdkPublisher<ListApplicationSnapshotsResponse> {
    private final KinesisAnalyticsV2AsyncClient client;
    private final ListApplicationSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationSnapshotsPublisher(KinesisAnalyticsV2AsyncClient client, ListApplicationSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationSnapshotsPublisher(KinesisAnalyticsV2AsyncClient client, ListApplicationSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotDetails> snapshotSummaries() {
        Function<ListApplicationSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotSummaries() != null) {
                return response.snapshotSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationSnapshotsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationSnapshotsResponseFetcher
    implements AsyncPageFetcher<ListApplicationSnapshotsResponse> {
        private ListApplicationSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationSnapshotsResponse> nextPage(ListApplicationSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationSnapshotsPublisher.this.client.listApplicationSnapshots(ListApplicationSnapshotsPublisher.this.firstRequest);
            }
            return ListApplicationSnapshotsPublisher.this.client.listApplicationSnapshots((ListApplicationSnapshotsRequest)((Object)ListApplicationSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

