/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UrlType {
    FLINK_DASHBOARD_URL("FLINK_DASHBOARD_URL"),
    ZEPPELIN_UI_URL("ZEPPELIN_UI_URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UrlType> VALUE_MAP;
    private final String value;

    private UrlType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UrlType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UrlType> knownValues() {
        EnumSet<UrlType> knownValues = EnumSet.allOf(UrlType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UrlType.class, UrlType::toString);
    }
}

