/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CSVMappingParameters;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.JSONMappingParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MappingParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MappingParameters> {
    private static final SdkField<JSONMappingParameters> JSON_MAPPING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JSONMappingParameters").getter(MappingParameters.getter(MappingParameters::jsonMappingParameters)).setter(MappingParameters.setter(Builder::jsonMappingParameters)).constructor(JSONMappingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JSONMappingParameters").build()}).build();
    private static final SdkField<CSVMappingParameters> CSV_MAPPING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CSVMappingParameters").getter(MappingParameters.getter(MappingParameters::csvMappingParameters)).setter(MappingParameters.setter(Builder::csvMappingParameters)).constructor(CSVMappingParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSVMappingParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_MAPPING_PARAMETERS_FIELD, CSV_MAPPING_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final JSONMappingParameters jsonMappingParameters;
    private final CSVMappingParameters csvMappingParameters;

    private MappingParameters(BuilderImpl builder) {
        this.jsonMappingParameters = builder.jsonMappingParameters;
        this.csvMappingParameters = builder.csvMappingParameters;
    }

    public final JSONMappingParameters jsonMappingParameters() {
        return this.jsonMappingParameters;
    }

    public final CSVMappingParameters csvMappingParameters() {
        return this.csvMappingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonMappingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvMappingParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingParameters)) {
            return false;
        }
        MappingParameters other = (MappingParameters)obj;
        return Objects.equals(this.jsonMappingParameters(), other.jsonMappingParameters()) && Objects.equals(this.csvMappingParameters(), other.csvMappingParameters());
    }

    public final String toString() {
        return ToString.builder((String)"MappingParameters").add("JSONMappingParameters", (Object)this.jsonMappingParameters()).add("CSVMappingParameters", (Object)this.csvMappingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JSONMappingParameters": {
                return Optional.ofNullable(clazz.cast(this.jsonMappingParameters()));
            }
            case "CSVMappingParameters": {
                return Optional.ofNullable(clazz.cast(this.csvMappingParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MappingParameters, T> g) {
        return obj -> g.apply((MappingParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private JSONMappingParameters jsonMappingParameters;
        private CSVMappingParameters csvMappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingParameters model) {
            this.jsonMappingParameters(model.jsonMappingParameters);
            this.csvMappingParameters(model.csvMappingParameters);
        }

        public final JSONMappingParameters.Builder getJsonMappingParameters() {
            return this.jsonMappingParameters != null ? this.jsonMappingParameters.toBuilder() : null;
        }

        public final void setJsonMappingParameters(JSONMappingParameters.BuilderImpl jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters != null ? jsonMappingParameters.build() : null;
        }

        @Override
        public final Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
            return this;
        }

        public final CSVMappingParameters.Builder getCsvMappingParameters() {
            return this.csvMappingParameters != null ? this.csvMappingParameters.toBuilder() : null;
        }

        public final void setCsvMappingParameters(CSVMappingParameters.BuilderImpl csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters != null ? csvMappingParameters.build() : null;
        }

        @Override
        public final Builder csvMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
            return this;
        }

        public MappingParameters build() {
            return new MappingParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MappingParameters> {
        public Builder jsonMappingParameters(JSONMappingParameters var1);

        default public Builder jsonMappingParameters(Consumer<JSONMappingParameters.Builder> jsonMappingParameters) {
            return this.jsonMappingParameters((JSONMappingParameters)((JSONMappingParameters.Builder)JSONMappingParameters.builder().applyMutation(jsonMappingParameters)).build());
        }

        public Builder csvMappingParameters(CSVMappingParameters var1);

        default public Builder csvMappingParameters(Consumer<CSVMappingParameters.Builder> csvMappingParameters) {
            return this.csvMappingParameters((CSVMappingParameters)((CSVMappingParameters.Builder)CSVMappingParameters.builder().applyMutation(csvMappingParameters)).build());
        }
    }
}

