/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ParsedInputRecordsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ProcessedInputRecordsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RawInputRecordsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SourceSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInputSchemaResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, DiscoverInputSchemaResponse> {
    private static final SdkField<SourceSchema> INPUT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSchema").getter(DiscoverInputSchemaResponse.getter(DiscoverInputSchemaResponse::inputSchema)).setter(DiscoverInputSchemaResponse.setter(Builder::inputSchema)).constructor(SourceSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSchema").build()}).build();
    private static final SdkField<List<List<String>>> PARSED_INPUT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParsedInputRecords").getter(DiscoverInputSchemaResponse.getter(DiscoverInputSchemaResponse::parsedInputRecords)).setter(DiscoverInputSchemaResponse.setter(Builder::parsedInputRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParsedInputRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROCESSED_INPUT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessedInputRecords").getter(DiscoverInputSchemaResponse.getter(DiscoverInputSchemaResponse::processedInputRecords)).setter(DiscoverInputSchemaResponse.setter(Builder::processedInputRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedInputRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RAW_INPUT_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RawInputRecords").getter(DiscoverInputSchemaResponse.getter(DiscoverInputSchemaResponse::rawInputRecords)).setter(DiscoverInputSchemaResponse.setter(Builder::rawInputRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawInputRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_SCHEMA_FIELD, PARSED_INPUT_RECORDS_FIELD, PROCESSED_INPUT_RECORDS_FIELD, RAW_INPUT_RECORDS_FIELD));
    private final SourceSchema inputSchema;
    private final List<List<String>> parsedInputRecords;
    private final List<String> processedInputRecords;
    private final List<String> rawInputRecords;

    private DiscoverInputSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.inputSchema = builder.inputSchema;
        this.parsedInputRecords = builder.parsedInputRecords;
        this.processedInputRecords = builder.processedInputRecords;
        this.rawInputRecords = builder.rawInputRecords;
    }

    public final SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public final boolean hasParsedInputRecords() {
        return this.parsedInputRecords != null && !(this.parsedInputRecords instanceof SdkAutoConstructList);
    }

    public final List<List<String>> parsedInputRecords() {
        return this.parsedInputRecords;
    }

    public final boolean hasProcessedInputRecords() {
        return this.processedInputRecords != null && !(this.processedInputRecords instanceof SdkAutoConstructList);
    }

    public final List<String> processedInputRecords() {
        return this.processedInputRecords;
    }

    public final boolean hasRawInputRecords() {
        return this.rawInputRecords != null && !(this.rawInputRecords instanceof SdkAutoConstructList);
    }

    public final List<String> rawInputRecords() {
        return this.rawInputRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParsedInputRecords() ? this.parsedInputRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessedInputRecords() ? this.processedInputRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRawInputRecords() ? this.rawInputRecords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInputSchemaResponse)) {
            return false;
        }
        DiscoverInputSchemaResponse other = (DiscoverInputSchemaResponse)((Object)obj);
        return Objects.equals(this.inputSchema(), other.inputSchema()) && this.hasParsedInputRecords() == other.hasParsedInputRecords() && Objects.equals(this.parsedInputRecords(), other.parsedInputRecords()) && this.hasProcessedInputRecords() == other.hasProcessedInputRecords() && Objects.equals(this.processedInputRecords(), other.processedInputRecords()) && this.hasRawInputRecords() == other.hasRawInputRecords() && Objects.equals(this.rawInputRecords(), other.rawInputRecords());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoverInputSchemaResponse").add("InputSchema", (Object)this.inputSchema()).add("ParsedInputRecords", this.hasParsedInputRecords() ? this.parsedInputRecords() : null).add("ProcessedInputRecords", this.hasProcessedInputRecords() ? this.processedInputRecords() : null).add("RawInputRecords", this.hasRawInputRecords() ? this.rawInputRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputSchema": {
                return Optional.ofNullable(clazz.cast(this.inputSchema()));
            }
            case "ParsedInputRecords": {
                return Optional.ofNullable(clazz.cast(this.parsedInputRecords()));
            }
            case "ProcessedInputRecords": {
                return Optional.ofNullable(clazz.cast(this.processedInputRecords()));
            }
            case "RawInputRecords": {
                return Optional.ofNullable(clazz.cast(this.rawInputRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInputSchemaResponse, T> g) {
        return obj -> g.apply((DiscoverInputSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private SourceSchema inputSchema;
        private List<List<String>> parsedInputRecords = DefaultSdkAutoConstructList.getInstance();
        private List<String> processedInputRecords = DefaultSdkAutoConstructList.getInstance();
        private List<String> rawInputRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInputSchemaResponse model) {
            super(model);
            this.inputSchema(model.inputSchema);
            this.parsedInputRecords(model.parsedInputRecords);
            this.processedInputRecords(model.processedInputRecords);
            this.rawInputRecords(model.rawInputRecords);
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final Collection<? extends Collection<String>> getParsedInputRecords() {
            if (this.parsedInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parsedInputRecords;
        }

        public final void setParsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
        }

        @Override
        public final Builder parsedInputRecords(Collection<? extends Collection<String>> parsedInputRecords) {
            this.parsedInputRecords = ParsedInputRecordsCopier.copy(parsedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parsedInputRecords(Collection<String> ... parsedInputRecords) {
            this.parsedInputRecords((Collection<? extends Collection<String>>)Arrays.asList(parsedInputRecords));
            return this;
        }

        public final Collection<String> getProcessedInputRecords() {
            if (this.processedInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processedInputRecords;
        }

        public final void setProcessedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
        }

        @Override
        public final Builder processedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedInputRecords(String ... processedInputRecords) {
            this.processedInputRecords(Arrays.asList(processedInputRecords));
            return this;
        }

        public final Collection<String> getRawInputRecords() {
            if (this.rawInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rawInputRecords;
        }

        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String ... rawInputRecords) {
            this.rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        @Override
        public DiscoverInputSchemaResponse build() {
            return new DiscoverInputSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverInputSchemaResponse> {
        public Builder inputSchema(SourceSchema var1);

        default public Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return this.inputSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(inputSchema)).build());
        }

        public Builder parsedInputRecords(Collection<? extends Collection<String>> var1);

        public Builder parsedInputRecords(Collection<String> ... var1);

        public Builder processedInputRecords(Collection<String> var1);

        public Builder processedInputRecords(String ... var1);

        public Builder rawInputRecords(Collection<String> var1);

        public Builder rawInputRecords(String ... var1);
    }
}

