/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisanalyticsv2.DefaultKinesisAnalyticsV2AsyncClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.DefaultKinesisAnalyticsV2BaseClientBuilder;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClient;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClientBuilder;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2ServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.endpoints.KinesisAnalyticsV2EndpointProvider;

@SdkInternalApi
final class DefaultKinesisAnalyticsV2AsyncClientBuilder
extends DefaultKinesisAnalyticsV2BaseClientBuilder<KinesisAnalyticsV2AsyncClientBuilder, KinesisAnalyticsV2AsyncClient>
implements KinesisAnalyticsV2AsyncClientBuilder {
    DefaultKinesisAnalyticsV2AsyncClientBuilder() {
    }

    @Override
    public DefaultKinesisAnalyticsV2AsyncClientBuilder endpointProvider(KinesisAnalyticsV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisAnalyticsV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKinesisAnalyticsV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        KinesisAnalyticsV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisAnalyticsV2AsyncClient client = new DefaultKinesisAnalyticsV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisAnalyticsV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisAnalyticsV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

