/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InAppStreamNamesCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputParallelism;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SourceSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDescription> {
    private static final SdkField<String> INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputId").getter(InputDescription.getter(InputDescription::inputId)).setter(InputDescription.setter(Builder::inputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()}).build();
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamePrefix").getter(InputDescription.getter(InputDescription::namePrefix)).setter(InputDescription.setter(Builder::namePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()}).build();
    private static final SdkField<List<String>> IN_APP_STREAM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InAppStreamNames").getter(InputDescription.getter(InputDescription::inAppStreamNames)).setter(InputDescription.setter(Builder::inAppStreamNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppStreamNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InputProcessingConfigurationDescription> INPUT_PROCESSING_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputProcessingConfigurationDescription").getter(InputDescription.getter(InputDescription::inputProcessingConfigurationDescription)).setter(InputDescription.setter(Builder::inputProcessingConfigurationDescription)).constructor(InputProcessingConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfigurationDescription").build()}).build();
    private static final SdkField<KinesisStreamsInputDescription> KINESIS_STREAMS_INPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamsInputDescription").getter(InputDescription.getter(InputDescription::kinesisStreamsInputDescription)).setter(InputDescription.setter(Builder::kinesisStreamsInputDescription)).constructor(KinesisStreamsInputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsInputDescription").build()}).build();
    private static final SdkField<KinesisFirehoseInputDescription> KINESIS_FIREHOSE_INPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisFirehoseInputDescription").getter(InputDescription.getter(InputDescription::kinesisFirehoseInputDescription)).setter(InputDescription.setter(Builder::kinesisFirehoseInputDescription)).constructor(KinesisFirehoseInputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseInputDescription").build()}).build();
    private static final SdkField<SourceSchema> INPUT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputSchema").getter(InputDescription.getter(InputDescription::inputSchema)).setter(InputDescription.setter(Builder::inputSchema)).constructor(SourceSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputSchema").build()}).build();
    private static final SdkField<InputParallelism> INPUT_PARALLELISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputParallelism").getter(InputDescription.getter(InputDescription::inputParallelism)).setter(InputDescription.setter(Builder::inputParallelism)).constructor(InputParallelism::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputParallelism").build()}).build();
    private static final SdkField<InputStartingPositionConfiguration> INPUT_STARTING_POSITION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputStartingPositionConfiguration").getter(InputDescription.getter(InputDescription::inputStartingPositionConfiguration)).setter(InputDescription.setter(Builder::inputStartingPositionConfiguration)).constructor(InputStartingPositionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputStartingPositionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ID_FIELD, NAME_PREFIX_FIELD, IN_APP_STREAM_NAMES_FIELD, INPUT_PROCESSING_CONFIGURATION_DESCRIPTION_FIELD, KINESIS_STREAMS_INPUT_DESCRIPTION_FIELD, KINESIS_FIREHOSE_INPUT_DESCRIPTION_FIELD, INPUT_SCHEMA_FIELD, INPUT_PARALLELISM_FIELD, INPUT_STARTING_POSITION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputId;
    private final String namePrefix;
    private final List<String> inAppStreamNames;
    private final InputProcessingConfigurationDescription inputProcessingConfigurationDescription;
    private final KinesisStreamsInputDescription kinesisStreamsInputDescription;
    private final KinesisFirehoseInputDescription kinesisFirehoseInputDescription;
    private final SourceSchema inputSchema;
    private final InputParallelism inputParallelism;
    private final InputStartingPositionConfiguration inputStartingPositionConfiguration;

    private InputDescription(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefix = builder.namePrefix;
        this.inAppStreamNames = builder.inAppStreamNames;
        this.inputProcessingConfigurationDescription = builder.inputProcessingConfigurationDescription;
        this.kinesisStreamsInputDescription = builder.kinesisStreamsInputDescription;
        this.kinesisFirehoseInputDescription = builder.kinesisFirehoseInputDescription;
        this.inputSchema = builder.inputSchema;
        this.inputParallelism = builder.inputParallelism;
        this.inputStartingPositionConfiguration = builder.inputStartingPositionConfiguration;
    }

    public final String inputId() {
        return this.inputId;
    }

    public final String namePrefix() {
        return this.namePrefix;
    }

    public final boolean hasInAppStreamNames() {
        return this.inAppStreamNames != null && !(this.inAppStreamNames instanceof SdkAutoConstructList);
    }

    public final List<String> inAppStreamNames() {
        return this.inAppStreamNames;
    }

    public final InputProcessingConfigurationDescription inputProcessingConfigurationDescription() {
        return this.inputProcessingConfigurationDescription;
    }

    public final KinesisStreamsInputDescription kinesisStreamsInputDescription() {
        return this.kinesisStreamsInputDescription;
    }

    public final KinesisFirehoseInputDescription kinesisFirehoseInputDescription() {
        return this.kinesisFirehoseInputDescription;
    }

    public final SourceSchema inputSchema() {
        return this.inputSchema;
    }

    public final InputParallelism inputParallelism() {
        return this.inputParallelism;
    }

    public final InputStartingPositionConfiguration inputStartingPositionConfiguration() {
        return this.inputStartingPositionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputId());
        hashCode = 31 * hashCode + Objects.hashCode(this.namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInAppStreamNames() ? this.inAppStreamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputProcessingConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamsInputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisFirehoseInputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStartingPositionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDescription)) {
            return false;
        }
        InputDescription other = (InputDescription)obj;
        return Objects.equals(this.inputId(), other.inputId()) && Objects.equals(this.namePrefix(), other.namePrefix()) && this.hasInAppStreamNames() == other.hasInAppStreamNames() && Objects.equals(this.inAppStreamNames(), other.inAppStreamNames()) && Objects.equals(this.inputProcessingConfigurationDescription(), other.inputProcessingConfigurationDescription()) && Objects.equals(this.kinesisStreamsInputDescription(), other.kinesisStreamsInputDescription()) && Objects.equals(this.kinesisFirehoseInputDescription(), other.kinesisFirehoseInputDescription()) && Objects.equals(this.inputSchema(), other.inputSchema()) && Objects.equals(this.inputParallelism(), other.inputParallelism()) && Objects.equals(this.inputStartingPositionConfiguration(), other.inputStartingPositionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"InputDescription").add("InputId", (Object)this.inputId()).add("NamePrefix", (Object)this.namePrefix()).add("InAppStreamNames", this.hasInAppStreamNames() ? this.inAppStreamNames() : null).add("InputProcessingConfigurationDescription", (Object)this.inputProcessingConfigurationDescription()).add("KinesisStreamsInputDescription", (Object)this.kinesisStreamsInputDescription()).add("KinesisFirehoseInputDescription", (Object)this.kinesisFirehoseInputDescription()).add("InputSchema", (Object)this.inputSchema()).add("InputParallelism", (Object)this.inputParallelism()).add("InputStartingPositionConfiguration", (Object)this.inputStartingPositionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputId": {
                return Optional.ofNullable(clazz.cast(this.inputId()));
            }
            case "NamePrefix": {
                return Optional.ofNullable(clazz.cast(this.namePrefix()));
            }
            case "InAppStreamNames": {
                return Optional.ofNullable(clazz.cast(this.inAppStreamNames()));
            }
            case "InputProcessingConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.inputProcessingConfigurationDescription()));
            }
            case "KinesisStreamsInputDescription": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamsInputDescription()));
            }
            case "KinesisFirehoseInputDescription": {
                return Optional.ofNullable(clazz.cast(this.kinesisFirehoseInputDescription()));
            }
            case "InputSchema": {
                return Optional.ofNullable(clazz.cast(this.inputSchema()));
            }
            case "InputParallelism": {
                return Optional.ofNullable(clazz.cast(this.inputParallelism()));
            }
            case "InputStartingPositionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputStartingPositionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDescription, T> g) {
        return obj -> g.apply((InputDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputId;
        private String namePrefix;
        private List<String> inAppStreamNames = DefaultSdkAutoConstructList.getInstance();
        private InputProcessingConfigurationDescription inputProcessingConfigurationDescription;
        private KinesisStreamsInputDescription kinesisStreamsInputDescription;
        private KinesisFirehoseInputDescription kinesisFirehoseInputDescription;
        private SourceSchema inputSchema;
        private InputParallelism inputParallelism;
        private InputStartingPositionConfiguration inputStartingPositionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDescription model) {
            this.inputId(model.inputId);
            this.namePrefix(model.namePrefix);
            this.inAppStreamNames(model.inAppStreamNames);
            this.inputProcessingConfigurationDescription(model.inputProcessingConfigurationDescription);
            this.kinesisStreamsInputDescription(model.kinesisStreamsInputDescription);
            this.kinesisFirehoseInputDescription(model.kinesisFirehoseInputDescription);
            this.inputSchema(model.inputSchema);
            this.inputParallelism(model.inputParallelism);
            this.inputStartingPositionConfiguration(model.inputStartingPositionConfiguration);
        }

        public final String getInputId() {
            return this.inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final String getNamePrefix() {
            return this.namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final Collection<String> getInAppStreamNames() {
            if (this.inAppStreamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inAppStreamNames;
        }

        public final void setInAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
        }

        @Override
        public final Builder inAppStreamNames(Collection<String> inAppStreamNames) {
            this.inAppStreamNames = InAppStreamNamesCopier.copy(inAppStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppStreamNames(String ... inAppStreamNames) {
            this.inAppStreamNames(Arrays.asList(inAppStreamNames));
            return this;
        }

        public final InputProcessingConfigurationDescription.Builder getInputProcessingConfigurationDescription() {
            return this.inputProcessingConfigurationDescription != null ? this.inputProcessingConfigurationDescription.toBuilder() : null;
        }

        public final void setInputProcessingConfigurationDescription(InputProcessingConfigurationDescription.BuilderImpl inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription != null ? inputProcessingConfigurationDescription.build() : null;
        }

        @Override
        public final Builder inputProcessingConfigurationDescription(InputProcessingConfigurationDescription inputProcessingConfigurationDescription) {
            this.inputProcessingConfigurationDescription = inputProcessingConfigurationDescription;
            return this;
        }

        public final KinesisStreamsInputDescription.Builder getKinesisStreamsInputDescription() {
            return this.kinesisStreamsInputDescription != null ? this.kinesisStreamsInputDescription.toBuilder() : null;
        }

        public final void setKinesisStreamsInputDescription(KinesisStreamsInputDescription.BuilderImpl kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription != null ? kinesisStreamsInputDescription.build() : null;
        }

        @Override
        public final Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription kinesisStreamsInputDescription) {
            this.kinesisStreamsInputDescription = kinesisStreamsInputDescription;
            return this;
        }

        public final KinesisFirehoseInputDescription.Builder getKinesisFirehoseInputDescription() {
            return this.kinesisFirehoseInputDescription != null ? this.kinesisFirehoseInputDescription.toBuilder() : null;
        }

        public final void setKinesisFirehoseInputDescription(KinesisFirehoseInputDescription.BuilderImpl kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription != null ? kinesisFirehoseInputDescription.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription kinesisFirehoseInputDescription) {
            this.kinesisFirehoseInputDescription = kinesisFirehoseInputDescription;
            return this;
        }

        public final SourceSchema.Builder getInputSchema() {
            return this.inputSchema != null ? this.inputSchema.toBuilder() : null;
        }

        public final void setInputSchema(SourceSchema.BuilderImpl inputSchema) {
            this.inputSchema = inputSchema != null ? inputSchema.build() : null;
        }

        @Override
        public final Builder inputSchema(SourceSchema inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        public final InputParallelism.Builder getInputParallelism() {
            return this.inputParallelism != null ? this.inputParallelism.toBuilder() : null;
        }

        public final void setInputParallelism(InputParallelism.BuilderImpl inputParallelism) {
            this.inputParallelism = inputParallelism != null ? inputParallelism.build() : null;
        }

        @Override
        public final Builder inputParallelism(InputParallelism inputParallelism) {
            this.inputParallelism = inputParallelism;
            return this;
        }

        public final InputStartingPositionConfiguration.Builder getInputStartingPositionConfiguration() {
            return this.inputStartingPositionConfiguration != null ? this.inputStartingPositionConfiguration.toBuilder() : null;
        }

        public final void setInputStartingPositionConfiguration(InputStartingPositionConfiguration.BuilderImpl inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration != null ? inputStartingPositionConfiguration.build() : null;
        }

        @Override
        public final Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration inputStartingPositionConfiguration) {
            this.inputStartingPositionConfiguration = inputStartingPositionConfiguration;
            return this;
        }

        public InputDescription build() {
            return new InputDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDescription> {
        public Builder inputId(String var1);

        public Builder namePrefix(String var1);

        public Builder inAppStreamNames(Collection<String> var1);

        public Builder inAppStreamNames(String ... var1);

        public Builder inputProcessingConfigurationDescription(InputProcessingConfigurationDescription var1);

        default public Builder inputProcessingConfigurationDescription(Consumer<InputProcessingConfigurationDescription.Builder> inputProcessingConfigurationDescription) {
            return this.inputProcessingConfigurationDescription((InputProcessingConfigurationDescription)((InputProcessingConfigurationDescription.Builder)InputProcessingConfigurationDescription.builder().applyMutation(inputProcessingConfigurationDescription)).build());
        }

        public Builder kinesisStreamsInputDescription(KinesisStreamsInputDescription var1);

        default public Builder kinesisStreamsInputDescription(Consumer<KinesisStreamsInputDescription.Builder> kinesisStreamsInputDescription) {
            return this.kinesisStreamsInputDescription((KinesisStreamsInputDescription)((KinesisStreamsInputDescription.Builder)KinesisStreamsInputDescription.builder().applyMutation(kinesisStreamsInputDescription)).build());
        }

        public Builder kinesisFirehoseInputDescription(KinesisFirehoseInputDescription var1);

        default public Builder kinesisFirehoseInputDescription(Consumer<KinesisFirehoseInputDescription.Builder> kinesisFirehoseInputDescription) {
            return this.kinesisFirehoseInputDescription((KinesisFirehoseInputDescription)((KinesisFirehoseInputDescription.Builder)KinesisFirehoseInputDescription.builder().applyMutation(kinesisFirehoseInputDescription)).build());
        }

        public Builder inputSchema(SourceSchema var1);

        default public Builder inputSchema(Consumer<SourceSchema.Builder> inputSchema) {
            return this.inputSchema((SourceSchema)((SourceSchema.Builder)SourceSchema.builder().applyMutation(inputSchema)).build());
        }

        public Builder inputParallelism(InputParallelism var1);

        default public Builder inputParallelism(Consumer<InputParallelism.Builder> inputParallelism) {
            return this.inputParallelism((InputParallelism)((InputParallelism.Builder)InputParallelism.builder().applyMutation(inputParallelism)).build());
        }

        public Builder inputStartingPositionConfiguration(InputStartingPositionConfiguration var1);

        default public Builder inputStartingPositionConfiguration(Consumer<InputStartingPositionConfiguration.Builder> inputStartingPositionConfiguration) {
            return this.inputStartingPositionConfiguration((InputStartingPositionConfiguration)((InputStartingPositionConfiguration.Builder)InputStartingPositionConfiguration.builder().applyMutation(inputStartingPositionConfiguration)).build());
        }
    }
}

