/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisanalyticsv2.DefaultKinesisAnalyticsV2BaseClientBuilder;
import software.amazon.awssdk.services.kinesisanalyticsv2.DefaultKinesisAnalyticsV2Client;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2Client;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2ClientBuilder;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2ServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisanalyticsv2.endpoints.KinesisAnalyticsV2EndpointProvider;

@SdkInternalApi
final class DefaultKinesisAnalyticsV2ClientBuilder
extends DefaultKinesisAnalyticsV2BaseClientBuilder<KinesisAnalyticsV2ClientBuilder, KinesisAnalyticsV2Client>
implements KinesisAnalyticsV2ClientBuilder {
    DefaultKinesisAnalyticsV2ClientBuilder() {
    }

    @Override
    public DefaultKinesisAnalyticsV2ClientBuilder endpointProvider(KinesisAnalyticsV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisAnalyticsV2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisAnalyticsV2ClientBuilder.validateClientOptions(clientConfiguration);
        KinesisAnalyticsV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisAnalyticsV2Client client = new DefaultKinesisAnalyticsV2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisAnalyticsV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisAnalyticsV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

