/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationVersionSummary> {
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(ApplicationVersionSummary.getter(ApplicationVersionSummary::applicationVersionId)).setter(ApplicationVersionSummary.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationStatus").getter(ApplicationVersionSummary.getter(ApplicationVersionSummary::applicationStatusAsString)).setter(ApplicationVersionSummary.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_VERSION_ID_FIELD, APPLICATION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long applicationVersionId;
    private final String applicationStatus;

    private ApplicationVersionSummary(BuilderImpl builder) {
        this.applicationVersionId = builder.applicationVersionId;
        this.applicationStatus = builder.applicationStatus;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public final String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationVersionSummary)) {
            return false;
        }
        ApplicationVersionSummary other = (ApplicationVersionSummary)obj;
        return Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationVersionSummary").add("ApplicationVersionId", (Object)this.applicationVersionId()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationVersionSummary, T> g) {
        return obj -> g.apply((ApplicationVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long applicationVersionId;
        private String applicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationVersionSummary model) {
            this.applicationVersionId(model.applicationVersionId);
            this.applicationStatus(model.applicationStatus);
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        @Transient
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        @Transient
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public ApplicationVersionSummary build() {
            return new ApplicationVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationVersionSummary> {
        public Builder applicationVersionId(Long var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);
    }
}

