/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParallelismConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParallelismConfigurationDescription> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationType").getter(ParallelismConfigurationDescription.getter(ParallelismConfigurationDescription::configurationTypeAsString)).setter(ParallelismConfigurationDescription.setter(Builder::configurationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()}).build();
    private static final SdkField<Integer> PARALLELISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Parallelism").getter(ParallelismConfigurationDescription.getter(ParallelismConfigurationDescription::parallelism)).setter(ParallelismConfigurationDescription.setter(Builder::parallelism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parallelism").build()}).build();
    private static final SdkField<Integer> PARALLELISM_PER_KPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelismPerKPU").getter(ParallelismConfigurationDescription.getter(ParallelismConfigurationDescription::parallelismPerKPU)).setter(ParallelismConfigurationDescription.setter(Builder::parallelismPerKPU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelismPerKPU").build()}).build();
    private static final SdkField<Integer> CURRENT_PARALLELISM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentParallelism").getter(ParallelismConfigurationDescription.getter(ParallelismConfigurationDescription::currentParallelism)).setter(ParallelismConfigurationDescription.setter(Builder::currentParallelism)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentParallelism").build()}).build();
    private static final SdkField<Boolean> AUTO_SCALING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoScalingEnabled").getter(ParallelismConfigurationDescription.getter(ParallelismConfigurationDescription::autoScalingEnabled)).setter(ParallelismConfigurationDescription.setter(Builder::autoScalingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD, PARALLELISM_FIELD, PARALLELISM_PER_KPU_FIELD, CURRENT_PARALLELISM_FIELD, AUTO_SCALING_ENABLED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationType;
    private final Integer parallelism;
    private final Integer parallelismPerKPU;
    private final Integer currentParallelism;
    private final Boolean autoScalingEnabled;

    private ParallelismConfigurationDescription(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.parallelism = builder.parallelism;
        this.parallelismPerKPU = builder.parallelismPerKPU;
        this.currentParallelism = builder.currentParallelism;
        this.autoScalingEnabled = builder.autoScalingEnabled;
    }

    public final ConfigurationType configurationType() {
        return ConfigurationType.fromValue(this.configurationType);
    }

    public final String configurationTypeAsString() {
        return this.configurationType;
    }

    public final Integer parallelism() {
        return this.parallelism;
    }

    public final Integer parallelismPerKPU() {
        return this.parallelismPerKPU;
    }

    public final Integer currentParallelism() {
        return this.currentParallelism;
    }

    public final Boolean autoScalingEnabled() {
        return this.autoScalingEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelism());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelismPerKPU());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentParallelism());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelismConfigurationDescription)) {
            return false;
        }
        ParallelismConfigurationDescription other = (ParallelismConfigurationDescription)obj;
        return Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && Objects.equals(this.parallelism(), other.parallelism()) && Objects.equals(this.parallelismPerKPU(), other.parallelismPerKPU()) && Objects.equals(this.currentParallelism(), other.currentParallelism()) && Objects.equals(this.autoScalingEnabled(), other.autoScalingEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"ParallelismConfigurationDescription").add("ConfigurationType", (Object)this.configurationTypeAsString()).add("Parallelism", (Object)this.parallelism()).add("ParallelismPerKPU", (Object)this.parallelismPerKPU()).add("CurrentParallelism", (Object)this.currentParallelism()).add("AutoScalingEnabled", (Object)this.autoScalingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "Parallelism": {
                return Optional.ofNullable(clazz.cast(this.parallelism()));
            }
            case "ParallelismPerKPU": {
                return Optional.ofNullable(clazz.cast(this.parallelismPerKPU()));
            }
            case "CurrentParallelism": {
                return Optional.ofNullable(clazz.cast(this.currentParallelism()));
            }
            case "AutoScalingEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoScalingEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParallelismConfigurationDescription, T> g) {
        return obj -> g.apply((ParallelismConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationType;
        private Integer parallelism;
        private Integer parallelismPerKPU;
        private Integer currentParallelism;
        private Boolean autoScalingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ParallelismConfigurationDescription model) {
            this.configurationType(model.configurationType);
            this.parallelism(model.parallelism);
            this.parallelismPerKPU(model.parallelismPerKPU);
            this.currentParallelism(model.currentParallelism);
            this.autoScalingEnabled(model.autoScalingEnabled);
        }

        public final String getConfigurationType() {
            return this.configurationType;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        @Override
        @Transient
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        @Transient
        public final Builder configurationType(ConfigurationType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final Integer getParallelism() {
            return this.parallelism;
        }

        public final void setParallelism(Integer parallelism) {
            this.parallelism = parallelism;
        }

        @Override
        @Transient
        public final Builder parallelism(Integer parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public final Integer getParallelismPerKPU() {
            return this.parallelismPerKPU;
        }

        public final void setParallelismPerKPU(Integer parallelismPerKPU) {
            this.parallelismPerKPU = parallelismPerKPU;
        }

        @Override
        @Transient
        public final Builder parallelismPerKPU(Integer parallelismPerKPU) {
            this.parallelismPerKPU = parallelismPerKPU;
            return this;
        }

        public final Integer getCurrentParallelism() {
            return this.currentParallelism;
        }

        public final void setCurrentParallelism(Integer currentParallelism) {
            this.currentParallelism = currentParallelism;
        }

        @Override
        @Transient
        public final Builder currentParallelism(Integer currentParallelism) {
            this.currentParallelism = currentParallelism;
            return this;
        }

        public final Boolean getAutoScalingEnabled() {
            return this.autoScalingEnabled;
        }

        public final void setAutoScalingEnabled(Boolean autoScalingEnabled) {
            this.autoScalingEnabled = autoScalingEnabled;
        }

        @Override
        @Transient
        public final Builder autoScalingEnabled(Boolean autoScalingEnabled) {
            this.autoScalingEnabled = autoScalingEnabled;
            return this;
        }

        public ParallelismConfigurationDescription build() {
            return new ParallelismConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParallelismConfigurationDescription> {
        public Builder configurationType(String var1);

        public Builder configurationType(ConfigurationType var1);

        public Builder parallelism(Integer var1);

        public Builder parallelismPerKPU(Integer var1);

        public Builder currentParallelism(Integer var1);

        public Builder autoScalingEnabled(Boolean var1);
    }
}

