/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationStatus {
    DELETING("DELETING"),
    STARTING("STARTING"),
    STOPPING("STOPPING"),
    READY("READY"),
    RUNNING("RUNNING"),
    UPDATING("UPDATING"),
    AUTOSCALING("AUTOSCALING"),
    FORCE_STOPPING("FORCE_STOPPING"),
    MAINTENANCE("MAINTENANCE"),
    ROLLING_BACK("ROLLING_BACK"),
    ROLLED_BACK("ROLLED_BACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationStatus> VALUE_MAP;
    private final String value;

    private ApplicationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationStatus> knownValues() {
        EnumSet<ApplicationStatus> knownValues = EnumSet.allOf(ApplicationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationStatus.class, ApplicationStatus::toString);
    }
}

