/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.InputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SqlApplicationConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SqlApplicationConfigurationDescription> {
    private static final SdkField<List<InputDescription>> INPUT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDescriptions").getter(SqlApplicationConfigurationDescription.getter(SqlApplicationConfigurationDescription::inputDescriptions)).setter(SqlApplicationConfigurationDescription.setter(Builder::inputDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputDescription>> OUTPUT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputDescriptions").getter(SqlApplicationConfigurationDescription.getter(SqlApplicationConfigurationDescription::outputDescriptions)).setter(SqlApplicationConfigurationDescription.setter(Builder::outputDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReferenceDataSourceDescription>> REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceDataSourceDescriptions").getter(SqlApplicationConfigurationDescription.getter(SqlApplicationConfigurationDescription::referenceDataSourceDescriptions)).setter(SqlApplicationConfigurationDescription.setter(Builder::referenceDataSourceDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReferenceDataSourceDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DESCRIPTIONS_FIELD, OUTPUT_DESCRIPTIONS_FIELD, REFERENCE_DATA_SOURCE_DESCRIPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InputDescription> inputDescriptions;
    private final List<OutputDescription> outputDescriptions;
    private final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions;

    private SqlApplicationConfigurationDescription(BuilderImpl builder) {
        this.inputDescriptions = builder.inputDescriptions;
        this.outputDescriptions = builder.outputDescriptions;
        this.referenceDataSourceDescriptions = builder.referenceDataSourceDescriptions;
    }

    public final boolean hasInputDescriptions() {
        return this.inputDescriptions != null && !(this.inputDescriptions instanceof SdkAutoConstructList);
    }

    public final List<InputDescription> inputDescriptions() {
        return this.inputDescriptions;
    }

    public final boolean hasOutputDescriptions() {
        return this.outputDescriptions != null && !(this.outputDescriptions instanceof SdkAutoConstructList);
    }

    public final List<OutputDescription> outputDescriptions() {
        return this.outputDescriptions;
    }

    public final boolean hasReferenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions != null && !(this.referenceDataSourceDescriptions instanceof SdkAutoConstructList);
    }

    public final List<ReferenceDataSourceDescription> referenceDataSourceDescriptions() {
        return this.referenceDataSourceDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDescriptions() ? this.inputDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputDescriptions() ? this.outputDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceDataSourceDescriptions() ? this.referenceDataSourceDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlApplicationConfigurationDescription)) {
            return false;
        }
        SqlApplicationConfigurationDescription other = (SqlApplicationConfigurationDescription)obj;
        return this.hasInputDescriptions() == other.hasInputDescriptions() && Objects.equals(this.inputDescriptions(), other.inputDescriptions()) && this.hasOutputDescriptions() == other.hasOutputDescriptions() && Objects.equals(this.outputDescriptions(), other.outputDescriptions()) && this.hasReferenceDataSourceDescriptions() == other.hasReferenceDataSourceDescriptions() && Objects.equals(this.referenceDataSourceDescriptions(), other.referenceDataSourceDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"SqlApplicationConfigurationDescription").add("InputDescriptions", this.hasInputDescriptions() ? this.inputDescriptions() : null).add("OutputDescriptions", this.hasOutputDescriptions() ? this.outputDescriptions() : null).add("ReferenceDataSourceDescriptions", this.hasReferenceDataSourceDescriptions() ? this.referenceDataSourceDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputDescriptions": {
                return Optional.ofNullable(clazz.cast(this.inputDescriptions()));
            }
            case "OutputDescriptions": {
                return Optional.ofNullable(clazz.cast(this.outputDescriptions()));
            }
            case "ReferenceDataSourceDescriptions": {
                return Optional.ofNullable(clazz.cast(this.referenceDataSourceDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((SqlApplicationConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InputDescription> inputDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<OutputDescription> outputDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<ReferenceDataSourceDescription> referenceDataSourceDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlApplicationConfigurationDescription model) {
            this.inputDescriptions(model.inputDescriptions);
            this.outputDescriptions(model.outputDescriptions);
            this.referenceDataSourceDescriptions(model.referenceDataSourceDescriptions);
        }

        public final List<InputDescription.Builder> getInputDescriptions() {
            List<InputDescription.Builder> result = InputDescriptionsCopier.copyToBuilder(this.inputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inputDescriptions(Collection<InputDescription> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copy(inputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(InputDescription ... inputDescriptions) {
            this.inputDescriptions(Arrays.asList(inputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDescriptions(Consumer<InputDescription.Builder> ... inputDescriptions) {
            this.inputDescriptions(Stream.of(inputDescriptions).map(c -> (InputDescription)((InputDescription.Builder)InputDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDescriptions(Collection<InputDescription.BuilderImpl> inputDescriptions) {
            this.inputDescriptions = InputDescriptionsCopier.copyFromBuilder(inputDescriptions);
        }

        public final List<OutputDescription.Builder> getOutputDescriptions() {
            List<OutputDescription.Builder> result = OutputDescriptionsCopier.copyToBuilder(this.outputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription ... outputDescriptions) {
            this.outputDescriptions(Arrays.asList(outputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(Consumer<OutputDescription.Builder> ... outputDescriptions) {
            this.outputDescriptions(Stream.of(outputDescriptions).map(c -> (OutputDescription)((OutputDescription.Builder)OutputDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputDescriptions(Collection<OutputDescription.BuilderImpl> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copyFromBuilder(outputDescriptions);
        }

        public final List<ReferenceDataSourceDescription.Builder> getReferenceDataSourceDescriptions() {
            List<ReferenceDataSourceDescription.Builder> result = ReferenceDataSourceDescriptionsCopier.copyToBuilder(this.referenceDataSourceDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copy(referenceDataSourceDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Arrays.asList(referenceDataSourceDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions(Stream.of(referenceDataSourceDescriptions).map(c -> (ReferenceDataSourceDescription)((ReferenceDataSourceDescription.Builder)ReferenceDataSourceDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReferenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription.BuilderImpl> referenceDataSourceDescriptions) {
            this.referenceDataSourceDescriptions = ReferenceDataSourceDescriptionsCopier.copyFromBuilder(referenceDataSourceDescriptions);
        }

        public SqlApplicationConfigurationDescription build() {
            return new SqlApplicationConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SqlApplicationConfigurationDescription> {
        public Builder inputDescriptions(Collection<InputDescription> var1);

        public Builder inputDescriptions(InputDescription ... var1);

        public Builder inputDescriptions(Consumer<InputDescription.Builder> ... var1);

        public Builder outputDescriptions(Collection<OutputDescription> var1);

        public Builder outputDescriptions(OutputDescription ... var1);

        public Builder outputDescriptions(Consumer<OutputDescription.Builder> ... var1);

        public Builder referenceDataSourceDescriptions(Collection<ReferenceDataSourceDescription> var1);

        public Builder referenceDataSourceDescriptions(ReferenceDataSourceDescription ... var1);

        public Builder referenceDataSourceDescriptions(Consumer<ReferenceDataSourceDescription.Builder> ... var1);
    }
}

