/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ContentBaseLocationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ContentBaseLocationUpdate> {
    private static final SdkField<String> BUCKET_ARN_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARNUpdate").getter(S3ContentBaseLocationUpdate.getter(S3ContentBaseLocationUpdate::bucketARNUpdate)).setter(S3ContentBaseLocationUpdate.setter(Builder::bucketARNUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARNUpdate").build()}).build();
    private static final SdkField<String> BASE_PATH_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BasePathUpdate").getter(S3ContentBaseLocationUpdate.getter(S3ContentBaseLocationUpdate::basePathUpdate)).setter(S3ContentBaseLocationUpdate.setter(Builder::basePathUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasePathUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_UPDATE_FIELD, BASE_PATH_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketARNUpdate;
    private final String basePathUpdate;

    private S3ContentBaseLocationUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.basePathUpdate = builder.basePathUpdate;
    }

    public final String bucketARNUpdate() {
        return this.bucketARNUpdate;
    }

    public final String basePathUpdate() {
        return this.basePathUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.basePathUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentBaseLocationUpdate)) {
            return false;
        }
        S3ContentBaseLocationUpdate other = (S3ContentBaseLocationUpdate)obj;
        return Objects.equals(this.bucketARNUpdate(), other.bucketARNUpdate()) && Objects.equals(this.basePathUpdate(), other.basePathUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"S3ContentBaseLocationUpdate").add("BucketARNUpdate", (Object)this.bucketARNUpdate()).add("BasePathUpdate", (Object)this.basePathUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.bucketARNUpdate()));
            }
            case "BasePathUpdate": {
                return Optional.ofNullable(clazz.cast(this.basePathUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ContentBaseLocationUpdate, T> g) {
        return obj -> g.apply((S3ContentBaseLocationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARNUpdate;
        private String basePathUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentBaseLocationUpdate model) {
            this.bucketARNUpdate(model.bucketARNUpdate);
            this.basePathUpdate(model.basePathUpdate);
        }

        public final String getBucketARNUpdate() {
            return this.bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        public final String getBasePathUpdate() {
            return this.basePathUpdate;
        }

        @Override
        public final Builder basePathUpdate(String basePathUpdate) {
            this.basePathUpdate = basePathUpdate;
            return this;
        }

        public final void setBasePathUpdate(String basePathUpdate) {
            this.basePathUpdate = basePathUpdate;
        }

        public S3ContentBaseLocationUpdate build() {
            return new S3ContentBaseLocationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ContentBaseLocationUpdate> {
        public Builder bucketARNUpdate(String var1);

        public Builder basePathUpdate(String var1);
    }
}

