/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyUpdates;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdate;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationUpdatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationConfigurationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationConfigurationUpdate> {
    private static final SdkField<SqlApplicationConfigurationUpdate> SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqlApplicationConfigurationUpdate").getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::sqlApplicationConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::sqlApplicationConfigurationUpdate)).constructor(SqlApplicationConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfigurationUpdate").build()}).build();
    private static final SdkField<ApplicationCodeConfigurationUpdate> APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationCodeConfigurationUpdate").getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::applicationCodeConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::applicationCodeConfigurationUpdate)).constructor(ApplicationCodeConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfigurationUpdate").build()}).build();
    private static final SdkField<FlinkApplicationConfigurationUpdate> FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlinkApplicationConfigurationUpdate").getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::flinkApplicationConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::flinkApplicationConfigurationUpdate)).constructor(FlinkApplicationConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkApplicationConfigurationUpdate").build()}).build();
    private static final SdkField<EnvironmentPropertyUpdates> ENVIRONMENT_PROPERTY_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnvironmentPropertyUpdates").getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::environmentPropertyUpdates)).setter(ApplicationConfigurationUpdate.setter(Builder::environmentPropertyUpdates)).constructor(EnvironmentPropertyUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentPropertyUpdates").build()}).build();
    private static final SdkField<ApplicationSnapshotConfigurationUpdate> APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSnapshotConfigurationUpdate").getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::applicationSnapshotConfigurationUpdate)).setter(ApplicationConfigurationUpdate.setter(Builder::applicationSnapshotConfigurationUpdate)).constructor(ApplicationSnapshotConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSnapshotConfigurationUpdate").build()}).build();
    private static final SdkField<List<VpcConfigurationUpdate>> VPC_CONFIGURATION_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcConfigurationUpdates").getter(ApplicationConfigurationUpdate.getter(ApplicationConfigurationUpdate::vpcConfigurationUpdates)).setter(ApplicationConfigurationUpdate.setter(Builder::vpcConfigurationUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcConfigurationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_APPLICATION_CONFIGURATION_UPDATE_FIELD, APPLICATION_CODE_CONFIGURATION_UPDATE_FIELD, FLINK_APPLICATION_CONFIGURATION_UPDATE_FIELD, ENVIRONMENT_PROPERTY_UPDATES_FIELD, APPLICATION_SNAPSHOT_CONFIGURATION_UPDATE_FIELD, VPC_CONFIGURATION_UPDATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;
    private final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;
    private final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;
    private final EnvironmentPropertyUpdates environmentPropertyUpdates;
    private final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;
    private final List<VpcConfigurationUpdate> vpcConfigurationUpdates;

    private ApplicationConfigurationUpdate(BuilderImpl builder) {
        this.sqlApplicationConfigurationUpdate = builder.sqlApplicationConfigurationUpdate;
        this.applicationCodeConfigurationUpdate = builder.applicationCodeConfigurationUpdate;
        this.flinkApplicationConfigurationUpdate = builder.flinkApplicationConfigurationUpdate;
        this.environmentPropertyUpdates = builder.environmentPropertyUpdates;
        this.applicationSnapshotConfigurationUpdate = builder.applicationSnapshotConfigurationUpdate;
        this.vpcConfigurationUpdates = builder.vpcConfigurationUpdates;
    }

    public final SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate() {
        return this.sqlApplicationConfigurationUpdate;
    }

    public final ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate() {
        return this.applicationCodeConfigurationUpdate;
    }

    public final FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate() {
        return this.flinkApplicationConfigurationUpdate;
    }

    public final EnvironmentPropertyUpdates environmentPropertyUpdates() {
        return this.environmentPropertyUpdates;
    }

    public final ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate() {
        return this.applicationSnapshotConfigurationUpdate;
    }

    public final boolean hasVpcConfigurationUpdates() {
        return this.vpcConfigurationUpdates != null && !(this.vpcConfigurationUpdates instanceof SdkAutoConstructList);
    }

    public final List<VpcConfigurationUpdate> vpcConfigurationUpdates() {
        return this.vpcConfigurationUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCodeConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.flinkApplicationConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentPropertyUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSnapshotConfigurationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConfigurationUpdates() ? this.vpcConfigurationUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfigurationUpdate)) {
            return false;
        }
        ApplicationConfigurationUpdate other = (ApplicationConfigurationUpdate)obj;
        return Objects.equals(this.sqlApplicationConfigurationUpdate(), other.sqlApplicationConfigurationUpdate()) && Objects.equals(this.applicationCodeConfigurationUpdate(), other.applicationCodeConfigurationUpdate()) && Objects.equals(this.flinkApplicationConfigurationUpdate(), other.flinkApplicationConfigurationUpdate()) && Objects.equals(this.environmentPropertyUpdates(), other.environmentPropertyUpdates()) && Objects.equals(this.applicationSnapshotConfigurationUpdate(), other.applicationSnapshotConfigurationUpdate()) && this.hasVpcConfigurationUpdates() == other.hasVpcConfigurationUpdates() && Objects.equals(this.vpcConfigurationUpdates(), other.vpcConfigurationUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationConfigurationUpdate").add("SqlApplicationConfigurationUpdate", (Object)this.sqlApplicationConfigurationUpdate()).add("ApplicationCodeConfigurationUpdate", (Object)this.applicationCodeConfigurationUpdate()).add("FlinkApplicationConfigurationUpdate", (Object)this.flinkApplicationConfigurationUpdate()).add("EnvironmentPropertyUpdates", (Object)this.environmentPropertyUpdates()).add("ApplicationSnapshotConfigurationUpdate", (Object)this.applicationSnapshotConfigurationUpdate()).add("VpcConfigurationUpdates", this.hasVpcConfigurationUpdates() ? this.vpcConfigurationUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlApplicationConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.sqlApplicationConfigurationUpdate()));
            }
            case "ApplicationCodeConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationCodeConfigurationUpdate()));
            }
            case "FlinkApplicationConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.flinkApplicationConfigurationUpdate()));
            }
            case "EnvironmentPropertyUpdates": {
                return Optional.ofNullable(clazz.cast(this.environmentPropertyUpdates()));
            }
            case "ApplicationSnapshotConfigurationUpdate": {
                return Optional.ofNullable(clazz.cast(this.applicationSnapshotConfigurationUpdate()));
            }
            case "VpcConfigurationUpdates": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurationUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfigurationUpdate, T> g) {
        return obj -> g.apply((ApplicationConfigurationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate;
        private ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate;
        private FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate;
        private EnvironmentPropertyUpdates environmentPropertyUpdates;
        private ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate;
        private List<VpcConfigurationUpdate> vpcConfigurationUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfigurationUpdate model) {
            this.sqlApplicationConfigurationUpdate(model.sqlApplicationConfigurationUpdate);
            this.applicationCodeConfigurationUpdate(model.applicationCodeConfigurationUpdate);
            this.flinkApplicationConfigurationUpdate(model.flinkApplicationConfigurationUpdate);
            this.environmentPropertyUpdates(model.environmentPropertyUpdates);
            this.applicationSnapshotConfigurationUpdate(model.applicationSnapshotConfigurationUpdate);
            this.vpcConfigurationUpdates(model.vpcConfigurationUpdates);
        }

        public final SqlApplicationConfigurationUpdate.Builder getSqlApplicationConfigurationUpdate() {
            return this.sqlApplicationConfigurationUpdate != null ? this.sqlApplicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate;
            return this;
        }

        public final void setSqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate.BuilderImpl sqlApplicationConfigurationUpdate) {
            this.sqlApplicationConfigurationUpdate = sqlApplicationConfigurationUpdate != null ? sqlApplicationConfigurationUpdate.build() : null;
        }

        public final ApplicationCodeConfigurationUpdate.Builder getApplicationCodeConfigurationUpdate() {
            return this.applicationCodeConfigurationUpdate != null ? this.applicationCodeConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate;
            return this;
        }

        public final void setApplicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate.BuilderImpl applicationCodeConfigurationUpdate) {
            this.applicationCodeConfigurationUpdate = applicationCodeConfigurationUpdate != null ? applicationCodeConfigurationUpdate.build() : null;
        }

        public final FlinkApplicationConfigurationUpdate.Builder getFlinkApplicationConfigurationUpdate() {
            return this.flinkApplicationConfigurationUpdate != null ? this.flinkApplicationConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate;
            return this;
        }

        public final void setFlinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate.BuilderImpl flinkApplicationConfigurationUpdate) {
            this.flinkApplicationConfigurationUpdate = flinkApplicationConfigurationUpdate != null ? flinkApplicationConfigurationUpdate.build() : null;
        }

        public final EnvironmentPropertyUpdates.Builder getEnvironmentPropertyUpdates() {
            return this.environmentPropertyUpdates != null ? this.environmentPropertyUpdates.toBuilder() : null;
        }

        @Override
        public final Builder environmentPropertyUpdates(EnvironmentPropertyUpdates environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates;
            return this;
        }

        public final void setEnvironmentPropertyUpdates(EnvironmentPropertyUpdates.BuilderImpl environmentPropertyUpdates) {
            this.environmentPropertyUpdates = environmentPropertyUpdates != null ? environmentPropertyUpdates.build() : null;
        }

        public final ApplicationSnapshotConfigurationUpdate.Builder getApplicationSnapshotConfigurationUpdate() {
            return this.applicationSnapshotConfigurationUpdate != null ? this.applicationSnapshotConfigurationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate;
            return this;
        }

        public final void setApplicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate.BuilderImpl applicationSnapshotConfigurationUpdate) {
            this.applicationSnapshotConfigurationUpdate = applicationSnapshotConfigurationUpdate != null ? applicationSnapshotConfigurationUpdate.build() : null;
        }

        public final Collection<VpcConfigurationUpdate.Builder> getVpcConfigurationUpdates() {
            if (this.vpcConfigurationUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcConfigurationUpdates != null ? (Collection)this.vpcConfigurationUpdates.stream().map(VpcConfigurationUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcConfigurationUpdates(Collection<VpcConfigurationUpdate> vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates = VpcConfigurationUpdatesCopier.copy(vpcConfigurationUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationUpdates(VpcConfigurationUpdate ... vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates(Arrays.asList(vpcConfigurationUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationUpdates(Consumer<VpcConfigurationUpdate.Builder> ... vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates(Stream.of(vpcConfigurationUpdates).map(c -> (VpcConfigurationUpdate)((VpcConfigurationUpdate.Builder)VpcConfigurationUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcConfigurationUpdates(Collection<VpcConfigurationUpdate.BuilderImpl> vpcConfigurationUpdates) {
            this.vpcConfigurationUpdates = VpcConfigurationUpdatesCopier.copyFromBuilder(vpcConfigurationUpdates);
        }

        public ApplicationConfigurationUpdate build() {
            return new ApplicationConfigurationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationConfigurationUpdate> {
        public Builder sqlApplicationConfigurationUpdate(SqlApplicationConfigurationUpdate var1);

        default public Builder sqlApplicationConfigurationUpdate(Consumer<SqlApplicationConfigurationUpdate.Builder> sqlApplicationConfigurationUpdate) {
            return this.sqlApplicationConfigurationUpdate((SqlApplicationConfigurationUpdate)((SqlApplicationConfigurationUpdate.Builder)SqlApplicationConfigurationUpdate.builder().applyMutation(sqlApplicationConfigurationUpdate)).build());
        }

        public Builder applicationCodeConfigurationUpdate(ApplicationCodeConfigurationUpdate var1);

        default public Builder applicationCodeConfigurationUpdate(Consumer<ApplicationCodeConfigurationUpdate.Builder> applicationCodeConfigurationUpdate) {
            return this.applicationCodeConfigurationUpdate((ApplicationCodeConfigurationUpdate)((ApplicationCodeConfigurationUpdate.Builder)ApplicationCodeConfigurationUpdate.builder().applyMutation(applicationCodeConfigurationUpdate)).build());
        }

        public Builder flinkApplicationConfigurationUpdate(FlinkApplicationConfigurationUpdate var1);

        default public Builder flinkApplicationConfigurationUpdate(Consumer<FlinkApplicationConfigurationUpdate.Builder> flinkApplicationConfigurationUpdate) {
            return this.flinkApplicationConfigurationUpdate((FlinkApplicationConfigurationUpdate)((FlinkApplicationConfigurationUpdate.Builder)FlinkApplicationConfigurationUpdate.builder().applyMutation(flinkApplicationConfigurationUpdate)).build());
        }

        public Builder environmentPropertyUpdates(EnvironmentPropertyUpdates var1);

        default public Builder environmentPropertyUpdates(Consumer<EnvironmentPropertyUpdates.Builder> environmentPropertyUpdates) {
            return this.environmentPropertyUpdates((EnvironmentPropertyUpdates)((EnvironmentPropertyUpdates.Builder)EnvironmentPropertyUpdates.builder().applyMutation(environmentPropertyUpdates)).build());
        }

        public Builder applicationSnapshotConfigurationUpdate(ApplicationSnapshotConfigurationUpdate var1);

        default public Builder applicationSnapshotConfigurationUpdate(Consumer<ApplicationSnapshotConfigurationUpdate.Builder> applicationSnapshotConfigurationUpdate) {
            return this.applicationSnapshotConfigurationUpdate((ApplicationSnapshotConfigurationUpdate)((ApplicationSnapshotConfigurationUpdate.Builder)ApplicationSnapshotConfigurationUpdate.builder().applyMutation(applicationSnapshotConfigurationUpdate)).build());
        }

        public Builder vpcConfigurationUpdates(Collection<VpcConfigurationUpdate> var1);

        public Builder vpcConfigurationUpdates(VpcConfigurationUpdate ... var1);

        public Builder vpcConfigurationUpdates(Consumer<VpcConfigurationUpdate.Builder> ... var1);
    }
}

