/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data format is not valid. Kinesis Data Analytics cannot detect the schema for the given streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnableToDetectSchemaException extends KinesisAnalyticsV2Exception implements
        ToCopyableBuilder<UnableToDetectSchemaException.Builder, UnableToDetectSchemaException> {
    private static final SdkField<List<String>> RAW_INPUT_RECORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RawInputRecords")
            .getter(getter(UnableToDetectSchemaException::rawInputRecords))
            .setter(setter(Builder::rawInputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RawInputRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROCESSED_INPUT_RECORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProcessedInputRecords")
            .getter(getter(UnableToDetectSchemaException::processedInputRecords))
            .setter(setter(Builder::processedInputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedInputRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RAW_INPUT_RECORDS_FIELD,
            PROCESSED_INPUT_RECORDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> rawInputRecords;

    private final List<String> processedInputRecords;

    private UnableToDetectSchemaException(BuilderImpl builder) {
        super(builder);
        this.rawInputRecords = builder.rawInputRecords;
        this.processedInputRecords = builder.processedInputRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns true if the RawInputRecords property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRawInputRecords() {
        return rawInputRecords != null && !(rawInputRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Raw stream data that was sampled to infer the schema.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRawInputRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Raw stream data that was sampled to infer the schema.
     */
    public List<String> rawInputRecords() {
        return rawInputRecords;
    }

    /**
     * Returns true if the ProcessedInputRecords property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessedInputRecords() {
        return processedInputRecords != null && !(processedInputRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessedInputRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
     *         parameter.
     */
    public List<String> processedInputRecords() {
        return processedInputRecords;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnableToDetectSchemaException, T> g) {
        return obj -> g.apply((UnableToDetectSchemaException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnableToDetectSchemaException>,
            KinesisAnalyticsV2Exception.Builder {
        /**
         * <p>
         * Raw stream data that was sampled to infer the schema.
         * </p>
         * 
         * @param rawInputRecords
         *        Raw stream data that was sampled to infer the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(Collection<String> rawInputRecords);

        /**
         * <p>
         * Raw stream data that was sampled to infer the schema.
         * </p>
         * 
         * @param rawInputRecords
         *        Raw stream data that was sampled to infer the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawInputRecords(String... rawInputRecords);

        /**
         * <p>
         * Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
         * parameter.
         * </p>
         * 
         * @param processedInputRecords
         *        Stream data that was modified by the processor specified in the
         *        <code>InputProcessingConfiguration</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(Collection<String> processedInputRecords);

        /**
         * <p>
         * Stream data that was modified by the processor specified in the <code>InputProcessingConfiguration</code>
         * parameter.
         * </p>
         * 
         * @param processedInputRecords
         *        Stream data that was modified by the processor specified in the
         *        <code>InputProcessingConfiguration</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedInputRecords(String... processedInputRecords);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends KinesisAnalyticsV2Exception.BuilderImpl implements Builder {
        private List<String> rawInputRecords = DefaultSdkAutoConstructList.getInstance();

        private List<String> processedInputRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnableToDetectSchemaException model) {
            super(model);
            rawInputRecords(model.rawInputRecords);
            processedInputRecords(model.processedInputRecords);
        }

        public final Collection<String> getRawInputRecords() {
            if (rawInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return rawInputRecords;
        }

        @Override
        public final Builder rawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rawInputRecords(String... rawInputRecords) {
            rawInputRecords(Arrays.asList(rawInputRecords));
            return this;
        }

        public final void setRawInputRecords(Collection<String> rawInputRecords) {
            this.rawInputRecords = RawInputRecordsCopier.copy(rawInputRecords);
        }

        public final Collection<String> getProcessedInputRecords() {
            if (processedInputRecords instanceof SdkAutoConstructList) {
                return null;
            }
            return processedInputRecords;
        }

        @Override
        public final Builder processedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedInputRecords(String... processedInputRecords) {
            processedInputRecords(Arrays.asList(processedInputRecords));
            return this;
        }

        public final void setProcessedInputRecords(Collection<String> processedInputRecords) {
            this.processedInputRecords = ProcessedInputRecordsCopier.copy(processedInputRecords);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public UnableToDetectSchemaException build() {
            return new UnableToDetectSchemaException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
