/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a Flink-based Kinesis Data Analytics application, provides a description of an Amazon S3 object, including the
 * Amazon Resource Name (ARN) of the S3 bucket, the name of the Amazon S3 object that contains the data, and the version
 * number of the Amazon S3 object that contains the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ContentLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ContentLocation.Builder, S3ContentLocation> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARN").getter(getter(S3ContentLocation::bucketARN)).setter(setter(Builder::bucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()).build();

    private static final SdkField<String> FILE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileKey").getter(getter(S3ContentLocation::fileKey)).setter(setter(Builder::fileKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKey").build()).build();

    private static final SdkField<String> OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectVersion").getter(getter(S3ContentLocation::objectVersion)).setter(setter(Builder::objectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            FILE_KEY_FIELD, OBJECT_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketARN;

    private final String fileKey;

    private final String objectVersion;

    private S3ContentLocation(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
        this.objectVersion = builder.objectVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
     */
    public final String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The file key for the object containing the application code.
     * </p>
     * 
     * @return The file key for the object containing the application code.
     */
    public final String fileKey() {
        return fileKey;
    }

    /**
     * <p>
     * The version of the object containing the application code.
     * </p>
     * 
     * @return The version of the object containing the application code.
     */
    public final String objectVersion() {
        return objectVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileKey());
        hashCode = 31 * hashCode + Objects.hashCode(objectVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentLocation)) {
            return false;
        }
        S3ContentLocation other = (S3ContentLocation) obj;
        return Objects.equals(bucketARN(), other.bucketARN()) && Objects.equals(fileKey(), other.fileKey())
                && Objects.equals(objectVersion(), other.objectVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ContentLocation").add("BucketARN", bucketARN()).add("FileKey", fileKey())
                .add("ObjectVersion", objectVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARN":
            return Optional.ofNullable(clazz.cast(bucketARN()));
        case "FileKey":
            return Optional.ofNullable(clazz.cast(fileKey()));
        case "ObjectVersion":
            return Optional.ofNullable(clazz.cast(objectVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ContentLocation, T> g) {
        return obj -> g.apply((S3ContentLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ContentLocation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
         * </p>
         * 
         * @param bucketARN
         *        The Amazon Resource Name (ARN) for the S3 bucket containing the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The file key for the object containing the application code.
         * </p>
         * 
         * @param fileKey
         *        The file key for the object containing the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);

        /**
         * <p>
         * The version of the object containing the application code.
         * </p>
         * 
         * @param objectVersion
         *        The version of the object containing the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectVersion(String objectVersion);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARN;

        private String fileKey;

        private String objectVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentLocation model) {
            bucketARN(model.bucketARN);
            fileKey(model.fileKey);
            objectVersion(model.objectVersion);
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        public final String getObjectVersion() {
            return objectVersion;
        }

        @Override
        public final Builder objectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
            return this;
        }

        public final void setObjectVersion(String objectVersion) {
            this.objectVersion = objectVersion;
        }

        @Override
        public S3ContentLocation build() {
            return new S3ContentLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
