/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a SQL-based Kinesis Data Analytics application, provides a description of an Amazon S3 data source, including the
 * Amazon Resource Name (ARN) of the S3 bucket and the name of the Amazon S3 object that contains the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Configuration implements SdkPojo, Serializable, ToCopyableBuilder<S3Configuration.Builder, S3Configuration> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARN").getter(getter(S3Configuration::bucketARN)).setter(setter(Builder::bucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()).build();

    private static final SdkField<String> FILE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileKey").getter(getter(S3Configuration::fileKey)).setter(setter(Builder::fileKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            FILE_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketARN;

    private final String fileKey;

    private S3Configuration(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.fileKey = builder.fileKey;
    }

    /**
     * <p>
     * The ARN of the S3 bucket that contains the data.
     * </p>
     * 
     * @return The ARN of the S3 bucket that contains the data.
     */
    public final String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The name of the object that contains the data.
     * </p>
     * 
     * @return The name of the object that contains the data.
     */
    public final String fileKey() {
        return fileKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(fileKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Configuration)) {
            return false;
        }
        S3Configuration other = (S3Configuration) obj;
        return Objects.equals(bucketARN(), other.bucketARN()) && Objects.equals(fileKey(), other.fileKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Configuration").add("BucketARN", bucketARN()).add("FileKey", fileKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARN":
            return Optional.ofNullable(clazz.cast(bucketARN()));
        case "FileKey":
            return Optional.ofNullable(clazz.cast(fileKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Configuration, T> g) {
        return obj -> g.apply((S3Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Configuration> {
        /**
         * <p>
         * The ARN of the S3 bucket that contains the data.
         * </p>
         * 
         * @param bucketARN
         *        The ARN of the S3 bucket that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The name of the object that contains the data.
         * </p>
         * 
         * @param fileKey
         *        The name of the object that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKey(String fileKey);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARN;

        private String fileKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Configuration model) {
            bucketARN(model.bucketARN);
            fileKey(model.fileKey);
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        public final String getFileKey() {
            return fileKey;
        }

        @Override
        public final Builder fileKey(String fileKey) {
            this.fileKey = fileKey;
            return this;
        }

        public final void setFileKey(String fileKey) {
            this.fileKey = fileKey;
        }

        @Override
        public S3Configuration build() {
            return new S3Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
