/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the starting properties for a Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<RunConfigurationDescription.Builder, RunConfigurationDescription> {
    private static final SdkField<ApplicationRestoreConfiguration> APPLICATION_RESTORE_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<ApplicationRestoreConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationRestoreConfigurationDescription")
            .getter(getter(RunConfigurationDescription::applicationRestoreConfigurationDescription))
            .setter(setter(Builder::applicationRestoreConfigurationDescription))
            .constructor(ApplicationRestoreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApplicationRestoreConfigurationDescription").build()).build();

    private static final SdkField<FlinkRunConfiguration> FLINK_RUN_CONFIGURATION_DESCRIPTION_FIELD = SdkField
            .<FlinkRunConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("FlinkRunConfigurationDescription")
            .getter(getter(RunConfigurationDescription::flinkRunConfigurationDescription))
            .setter(setter(Builder::flinkRunConfigurationDescription))
            .constructor(FlinkRunConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkRunConfigurationDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_RESTORE_CONFIGURATION_DESCRIPTION_FIELD, FLINK_RUN_CONFIGURATION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ApplicationRestoreConfiguration applicationRestoreConfigurationDescription;

    private final FlinkRunConfiguration flinkRunConfigurationDescription;

    private RunConfigurationDescription(BuilderImpl builder) {
        this.applicationRestoreConfigurationDescription = builder.applicationRestoreConfigurationDescription;
        this.flinkRunConfigurationDescription = builder.flinkRunConfigurationDescription;
    }

    /**
     * <p>
     * Describes the restore behavior of a restarting application.
     * </p>
     * 
     * @return Describes the restore behavior of a restarting application.
     */
    public final ApplicationRestoreConfiguration applicationRestoreConfigurationDescription() {
        return applicationRestoreConfigurationDescription;
    }

    /**
     * Returns the value of the FlinkRunConfigurationDescription property for this object.
     * 
     * @return The value of the FlinkRunConfigurationDescription property for this object.
     */
    public final FlinkRunConfiguration flinkRunConfigurationDescription() {
        return flinkRunConfigurationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationRestoreConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(flinkRunConfigurationDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunConfigurationDescription)) {
            return false;
        }
        RunConfigurationDescription other = (RunConfigurationDescription) obj;
        return Objects.equals(applicationRestoreConfigurationDescription(), other.applicationRestoreConfigurationDescription())
                && Objects.equals(flinkRunConfigurationDescription(), other.flinkRunConfigurationDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunConfigurationDescription")
                .add("ApplicationRestoreConfigurationDescription", applicationRestoreConfigurationDescription())
                .add("FlinkRunConfigurationDescription", flinkRunConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationRestoreConfigurationDescription":
            return Optional.ofNullable(clazz.cast(applicationRestoreConfigurationDescription()));
        case "FlinkRunConfigurationDescription":
            return Optional.ofNullable(clazz.cast(flinkRunConfigurationDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunConfigurationDescription, T> g) {
        return obj -> g.apply((RunConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunConfigurationDescription> {
        /**
         * <p>
         * Describes the restore behavior of a restarting application.
         * </p>
         * 
         * @param applicationRestoreConfigurationDescription
         *        Describes the restore behavior of a restarting application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationRestoreConfigurationDescription(
                ApplicationRestoreConfiguration applicationRestoreConfigurationDescription);

        /**
         * <p>
         * Describes the restore behavior of a restarting application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationRestoreConfiguration.Builder}
         * avoiding the need to create one manually via {@link ApplicationRestoreConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationRestoreConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationRestoreConfigurationDescription(ApplicationRestoreConfiguration)}.
         * 
         * @param applicationRestoreConfigurationDescription
         *        a consumer that will call methods on {@link ApplicationRestoreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationRestoreConfigurationDescription(ApplicationRestoreConfiguration)
         */
        default Builder applicationRestoreConfigurationDescription(
                Consumer<ApplicationRestoreConfiguration.Builder> applicationRestoreConfigurationDescription) {
            return applicationRestoreConfigurationDescription(ApplicationRestoreConfiguration.builder()
                    .applyMutation(applicationRestoreConfigurationDescription).build());
        }

        /**
         * Sets the value of the FlinkRunConfigurationDescription property for this object.
         *
         * @param flinkRunConfigurationDescription
         *        The new value for the FlinkRunConfigurationDescription property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkRunConfigurationDescription(FlinkRunConfiguration flinkRunConfigurationDescription);

        /**
         * Sets the value of the FlinkRunConfigurationDescription property for this object.
         *
         * This is a convenience that creates an instance of the {@link FlinkRunConfiguration.Builder} avoiding the need
         * to create one manually via {@link FlinkRunConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlinkRunConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #flinkRunConfigurationDescription(FlinkRunConfiguration)}.
         * 
         * @param flinkRunConfigurationDescription
         *        a consumer that will call methods on {@link FlinkRunConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkRunConfigurationDescription(FlinkRunConfiguration)
         */
        default Builder flinkRunConfigurationDescription(Consumer<FlinkRunConfiguration.Builder> flinkRunConfigurationDescription) {
            return flinkRunConfigurationDescription(FlinkRunConfiguration.builder()
                    .applyMutation(flinkRunConfigurationDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApplicationRestoreConfiguration applicationRestoreConfigurationDescription;

        private FlinkRunConfiguration flinkRunConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(RunConfigurationDescription model) {
            applicationRestoreConfigurationDescription(model.applicationRestoreConfigurationDescription);
            flinkRunConfigurationDescription(model.flinkRunConfigurationDescription);
        }

        public final ApplicationRestoreConfiguration.Builder getApplicationRestoreConfigurationDescription() {
            return applicationRestoreConfigurationDescription != null ? applicationRestoreConfigurationDescription.toBuilder()
                    : null;
        }

        @Override
        public final Builder applicationRestoreConfigurationDescription(
                ApplicationRestoreConfiguration applicationRestoreConfigurationDescription) {
            this.applicationRestoreConfigurationDescription = applicationRestoreConfigurationDescription;
            return this;
        }

        public final void setApplicationRestoreConfigurationDescription(
                ApplicationRestoreConfiguration.BuilderImpl applicationRestoreConfigurationDescription) {
            this.applicationRestoreConfigurationDescription = applicationRestoreConfigurationDescription != null ? applicationRestoreConfigurationDescription
                    .build() : null;
        }

        public final FlinkRunConfiguration.Builder getFlinkRunConfigurationDescription() {
            return flinkRunConfigurationDescription != null ? flinkRunConfigurationDescription.toBuilder() : null;
        }

        @Override
        public final Builder flinkRunConfigurationDescription(FlinkRunConfiguration flinkRunConfigurationDescription) {
            this.flinkRunConfigurationDescription = flinkRunConfigurationDescription;
            return this;
        }

        public final void setFlinkRunConfigurationDescription(FlinkRunConfiguration.BuilderImpl flinkRunConfigurationDescription) {
            this.flinkRunConfigurationDescription = flinkRunConfigurationDescription != null ? flinkRunConfigurationDescription
                    .build() : null;
        }

        @Override
        public RunConfigurationDescription build() {
            return new RunConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
