/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Property key-value pairs passed into a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyGroup implements SdkPojo, Serializable, ToCopyableBuilder<PropertyGroup.Builder, PropertyGroup> {
    private static final SdkField<String> PROPERTY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropertyGroupId").getter(getter(PropertyGroup::propertyGroupId))
            .setter(setter(Builder::propertyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyGroupId").build()).build();

    private static final SdkField<Map<String, String>> PROPERTY_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("PropertyMap")
            .getter(getter(PropertyGroup::propertyMap))
            .setter(setter(Builder::propertyMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_GROUP_ID_FIELD,
            PROPERTY_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String propertyGroupId;

    private final Map<String, String> propertyMap;

    private PropertyGroup(BuilderImpl builder) {
        this.propertyGroupId = builder.propertyGroupId;
        this.propertyMap = builder.propertyMap;
    }

    /**
     * <p>
     * Describes the key of an application execution property key-value pair.
     * </p>
     * 
     * @return Describes the key of an application execution property key-value pair.
     */
    public final String propertyGroupId() {
        return propertyGroupId;
    }

    /**
     * Returns true if the PropertyMap property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPropertyMap() {
        return propertyMap != null && !(propertyMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Describes the value of an application execution property key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPropertyMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Describes the value of an application execution property key-value pair.
     */
    public final Map<String, String> propertyMap() {
        return propertyMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(propertyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyMap() ? propertyMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyGroup)) {
            return false;
        }
        PropertyGroup other = (PropertyGroup) obj;
        return Objects.equals(propertyGroupId(), other.propertyGroupId()) && hasPropertyMap() == other.hasPropertyMap()
                && Objects.equals(propertyMap(), other.propertyMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyGroup").add("PropertyGroupId", propertyGroupId())
                .add("PropertyMap", hasPropertyMap() ? propertyMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PropertyGroupId":
            return Optional.ofNullable(clazz.cast(propertyGroupId()));
        case "PropertyMap":
            return Optional.ofNullable(clazz.cast(propertyMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyGroup, T> g) {
        return obj -> g.apply((PropertyGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyGroup> {
        /**
         * <p>
         * Describes the key of an application execution property key-value pair.
         * </p>
         * 
         * @param propertyGroupId
         *        Describes the key of an application execution property key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyGroupId(String propertyGroupId);

        /**
         * <p>
         * Describes the value of an application execution property key-value pair.
         * </p>
         * 
         * @param propertyMap
         *        Describes the value of an application execution property key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyMap(Map<String, String> propertyMap);
    }

    static final class BuilderImpl implements Builder {
        private String propertyGroupId;

        private Map<String, String> propertyMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyGroup model) {
            propertyGroupId(model.propertyGroupId);
            propertyMap(model.propertyMap);
        }

        public final String getPropertyGroupId() {
            return propertyGroupId;
        }

        @Override
        public final Builder propertyGroupId(String propertyGroupId) {
            this.propertyGroupId = propertyGroupId;
            return this;
        }

        public final void setPropertyGroupId(String propertyGroupId) {
            this.propertyGroupId = propertyGroupId;
        }

        public final Map<String, String> getPropertyMap() {
            if (propertyMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return propertyMap;
        }

        @Override
        public final Builder propertyMap(Map<String, String> propertyMap) {
            this.propertyMap = PropertyMapCopier.copy(propertyMap);
            return this;
        }

        public final void setPropertyMap(Map<String, String> propertyMap) {
            this.propertyMap = PropertyMapCopier.copy(propertyMap);
        }

        @Override
        public PropertyGroup build() {
            return new PropertyGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
