/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you configure a SQL-based Kinesis Data Analytics application's input at the time of creating or updating an
 * application, provides additional mapping information specific to the record format (such as JSON, CSV, or record
 * fields delimited by some delimiter) on the streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MappingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<MappingParameters.Builder, MappingParameters> {
    private static final SdkField<JSONMappingParameters> JSON_MAPPING_PARAMETERS_FIELD = SdkField
            .<JSONMappingParameters> builder(MarshallingType.SDK_POJO).memberName("JSONMappingParameters")
            .getter(getter(MappingParameters::jsonMappingParameters)).setter(setter(Builder::jsonMappingParameters))
            .constructor(JSONMappingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JSONMappingParameters").build())
            .build();

    private static final SdkField<CSVMappingParameters> CSV_MAPPING_PARAMETERS_FIELD = SdkField
            .<CSVMappingParameters> builder(MarshallingType.SDK_POJO).memberName("CSVMappingParameters")
            .getter(getter(MappingParameters::csvMappingParameters)).setter(setter(Builder::csvMappingParameters))
            .constructor(CSVMappingParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSVMappingParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_MAPPING_PARAMETERS_FIELD,
            CSV_MAPPING_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final JSONMappingParameters jsonMappingParameters;

    private final CSVMappingParameters csvMappingParameters;

    private MappingParameters(BuilderImpl builder) {
        this.jsonMappingParameters = builder.jsonMappingParameters;
        this.csvMappingParameters = builder.csvMappingParameters;
    }

    /**
     * <p>
     * Provides additional mapping information when JSON is the record format on the streaming source.
     * </p>
     * 
     * @return Provides additional mapping information when JSON is the record format on the streaming source.
     */
    public final JSONMappingParameters jsonMappingParameters() {
        return jsonMappingParameters;
    }

    /**
     * <p>
     * Provides additional mapping information when the record format uses delimiters (for example, CSV).
     * </p>
     * 
     * @return Provides additional mapping information when the record format uses delimiters (for example, CSV).
     */
    public final CSVMappingParameters csvMappingParameters() {
        return csvMappingParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonMappingParameters());
        hashCode = 31 * hashCode + Objects.hashCode(csvMappingParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingParameters)) {
            return false;
        }
        MappingParameters other = (MappingParameters) obj;
        return Objects.equals(jsonMappingParameters(), other.jsonMappingParameters())
                && Objects.equals(csvMappingParameters(), other.csvMappingParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MappingParameters").add("JSONMappingParameters", jsonMappingParameters())
                .add("CSVMappingParameters", csvMappingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JSONMappingParameters":
            return Optional.ofNullable(clazz.cast(jsonMappingParameters()));
        case "CSVMappingParameters":
            return Optional.ofNullable(clazz.cast(csvMappingParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MappingParameters, T> g) {
        return obj -> g.apply((MappingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MappingParameters> {
        /**
         * <p>
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * </p>
         * 
         * @param jsonMappingParameters
         *        Provides additional mapping information when JSON is the record format on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters);

        /**
         * <p>
         * Provides additional mapping information when JSON is the record format on the streaming source.
         * </p>
         * This is a convenience that creates an instance of the {@link JSONMappingParameters.Builder} avoiding the need
         * to create one manually via {@link JSONMappingParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link JSONMappingParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #jsonMappingParameters(JSONMappingParameters)}.
         * 
         * @param jsonMappingParameters
         *        a consumer that will call methods on {@link JSONMappingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonMappingParameters(JSONMappingParameters)
         */
        default Builder jsonMappingParameters(Consumer<JSONMappingParameters.Builder> jsonMappingParameters) {
            return jsonMappingParameters(JSONMappingParameters.builder().applyMutation(jsonMappingParameters).build());
        }

        /**
         * <p>
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * </p>
         * 
         * @param csvMappingParameters
         *        Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvMappingParameters(CSVMappingParameters csvMappingParameters);

        /**
         * <p>
         * Provides additional mapping information when the record format uses delimiters (for example, CSV).
         * </p>
         * This is a convenience that creates an instance of the {@link CSVMappingParameters.Builder} avoiding the need
         * to create one manually via {@link CSVMappingParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link CSVMappingParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #csvMappingParameters(CSVMappingParameters)}.
         * 
         * @param csvMappingParameters
         *        a consumer that will call methods on {@link CSVMappingParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvMappingParameters(CSVMappingParameters)
         */
        default Builder csvMappingParameters(Consumer<CSVMappingParameters.Builder> csvMappingParameters) {
            return csvMappingParameters(CSVMappingParameters.builder().applyMutation(csvMappingParameters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JSONMappingParameters jsonMappingParameters;

        private CSVMappingParameters csvMappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingParameters model) {
            jsonMappingParameters(model.jsonMappingParameters);
            csvMappingParameters(model.csvMappingParameters);
        }

        public final JSONMappingParameters.Builder getJsonMappingParameters() {
            return jsonMappingParameters != null ? jsonMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder jsonMappingParameters(JSONMappingParameters jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters;
            return this;
        }

        public final void setJsonMappingParameters(JSONMappingParameters.BuilderImpl jsonMappingParameters) {
            this.jsonMappingParameters = jsonMappingParameters != null ? jsonMappingParameters.build() : null;
        }

        public final CSVMappingParameters.Builder getCsvMappingParameters() {
            return csvMappingParameters != null ? csvMappingParameters.toBuilder() : null;
        }

        @Override
        public final Builder csvMappingParameters(CSVMappingParameters csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters;
            return this;
        }

        public final void setCsvMappingParameters(CSVMappingParameters.BuilderImpl csvMappingParameters) {
            this.csvMappingParameters = csvMappingParameters != null ? csvMappingParameters.build() : null;
        }

        @Override
        public MappingParameters build() {
            return new MappingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
