/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data format when records are written to the destination in a SQL-based Kinesis Data Analytics
 * application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DestinationSchema implements SdkPojo, Serializable,
        ToCopyableBuilder<DestinationSchema.Builder, DestinationSchema> {
    private static final SdkField<String> RECORD_FORMAT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordFormatType").getter(getter(DestinationSchema::recordFormatTypeAsString))
            .setter(setter(Builder::recordFormatType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordFormatType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FORMAT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordFormatType;

    private DestinationSchema(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
    }

    /**
     * <p>
     * Specifies the format of the records on the output stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeAsString}.
     * </p>
     * 
     * @return Specifies the format of the records on the output stream.
     * @see RecordFormatType
     */
    public final RecordFormatType recordFormatType() {
        return RecordFormatType.fromValue(recordFormatType);
    }

    /**
     * <p>
     * Specifies the format of the records on the output stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recordFormatType}
     * will return {@link RecordFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recordFormatTypeAsString}.
     * </p>
     * 
     * @return Specifies the format of the records on the output stream.
     * @see RecordFormatType
     */
    public final String recordFormatTypeAsString() {
        return recordFormatType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordFormatTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationSchema)) {
            return false;
        }
        DestinationSchema other = (DestinationSchema) obj;
        return Objects.equals(recordFormatTypeAsString(), other.recordFormatTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DestinationSchema").add("RecordFormatType", recordFormatTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordFormatType":
            return Optional.ofNullable(clazz.cast(recordFormatTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationSchema, T> g) {
        return obj -> g.apply((DestinationSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DestinationSchema> {
        /**
         * <p>
         * Specifies the format of the records on the output stream.
         * </p>
         * 
         * @param recordFormatType
         *        Specifies the format of the records on the output stream.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(String recordFormatType);

        /**
         * <p>
         * Specifies the format of the records on the output stream.
         * </p>
         * 
         * @param recordFormatType
         *        Specifies the format of the records on the output stream.
         * @see RecordFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordFormatType
         */
        Builder recordFormatType(RecordFormatType recordFormatType);
    }

    static final class BuilderImpl implements Builder {
        private String recordFormatType;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationSchema model) {
            recordFormatType(model.recordFormatType);
        }

        public final String getRecordFormatType() {
            return recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType == null ? null : recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        @Override
        public DestinationSchema build() {
            return new DestinationSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
