/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the creation parameters for a Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationConfiguration.Builder, ApplicationConfiguration> {
    private static final SdkField<SqlApplicationConfiguration> SQL_APPLICATION_CONFIGURATION_FIELD = SdkField
            .<SqlApplicationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SqlApplicationConfiguration")
            .getter(getter(ApplicationConfiguration::sqlApplicationConfiguration))
            .setter(setter(Builder::sqlApplicationConfiguration))
            .constructor(SqlApplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfiguration")
                    .build()).build();

    private static final SdkField<FlinkApplicationConfiguration> FLINK_APPLICATION_CONFIGURATION_FIELD = SdkField
            .<FlinkApplicationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("FlinkApplicationConfiguration")
            .getter(getter(ApplicationConfiguration::flinkApplicationConfiguration))
            .setter(setter(Builder::flinkApplicationConfiguration))
            .constructor(FlinkApplicationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkApplicationConfiguration")
                    .build()).build();

    private static final SdkField<EnvironmentProperties> ENVIRONMENT_PROPERTIES_FIELD = SdkField
            .<EnvironmentProperties> builder(MarshallingType.SDK_POJO).memberName("EnvironmentProperties")
            .getter(getter(ApplicationConfiguration::environmentProperties)).setter(setter(Builder::environmentProperties))
            .constructor(EnvironmentProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentProperties").build())
            .build();

    private static final SdkField<ApplicationCodeConfiguration> APPLICATION_CODE_CONFIGURATION_FIELD = SdkField
            .<ApplicationCodeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationCodeConfiguration")
            .getter(getter(ApplicationConfiguration::applicationCodeConfiguration))
            .setter(setter(Builder::applicationCodeConfiguration))
            .constructor(ApplicationCodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfiguration")
                    .build()).build();

    private static final SdkField<ApplicationSnapshotConfiguration> APPLICATION_SNAPSHOT_CONFIGURATION_FIELD = SdkField
            .<ApplicationSnapshotConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ApplicationSnapshotConfiguration")
            .getter(getter(ApplicationConfiguration::applicationSnapshotConfiguration))
            .setter(setter(Builder::applicationSnapshotConfiguration))
            .constructor(ApplicationSnapshotConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSnapshotConfiguration")
                    .build()).build();

    private static final SdkField<List<VpcConfiguration>> VPC_CONFIGURATIONS_FIELD = SdkField
            .<List<VpcConfiguration>> builder(MarshallingType.LIST)
            .memberName("VpcConfigurations")
            .getter(getter(ApplicationConfiguration::vpcConfigurations))
            .setter(setter(Builder::vpcConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SQL_APPLICATION_CONFIGURATION_FIELD, FLINK_APPLICATION_CONFIGURATION_FIELD, ENVIRONMENT_PROPERTIES_FIELD,
            APPLICATION_CODE_CONFIGURATION_FIELD, APPLICATION_SNAPSHOT_CONFIGURATION_FIELD, VPC_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final SqlApplicationConfiguration sqlApplicationConfiguration;

    private final FlinkApplicationConfiguration flinkApplicationConfiguration;

    private final EnvironmentProperties environmentProperties;

    private final ApplicationCodeConfiguration applicationCodeConfiguration;

    private final ApplicationSnapshotConfiguration applicationSnapshotConfiguration;

    private final List<VpcConfiguration> vpcConfigurations;

    private ApplicationConfiguration(BuilderImpl builder) {
        this.sqlApplicationConfiguration = builder.sqlApplicationConfiguration;
        this.flinkApplicationConfiguration = builder.flinkApplicationConfiguration;
        this.environmentProperties = builder.environmentProperties;
        this.applicationCodeConfiguration = builder.applicationCodeConfiguration;
        this.applicationSnapshotConfiguration = builder.applicationSnapshotConfiguration;
        this.vpcConfigurations = builder.vpcConfigurations;
    }

    /**
     * <p>
     * The creation and update parameters for a SQL-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return The creation and update parameters for a SQL-based Kinesis Data Analytics application.
     */
    public final SqlApplicationConfiguration sqlApplicationConfiguration() {
        return sqlApplicationConfiguration;
    }

    /**
     * <p>
     * The creation and update parameters for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return The creation and update parameters for a Flink-based Kinesis Data Analytics application.
     */
    public final FlinkApplicationConfiguration flinkApplicationConfiguration() {
        return flinkApplicationConfiguration;
    }

    /**
     * <p>
     * Describes execution properties for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes execution properties for a Flink-based Kinesis Data Analytics application.
     */
    public final EnvironmentProperties environmentProperties() {
        return environmentProperties;
    }

    /**
     * <p>
     * The code location and type parameters for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return The code location and type parameters for a Flink-based Kinesis Data Analytics application.
     */
    public final ApplicationCodeConfiguration applicationCodeConfiguration() {
        return applicationCodeConfiguration;
    }

    /**
     * <p>
     * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     * </p>
     * 
     * @return Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
     */
    public final ApplicationSnapshotConfiguration applicationSnapshotConfiguration() {
        return applicationSnapshotConfiguration;
    }

    /**
     * Returns true if the VpcConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVpcConfigurations() {
        return vpcConfigurations != null && !(vpcConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of descriptions of VPC configurations available to the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The array of descriptions of VPC configurations available to the application.
     */
    public final List<VpcConfiguration> vpcConfigurations() {
        return vpcConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlApplicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(flinkApplicationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(environmentProperties());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCodeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(applicationSnapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcConfigurations() ? vpcConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfiguration)) {
            return false;
        }
        ApplicationConfiguration other = (ApplicationConfiguration) obj;
        return Objects.equals(sqlApplicationConfiguration(), other.sqlApplicationConfiguration())
                && Objects.equals(flinkApplicationConfiguration(), other.flinkApplicationConfiguration())
                && Objects.equals(environmentProperties(), other.environmentProperties())
                && Objects.equals(applicationCodeConfiguration(), other.applicationCodeConfiguration())
                && Objects.equals(applicationSnapshotConfiguration(), other.applicationSnapshotConfiguration())
                && hasVpcConfigurations() == other.hasVpcConfigurations()
                && Objects.equals(vpcConfigurations(), other.vpcConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationConfiguration").add("SqlApplicationConfiguration", sqlApplicationConfiguration())
                .add("FlinkApplicationConfiguration", flinkApplicationConfiguration())
                .add("EnvironmentProperties", environmentProperties())
                .add("ApplicationCodeConfiguration", applicationCodeConfiguration())
                .add("ApplicationSnapshotConfiguration", applicationSnapshotConfiguration())
                .add("VpcConfigurations", hasVpcConfigurations() ? vpcConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SqlApplicationConfiguration":
            return Optional.ofNullable(clazz.cast(sqlApplicationConfiguration()));
        case "FlinkApplicationConfiguration":
            return Optional.ofNullable(clazz.cast(flinkApplicationConfiguration()));
        case "EnvironmentProperties":
            return Optional.ofNullable(clazz.cast(environmentProperties()));
        case "ApplicationCodeConfiguration":
            return Optional.ofNullable(clazz.cast(applicationCodeConfiguration()));
        case "ApplicationSnapshotConfiguration":
            return Optional.ofNullable(clazz.cast(applicationSnapshotConfiguration()));
        case "VpcConfigurations":
            return Optional.ofNullable(clazz.cast(vpcConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfiguration, T> g) {
        return obj -> g.apply((ApplicationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationConfiguration> {
        /**
         * <p>
         * The creation and update parameters for a SQL-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param sqlApplicationConfiguration
         *        The creation and update parameters for a SQL-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlApplicationConfiguration(SqlApplicationConfiguration sqlApplicationConfiguration);

        /**
         * <p>
         * The creation and update parameters for a SQL-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link SqlApplicationConfiguration.Builder} avoiding
         * the need to create one manually via {@link SqlApplicationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlApplicationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sqlApplicationConfiguration(SqlApplicationConfiguration)}.
         * 
         * @param sqlApplicationConfiguration
         *        a consumer that will call methods on {@link SqlApplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlApplicationConfiguration(SqlApplicationConfiguration)
         */
        default Builder sqlApplicationConfiguration(Consumer<SqlApplicationConfiguration.Builder> sqlApplicationConfiguration) {
            return sqlApplicationConfiguration(SqlApplicationConfiguration.builder().applyMutation(sqlApplicationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The creation and update parameters for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param flinkApplicationConfiguration
         *        The creation and update parameters for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flinkApplicationConfiguration(FlinkApplicationConfiguration flinkApplicationConfiguration);

        /**
         * <p>
         * The creation and update parameters for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link FlinkApplicationConfiguration.Builder} avoiding
         * the need to create one manually via {@link FlinkApplicationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlinkApplicationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #flinkApplicationConfiguration(FlinkApplicationConfiguration)}
         * .
         * 
         * @param flinkApplicationConfiguration
         *        a consumer that will call methods on {@link FlinkApplicationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flinkApplicationConfiguration(FlinkApplicationConfiguration)
         */
        default Builder flinkApplicationConfiguration(
                Consumer<FlinkApplicationConfiguration.Builder> flinkApplicationConfiguration) {
            return flinkApplicationConfiguration(FlinkApplicationConfiguration.builder()
                    .applyMutation(flinkApplicationConfiguration).build());
        }

        /**
         * <p>
         * Describes execution properties for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param environmentProperties
         *        Describes execution properties for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentProperties(EnvironmentProperties environmentProperties);

        /**
         * <p>
         * Describes execution properties for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link EnvironmentProperties.Builder} avoiding the need
         * to create one manually via {@link EnvironmentProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link EnvironmentProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #environmentProperties(EnvironmentProperties)}.
         * 
         * @param environmentProperties
         *        a consumer that will call methods on {@link EnvironmentProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentProperties(EnvironmentProperties)
         */
        default Builder environmentProperties(Consumer<EnvironmentProperties.Builder> environmentProperties) {
            return environmentProperties(EnvironmentProperties.builder().applyMutation(environmentProperties).build());
        }

        /**
         * <p>
         * The code location and type parameters for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param applicationCodeConfiguration
         *        The code location and type parameters for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCodeConfiguration(ApplicationCodeConfiguration applicationCodeConfiguration);

        /**
         * <p>
         * The code location and type parameters for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationCodeConfiguration.Builder} avoiding
         * the need to create one manually via {@link ApplicationCodeConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationCodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #applicationCodeConfiguration(ApplicationCodeConfiguration)}.
         * 
         * @param applicationCodeConfiguration
         *        a consumer that will call methods on {@link ApplicationCodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationCodeConfiguration(ApplicationCodeConfiguration)
         */
        default Builder applicationCodeConfiguration(Consumer<ApplicationCodeConfiguration.Builder> applicationCodeConfiguration) {
            return applicationCodeConfiguration(ApplicationCodeConfiguration.builder()
                    .applyMutation(applicationCodeConfiguration).build());
        }

        /**
         * <p>
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * 
         * @param applicationSnapshotConfiguration
         *        Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSnapshotConfiguration(ApplicationSnapshotConfiguration applicationSnapshotConfiguration);

        /**
         * <p>
         * Describes whether snapshots are enabled for a Flink-based Kinesis Data Analytics application.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSnapshotConfiguration.Builder}
         * avoiding the need to create one manually via {@link ApplicationSnapshotConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSnapshotConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #applicationSnapshotConfiguration(ApplicationSnapshotConfiguration)}.
         * 
         * @param applicationSnapshotConfiguration
         *        a consumer that will call methods on {@link ApplicationSnapshotConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSnapshotConfiguration(ApplicationSnapshotConfiguration)
         */
        default Builder applicationSnapshotConfiguration(
                Consumer<ApplicationSnapshotConfiguration.Builder> applicationSnapshotConfiguration) {
            return applicationSnapshotConfiguration(ApplicationSnapshotConfiguration.builder()
                    .applyMutation(applicationSnapshotConfiguration).build());
        }

        /**
         * <p>
         * The array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurations
         *        The array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurations(Collection<VpcConfiguration> vpcConfigurations);

        /**
         * <p>
         * The array of descriptions of VPC configurations available to the application.
         * </p>
         * 
         * @param vpcConfigurations
         *        The array of descriptions of VPC configurations available to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfigurations(VpcConfiguration... vpcConfigurations);

        /**
         * <p>
         * The array of descriptions of VPC configurations available to the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<VpcConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcConfiguration>.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcConfigurations(List<VpcConfiguration>)}.
         * 
         * @param vpcConfigurations
         *        a consumer that will call methods on {@link List<VpcConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfigurations(List<VpcConfiguration>)
         */
        Builder vpcConfigurations(Consumer<VpcConfiguration.Builder>... vpcConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private SqlApplicationConfiguration sqlApplicationConfiguration;

        private FlinkApplicationConfiguration flinkApplicationConfiguration;

        private EnvironmentProperties environmentProperties;

        private ApplicationCodeConfiguration applicationCodeConfiguration;

        private ApplicationSnapshotConfiguration applicationSnapshotConfiguration;

        private List<VpcConfiguration> vpcConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfiguration model) {
            sqlApplicationConfiguration(model.sqlApplicationConfiguration);
            flinkApplicationConfiguration(model.flinkApplicationConfiguration);
            environmentProperties(model.environmentProperties);
            applicationCodeConfiguration(model.applicationCodeConfiguration);
            applicationSnapshotConfiguration(model.applicationSnapshotConfiguration);
            vpcConfigurations(model.vpcConfigurations);
        }

        public final SqlApplicationConfiguration.Builder getSqlApplicationConfiguration() {
            return sqlApplicationConfiguration != null ? sqlApplicationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sqlApplicationConfiguration(SqlApplicationConfiguration sqlApplicationConfiguration) {
            this.sqlApplicationConfiguration = sqlApplicationConfiguration;
            return this;
        }

        public final void setSqlApplicationConfiguration(SqlApplicationConfiguration.BuilderImpl sqlApplicationConfiguration) {
            this.sqlApplicationConfiguration = sqlApplicationConfiguration != null ? sqlApplicationConfiguration.build() : null;
        }

        public final FlinkApplicationConfiguration.Builder getFlinkApplicationConfiguration() {
            return flinkApplicationConfiguration != null ? flinkApplicationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder flinkApplicationConfiguration(FlinkApplicationConfiguration flinkApplicationConfiguration) {
            this.flinkApplicationConfiguration = flinkApplicationConfiguration;
            return this;
        }

        public final void setFlinkApplicationConfiguration(FlinkApplicationConfiguration.BuilderImpl flinkApplicationConfiguration) {
            this.flinkApplicationConfiguration = flinkApplicationConfiguration != null ? flinkApplicationConfiguration.build()
                    : null;
        }

        public final EnvironmentProperties.Builder getEnvironmentProperties() {
            return environmentProperties != null ? environmentProperties.toBuilder() : null;
        }

        @Override
        public final Builder environmentProperties(EnvironmentProperties environmentProperties) {
            this.environmentProperties = environmentProperties;
            return this;
        }

        public final void setEnvironmentProperties(EnvironmentProperties.BuilderImpl environmentProperties) {
            this.environmentProperties = environmentProperties != null ? environmentProperties.build() : null;
        }

        public final ApplicationCodeConfiguration.Builder getApplicationCodeConfiguration() {
            return applicationCodeConfiguration != null ? applicationCodeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder applicationCodeConfiguration(ApplicationCodeConfiguration applicationCodeConfiguration) {
            this.applicationCodeConfiguration = applicationCodeConfiguration;
            return this;
        }

        public final void setApplicationCodeConfiguration(ApplicationCodeConfiguration.BuilderImpl applicationCodeConfiguration) {
            this.applicationCodeConfiguration = applicationCodeConfiguration != null ? applicationCodeConfiguration.build()
                    : null;
        }

        public final ApplicationSnapshotConfiguration.Builder getApplicationSnapshotConfiguration() {
            return applicationSnapshotConfiguration != null ? applicationSnapshotConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder applicationSnapshotConfiguration(ApplicationSnapshotConfiguration applicationSnapshotConfiguration) {
            this.applicationSnapshotConfiguration = applicationSnapshotConfiguration;
            return this;
        }

        public final void setApplicationSnapshotConfiguration(
                ApplicationSnapshotConfiguration.BuilderImpl applicationSnapshotConfiguration) {
            this.applicationSnapshotConfiguration = applicationSnapshotConfiguration != null ? applicationSnapshotConfiguration
                    .build() : null;
        }

        public final Collection<VpcConfiguration.Builder> getVpcConfigurations() {
            if (vpcConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcConfigurations != null ? vpcConfigurations.stream().map(VpcConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcConfigurations(Collection<VpcConfiguration> vpcConfigurations) {
            this.vpcConfigurations = VpcConfigurationsCopier.copy(vpcConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurations(VpcConfiguration... vpcConfigurations) {
            vpcConfigurations(Arrays.asList(vpcConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurations(Consumer<VpcConfiguration.Builder>... vpcConfigurations) {
            vpcConfigurations(Stream.of(vpcConfigurations).map(c -> VpcConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVpcConfigurations(Collection<VpcConfiguration.BuilderImpl> vpcConfigurations) {
            this.vpcConfigurations = VpcConfigurationsCopier.copyFromBuilder(vpcConfigurations);
        }

        @Override
        public ApplicationConfiguration build() {
            return new ApplicationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
