/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes code configuration for a Flink-based Kinesis Data Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationCodeConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationCodeConfigurationDescription.Builder, ApplicationCodeConfigurationDescription> {
    private static final SdkField<String> CODE_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeContentType").getter(getter(ApplicationCodeConfigurationDescription::codeContentTypeAsString))
            .setter(setter(Builder::codeContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentType").build()).build();

    private static final SdkField<CodeContentDescription> CODE_CONTENT_DESCRIPTION_FIELD = SdkField
            .<CodeContentDescription> builder(MarshallingType.SDK_POJO).memberName("CodeContentDescription")
            .getter(getter(ApplicationCodeConfigurationDescription::codeContentDescription))
            .setter(setter(Builder::codeContentDescription)).constructor(CodeContentDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_CONTENT_TYPE_FIELD,
            CODE_CONTENT_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codeContentType;

    private final CodeContentDescription codeContentDescription;

    private ApplicationCodeConfigurationDescription(BuilderImpl builder) {
        this.codeContentType = builder.codeContentType;
        this.codeContentDescription = builder.codeContentDescription;
    }

    /**
     * <p>
     * Specifies whether the code content is in text or zip format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codeContentType}
     * will return {@link CodeContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeContentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the code content is in text or zip format.
     * @see CodeContentType
     */
    public final CodeContentType codeContentType() {
        return CodeContentType.fromValue(codeContentType);
    }

    /**
     * <p>
     * Specifies whether the code content is in text or zip format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codeContentType}
     * will return {@link CodeContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeContentTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the code content is in text or zip format.
     * @see CodeContentType
     */
    public final String codeContentTypeAsString() {
        return codeContentType;
    }

    /**
     * <p>
     * Describes details about the location and format of the application code.
     * </p>
     * 
     * @return Describes details about the location and format of the application code.
     */
    public final CodeContentDescription codeContentDescription() {
        return codeContentDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codeContentDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCodeConfigurationDescription)) {
            return false;
        }
        ApplicationCodeConfigurationDescription other = (ApplicationCodeConfigurationDescription) obj;
        return Objects.equals(codeContentTypeAsString(), other.codeContentTypeAsString())
                && Objects.equals(codeContentDescription(), other.codeContentDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationCodeConfigurationDescription").add("CodeContentType", codeContentTypeAsString())
                .add("CodeContentDescription", codeContentDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeContentType":
            return Optional.ofNullable(clazz.cast(codeContentTypeAsString()));
        case "CodeContentDescription":
            return Optional.ofNullable(clazz.cast(codeContentDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCodeConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationCodeConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationCodeConfigurationDescription> {
        /**
         * <p>
         * Specifies whether the code content is in text or zip format.
         * </p>
         * 
         * @param codeContentType
         *        Specifies whether the code content is in text or zip format.
         * @see CodeContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeContentType
         */
        Builder codeContentType(String codeContentType);

        /**
         * <p>
         * Specifies whether the code content is in text or zip format.
         * </p>
         * 
         * @param codeContentType
         *        Specifies whether the code content is in text or zip format.
         * @see CodeContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeContentType
         */
        Builder codeContentType(CodeContentType codeContentType);

        /**
         * <p>
         * Describes details about the location and format of the application code.
         * </p>
         * 
         * @param codeContentDescription
         *        Describes details about the location and format of the application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeContentDescription(CodeContentDescription codeContentDescription);

        /**
         * <p>
         * Describes details about the location and format of the application code.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeContentDescription.Builder} avoiding the
         * need to create one manually via {@link CodeContentDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeContentDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #codeContentDescription(CodeContentDescription)}.
         * 
         * @param codeContentDescription
         *        a consumer that will call methods on {@link CodeContentDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeContentDescription(CodeContentDescription)
         */
        default Builder codeContentDescription(Consumer<CodeContentDescription.Builder> codeContentDescription) {
            return codeContentDescription(CodeContentDescription.builder().applyMutation(codeContentDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String codeContentType;

        private CodeContentDescription codeContentDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCodeConfigurationDescription model) {
            codeContentType(model.codeContentType);
            codeContentDescription(model.codeContentDescription);
        }

        public final String getCodeContentType() {
            return codeContentType;
        }

        @Override
        public final Builder codeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
            return this;
        }

        @Override
        public final Builder codeContentType(CodeContentType codeContentType) {
            this.codeContentType(codeContentType == null ? null : codeContentType.toString());
            return this;
        }

        public final void setCodeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
        }

        public final CodeContentDescription.Builder getCodeContentDescription() {
            return codeContentDescription != null ? codeContentDescription.toBuilder() : null;
        }

        @Override
        public final Builder codeContentDescription(CodeContentDescription codeContentDescription) {
            this.codeContentDescription = codeContentDescription;
            return this;
        }

        public final void setCodeContentDescription(CodeContentDescription.BuilderImpl codeContentDescription) {
            this.codeContentDescription = codeContentDescription != null ? codeContentDescription.build() : null;
        }

        @Override
        public ApplicationCodeConfigurationDescription build() {
            return new ApplicationCodeConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
